/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.AbstractTradingBlock;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.menu.bartering.BarteringMenu;
import com.epherical.shoppy.menu.bartering.BarteringMenuOwner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BarteringBlockEntity
extends AbstractTradingBlockEntity {
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    private static final int[] SLOTS_FOR_REST = new int[]{4};
    ItemStack currency;
    int currencyStored = 0;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int data) {
            return switch (data) {
                case 0 -> BarteringBlockEntity.this.currency.m_41613_();
                case 1 -> BarteringBlockEntity.this.selling.m_41613_();
                case 2 -> BarteringBlockEntity.this.currencyStored;
                case 3 -> BarteringBlockEntity.this.storedSellingItems;
                default -> 0;
            };
        }

        public void m_8050_(int key, int value) {
            switch (key) {
                case 0: {
                    BarteringBlockEntity.this.currency.m_41764_(value);
                    break;
                }
                case 1: {
                    BarteringBlockEntity.this.selling.m_41764_(value);
                    break;
                }
                case 2: {
                    BarteringBlockEntity.this.currencyStored = value;
                    break;
                }
                case 3: {
                    BarteringBlockEntity.this.storedSellingItems = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public BarteringBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ShoppyMod.BARTING_STATION_ENTITY, blockPos, blockState);
        this.currency = ItemStack.f_41583_;
    }

    public BarteringBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
        this.currency = ItemStack.f_41583_;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.currency = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("currency"));
        this.currencyStored = compoundTag.m_128451_("storedCurrency");
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("currency", (Tag)this.currency.m_41739_(new CompoundTag()));
        compoundTag.m_128405_("storedCurrency", this.currencyStored);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.shoppy.bartering_station");
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.currency = ItemStack.f_41583_;
        this.currencyStored = 0;
        this.markUpdated();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("currency", (Tag)this.currency.m_41739_(new CompoundTag()));
        tag.m_128365_("selling", (Tag)this.selling.m_41739_(new CompoundTag()));
        tag.m_128362_("owner", this.owner);
        return tag;
    }

    public void addCurrencyItem(ItemStack item) {
        this.currency = item;
        this.markUpdated();
    }

    @Override
    public void clearShop(BlockHitResult result) {
        super.clearShop(result);
        this.currency = ItemStack.f_41583_;
        this.currencyStored = 0;
        this.markUpdated();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean attemptPurchase(Player player, boolean creativeBlock) {
        block11: {
            int price;
            ItemStack currencyInHand;
            block12: {
                int amountToGive;
                ServerPlayer owner;
                block13: {
                    Inventory inventory = player.m_150109_();
                    currencyInHand = ItemStack.f_41583_;
                    try {
                        currencyInHand = inventory.m_8020_(inventory.m_36030_(this.currency));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    owner = this.f_58857_.m_7654_().m_6846_().m_11259_(this.owner);
                    if (!ItemStack.m_150942_((ItemStack)currencyInHand, (ItemStack)this.currency)) {
                        MutableComponent component = Component.m_237115_((String)"barter.purchase.no_held_item");
                        component.m_6270_(ShoppyMod.ERROR_STYLE);
                        player.m_213846_((Component)component);
                        this.markUpdated();
                        return false;
                    }
                    price = this.currency.m_41613_();
                    if (currencyInHand.m_41613_() < price) break block12;
                    amountToGive = this.selling.m_41613_();
                    if (amountToGive <= this.storedSellingItems) break block13;
                    MutableComponent buyerMsg = Component.m_237115_((String)"barter.purchase.shop_empty").m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)buyerMsg);
                    if (owner != null) {
                        MutableComponent location = Component.m_237110_((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()}).m_6270_(ShoppyMod.VARIABLE_STYLE);
                        MutableComponent ownerMsg = Component.m_237110_((String)"barter.purchase.owner.shop_empty", (Object[])new Object[]{location}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                        owner.m_213846_((Component)ownerMsg);
                    }
                    break block11;
                }
                if (this.remainingCurrencySpaces() <= 0 && !creativeBlock) {
                    MutableComponent buyerMsg = Component.m_237110_((String)"barter.purchase.currency_full", (Object[])new Object[]{this.currency.m_41611_()}).m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)buyerMsg);
                    if (owner != null && !creativeBlock) {
                        MutableComponent location = Component.m_237110_((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()}).m_6270_(ShoppyMod.VARIABLE_STYLE);
                        MutableComponent ownerMsg = Component.m_237110_((String)"barter.purchase.owner.currency_full", (Object[])new Object[]{location}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                        owner.m_213846_((Component)ownerMsg);
                    }
                    break block11;
                } else if (player.m_150109_().m_36062_() == -1) {
                    MutableComponent component = Component.m_237115_((String)"common.purchase.full_inventory").m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)component);
                    break block11;
                } else {
                    currencyInHand.m_41774_(price);
                    player.m_36356_(this.selling.m_41777_());
                    MutableComponent buyer = Component.m_237110_((String)"barter.purchase.transaction_success", (Object[])new Object[]{this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
                    player.m_213846_((Component)buyer);
                    if (!creativeBlock) {
                        this.storedSellingItems -= amountToGive;
                        this.currencyStored += price;
                    }
                    if (owner != null) {
                        MutableComponent sellerMsg = Component.m_237110_((String)"barter.purchase.owner.transaction_success", (Object[])new Object[]{player.m_5446_(), this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
                        owner.m_213846_((Component)sellerMsg);
                    }
                    this.markUpdated();
                    return true;
                }
            }
            MutableComponent required = Component.m_237113_((String)("x" + price)).m_6270_(ShoppyMod.VARIABLE_STYLE);
            MutableComponent had = Component.m_237113_((String)("x" + currencyInHand.m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
            MutableComponent component = Component.m_237110_((String)"barter.purchase.not_enough_items", (Object[])new Object[]{required, had});
            component.m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)component);
        }
        this.markUpdated();
        return false;
    }

    @Override
    public NonNullList<ItemStack> dropItems() {
        NonNullList list = NonNullList.m_122779_();
        list.addAll(super.dropItems());
        int currency = this.currencyStored;
        int maxStackSize = this.currency.m_41741_();
        while (currency != 0) {
            ItemStack copy = this.currency.m_41777_();
            if (currency >= maxStackSize) {
                copy.m_41764_(maxStackSize);
                list.add((Object)copy);
                currency -= maxStackSize;
                continue;
            }
            copy.m_41764_(currency);
            list.add((Object)copy);
            currency -= currency;
        }
        return list;
    }

    public int remainingCurrencySpaces() {
        return this.maxStorage - this.currencyStored;
    }

    @Override
    public int remainingItemStorage() {
        return this.maxStorage - this.storedSellingItems;
    }

    public ItemStack getCurrency() {
        return this.currency;
    }

    @Override
    public void sendInformationToOwner(Player player) {
        MutableComponent component = Component.m_237115_((String)"barter.information.owner.extraction").m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)component);
        MutableComponent profits = Component.m_237113_((String)("" + this.currencyStored)).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent translatedProfits = Component.m_237110_((String)"barter.information.owner.profits", (Object[])new Object[]{profits}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        MutableComponent storedItems = Component.m_237113_((String)("" + this.storedSellingItems)).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent toBeSold = Component.m_237110_((String)"barter.information.owner.barter", (Object[])new Object[]{storedItems}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)translatedProfits);
        player.m_213846_((Component)toBeSold);
    }

    @Override
    public InteractionResult interactWithTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Vec3 hit = blockHitResult.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)blockPos));
        ItemStack item = player.m_21205_();
        if (player.m_6047_() && hit.m_7098_() > 0.5) {
            this.clearShop(blockHitResult);
            return InteractionResult.SUCCESS;
        }
        boolean sameItem = ItemStack.m_150942_((ItemStack)this.getCurrency(), (ItemStack)item);
        if (hit.m_7098_() <= 0.5 && (this.getCurrency().m_41619_() || sameItem)) {
            if (item.m_41613_() == 1 && sameItem) {
                if (this.currency.m_41613_() < this.currency.m_41741_()) {
                    this.currency.m_41764_(this.currency.m_41613_() + 1);
                }
                this.markUpdated();
                return InteractionResult.SUCCESS;
            }
            this.addCurrencyItem(item.m_41777_());
            MutableComponent setup = Component.m_237110_((String)"barter.setup.owner.add_currency", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
            player.m_213846_((Component)setup);
            return InteractionResult.SUCCESS;
        }
        if (hit.m_7098_() > 0.5) {
            if (this.getSelling().m_41619_()) {
                this.addSellingItem(item.m_41777_());
                MutableComponent setup = Component.m_237110_((String)"barter.setup.owner.add_selling", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                player.m_213846_((Component)setup);
            } else if (ItemStack.m_150942_((ItemStack)item, (ItemStack)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void userLeftClickTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        MutableComponent amountBeingSold = Component.m_237113_((String)("x" + this.getSelling().m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent itemBeingSold = this.getSelling().m_41611_().m_6881_().m_130938_(style -> {
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.getSelling())));
            return style;
        });
        MutableComponent currencyAmount = Component.m_237113_((String)("x" + this.getCurrency().m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent itemBeingTraded = this.getCurrency().m_41611_().m_6881_().m_130938_(style -> {
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.getCurrency())));
            return style;
        });
        MutableComponent component = Component.m_237110_((String)"barter.information.user.selling_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount, itemBeingTraded}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)component);
    }

    @Override
    public void extractItemsFromShop(Level level, BlockPos pos) {
        if (this.remainingCurrencySpaces() != this.maxStorage) {
            int itemsToTake = Math.min(64, this.currencyStored);
            ItemStack currency = this.getCurrency().m_41777_();
            currency.m_41764_(itemsToTake);
            AbstractTradingBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)currency);
            this.currencyStored -= itemsToTake;
        } else {
            super.extractItemsFromShop(level, pos);
        }
    }

    public boolean emptyProfits(ServerPlayer player) {
        int itemsToTake = Math.min(64, this.currencyStored);
        ItemStack currency = this.getCurrency().m_41777_();
        currency.m_41764_(itemsToTake);
        this.currencyStored -= itemsToTake;
        if (!player.m_36356_(currency)) {
            this.currencyStored += currency.m_41613_();
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.getOwner().equals(player.m_20148_())) {
            return BarteringMenuOwner.realContainer(i, inventory, this, this.data);
        }
        return BarteringMenu.realContainer(i, inventory, this, this.data);
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return null;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.currency.m_41619_() && this.selling.m_41619_();
    }

    public ItemStack m_8020_(int pSlot) {
        ItemStack item;
        int take;
        if (pSlot == 1) {
            take = this.currencyStored;
            item = this.getCurrency().m_41777_();
        } else if (pSlot == 0) {
            take = this.storedSellingItems;
            item = this.getSelling().m_41777_();
        } else if (pSlot == 2) {
            item = this.getCurrency();
            take = this.getCurrency().m_41613_();
        } else if (pSlot == 3) {
            item = this.getSelling();
            take = this.getSelling().m_41613_();
        } else if (pSlot == 4) {
            take = this.storedSellingItems < this.maxStorage ? 1 : this.storedSellingItems;
            item = this.getSelling().m_41777_();
        } else {
            return ItemStack.f_41583_;
        }
        item.m_41764_(take);
        return item;
    }

    public ItemStack m_7407_(int slot, int amountToRemove) {
        ItemStack item = this.m_8020_(slot);
        if (slot == 1) {
            this.currencyStored -= amountToRemove;
        } else if (slot == 0) {
            this.storedSellingItems -= amountToRemove;
        }
        this.markUpdated();
        return item.m_41620_(amountToRemove);
    }

    public ItemStack m_8016_(int slot) {
        return this.m_7407_(slot, 64);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 2) {
            this.currency = stack;
        } else if (slot == 3) {
            this.selling = stack;
        } else if (slot == 0 || slot == 4) {
            this.storedSellingItems += stack.m_41613_();
        }
        this.markUpdated();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_REST;
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        if (this.storedSellingItems <= this.maxStorage && i == 0 || i == 4 && direction != null && direction != Direction.DOWN && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.selling)) {
            this.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return direction == Direction.DOWN && i == 1;
    }
}

