/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractTradingBlockEntity
extends BaseContainerBlockEntity
implements Clearable,
MenuConstructor,
Container,
WorldlyContainer {
    protected int transaction;
    protected UUID owner = Util.f_137441_;
    protected ItemStack selling = ItemStack.f_41583_;
    protected int storedSellingItems = 0;
    protected int maxStorage = 3456;

    public AbstractTradingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.transaction = compoundTag.m_128451_("transactions");
        this.owner = compoundTag.m_128342_("owner");
        this.selling = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("selling"));
        this.storedSellingItems = compoundTag.m_128451_("storedItems");
        this.maxStorage = compoundTag.m_128451_("maxStorage");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("transactions", this.transaction);
        compoundTag.m_128362_("owner", this.owner);
        compoundTag.m_128365_("selling", (Tag)this.selling.m_41739_(new CompoundTag()));
        compoundTag.m_128405_("storedItems", this.storedSellingItems);
        compoundTag.m_128405_("maxStorage", this.maxStorage);
    }

    public void m_6211_() {
        this.transaction = 0;
        this.storedSellingItems = 0;
        this.selling = ItemStack.f_41583_;
    }

    public void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public abstract boolean attemptPurchase(Player var1, boolean var2);

    public abstract void sendInformationToOwner(Player var1);

    public abstract InteractionResult interactWithTradingBlock(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6);

    public abstract void userLeftClickTradingBlock(BlockState var1, Level var2, BlockPos var3, Player var4);

    public int putItemIntoShop(ItemStack item) {
        if (!item.m_41619_()) {
            if (this.storedSellingItems > this.maxStorage) {
                return 0;
            }
            int itemsInserted = Math.min(item.m_41613_(), this.remainingItemStorage());
            this.storedSellingItems += itemsInserted;
            item.m_41774_(itemsInserted);
            this.markUpdated();
            return itemsInserted;
        }
        return 0;
    }

    public void extractItemsFromShop(Level level, BlockPos pos) {
        int itemsToTake = Math.min(64, this.storedSellingItems);
        ItemStack selling = this.getSelling().m_41777_();
        selling.m_41764_(itemsToTake);
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)selling);
        this.storedSellingItems -= itemsToTake;
    }

    public void clearShop(BlockHitResult result) {
        for (ItemStack stack : this.dropItems()) {
            Block.m_152435_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Direction)result.m_82434_(), (ItemStack)stack);
        }
        this.selling = ItemStack.f_41583_;
        this.storedSellingItems = 0;
        this.markUpdated();
    }

    public NonNullList<ItemStack> dropItems() {
        NonNullList list = NonNullList.m_122779_();
        int itemsStored = this.storedSellingItems;
        int maxStackSize = this.selling.m_41741_();
        while (itemsStored != 0) {
            ItemStack copy = this.selling.m_41777_();
            if (itemsStored >= maxStackSize) {
                copy.m_41764_(maxStackSize);
                list.add((Object)copy);
                itemsStored -= maxStackSize;
                continue;
            }
            copy.m_41764_(itemsStored);
            list.add((Object)copy);
            itemsStored -= itemsStored;
        }
        return list;
    }

    public boolean emptyItemsToBeSold(ServerPlayer player) {
        int itemsToTake = Math.min(64, this.storedSellingItems);
        ItemStack selling = this.getSelling().m_41777_();
        selling.m_41764_(itemsToTake);
        this.storedSellingItems -= itemsToTake;
        if (!player.m_36356_(selling)) {
            this.storedSellingItems += selling.m_41613_();
            return false;
        }
        return true;
    }

    public void addSellingItem(ItemStack item) {
        this.selling = item;
        this.markUpdated();
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public ItemStack getSelling() {
        return this.selling;
    }

    public int remainingItemStorage() {
        return this.maxStorage - this.storedSellingItems;
    }

    public int m_6893_() {
        return this.maxStorage;
    }
}

