/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block;

import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.block.entity.ShopBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTradingBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape GLASS_BOX = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)GLASS_BOX);

    public AbstractTradingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof AbstractTradingBlockEntity) {
            ShopBlockEntity shopBlock;
            AbstractTradingBlockEntity tradingBlock = (AbstractTradingBlockEntity)blockEntity;
            if (!player.m_6047_()) {
                player.m_5893_((MenuProvider)tradingBlock);
            } else if (tradingBlock instanceof ShopBlockEntity && (shopBlock = (ShopBlockEntity)tradingBlock).getOwner().equals(player.m_20148_())) {
                shopBlock.updateTradingStatus(!shopBlock.isBuyingFromPlayer());
                MutableComponent status = shopBlock.isBuyingFromPlayer() ? Component.m_237115_((String)"shop.status.buying").m_6270_(ShoppyMod.VARIABLE_STYLE) : Component.m_237115_((String)"shop.status.selling").m_6270_(ShoppyMod.VARIABLE_STYLE);
                MutableComponent update = Component.m_237110_((String)"shop.status.update", (Object[])new Object[]{status}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                player.m_213846_((Component)update);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity;
        if (!blockState.m_60713_(blockState2.m_60734_()) && (blockEntity = level.m_7702_(blockPos)) instanceof AbstractTradingBlockEntity) {
            Containers.m_19010_((Level)level, (BlockPos)blockPos, ((AbstractTradingBlockEntity)blockEntity).dropItems());
        }
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity != null) {
            AbstractTradingBlockEntity shop = (AbstractTradingBlockEntity)level.m_7702_(blockPos);
            shop.setOwner(livingEntity.m_20148_());
        }
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }
}

