/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.joml.Matrix4f;

public record SpellTooltip(ISpellCaster spellcaster, boolean showName) implements TooltipComponent
{
    public SpellTooltip(ISpellCaster spellcaster) {
        this(spellcaster, false);
    }

    public static class SpellTooltipRenderer
    implements ClientTooltipComponent {
        private final ISpellCaster spellCaster;
        private final boolean showName;

        public SpellTooltipRenderer(SpellTooltip pSpellTooltip) {
            this.spellCaster = pSpellTooltip.spellcaster();
            this.showName = pSpellTooltip.showName();
        }

        public int m_142103_() {
            return this.showName ? 28 : 20;
        }

        public int m_142069_(Font pFont) {
            return 4 + this.spellCaster.getSpell().recipe.size() * 16;
        }

        public void m_142440_(Font pFont, int pX, int pY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
            if (this.showName) {
                pFont.m_272077_((Component)Component.m_237113_((String)this.spellCaster.getSpellName()), (float)(pX + 4), (float)pY, -1, true, pMatrix, (MultiBufferSource)pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }

        public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
            List<AbstractSpellPart> recipe = this.spellCaster.getSpell().recipe;
            int recipeSize = recipe.size();
            for (int i = 0; i < recipeSize; ++i) {
                AbstractSpellPart part = recipe.get(i);
                RenderUtils.drawSpellPart(part, pGuiGraphics, pX + i * 16, pY + (this.showName ? 10 : 0), 16, false);
            }
        }
    }
}

