/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.mixin.gamerule.BooleanValueInvoker;
import artifacts.mixin.gamerule.IntegerValueInvoker;
import artifacts.network.BooleanGameRuleChangedPacket;
import artifacts.network.IntegerGameRuleChangedPacket;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModItems;
import artifacts.registry.RegistrySupplier;
import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.GameRules;

public class ModGameRules {
    private static final Map<String, BooleanValue> BOOLEAN_VALUES = new HashMap<String, BooleanValue>();
    private static final Map<String, IntegerValue> INTEGER_VALUES = new HashMap<String, IntegerValue>();
    public static final BooleanValue ANTIDOTE_VESSEL_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ANTIDOTE_VESSEL, "enabled"));
    public static final BooleanValue AQUA_DASHERS_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.AQUA_DASHERS, "enabled"));
    public static final BooleanValue CHARM_OF_SINKING_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.CHARM_OF_SINKING, "enabled"));
    public static final BooleanValue CLOUD_IN_A_BOTTLE_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "enabled"));
    public static final BooleanValue ETERNAL_STEAK_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ETERNAL_STEAK, "enabled"));
    public static final BooleanValue EVERLASTING_BEEF_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.EVERLASTING_BEEF, "enabled"));
    public static final BooleanValue KITTY_SLIPPERS_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.KITTY_SLIPPERS, "enabled"));
    public static final BooleanValue NIGHT_VISION_GOGGLES_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.NIGHT_VISION_GOGGLES, "enabled"));
    public static final BooleanValue PICKAXE_HEATER_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.PICKAXE_HEATER, "enabled"));
    public static final BooleanValue ROOTED_BOOTS_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ROOTED_BOOTS, "enabled"));
    public static final BooleanValue SCARF_OF_INVISIBILITY_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SCARF_OF_INVISIBILITY, "enabled"));
    public static final BooleanValue SNORKEL_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SNORKEL, "enabled"));
    public static final BooleanValue STEADFAST_SPIKES_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.STEADFAST_SPIKES, "enabled"));
    public static final BooleanValue UNIVERSAL_ATTRACTOR_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UNIVERSAL_ATTRACTOR, "enabled"));
    public static final BooleanValue BUNNY_HOPPERS_DO_CANCEL_FALL_DAMAGE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.BUNNY_HOPPERS, "doCancelFallDamage"));
    public static final BooleanValue CHORUS_TOTEM_DO_CONSUME_ON_USE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.CHORUS_TOTEM, "doConsumeOnUse"));
    public static final BooleanValue FLAME_PENDANT_DO_GRANT_FIRE_RESISTANCE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.FLAME_PENDANT, "doGrantFireResistance"));
    public static final BooleanValue ROOTED_BOOTS_DO_GROW_PLANTS_AFTER_EATING = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ROOTED_BOOTS, "doGrowPlantsAfterEating"));
    public static final BooleanValue RUNNING_SHOES_DO_INCREASE_STEP_HEIGHT = ModGameRules.booleanValue(ModGameRules.createName(ModItems.RUNNING_SHOES, "doIncreaseStepHeight"));
    public static final BooleanValue SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SHOCK_PENDANT, "doCancelLightningDamage"));
    public static final BooleanValue SNORKEL_IS_INFINITE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SNORKEL, "isInfinite"), false);
    public static final BooleanValue SNOWSHOES_ALLOW_WALKING_ON_POWDER_SNOW = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SNOWSHOES, "allowWalkingOnPowderSnow"));
    public static final BooleanValue UMBRELLA_IS_SHIELD = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UMBRELLA, "isShield"));
    public static final BooleanValue UMBRELLA_IS_GLIDER = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UMBRELLA, "isGlider"));
    public static final IntegerValue ANGLERS_HAT_LUCK_OF_THE_SEA_LEVEL_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.ANGLERS_HAT, "luckOfTheSeaLevelBonus"), 1);
    public static final IntegerValue ANGLERS_HAT_LURE_LEVEL_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.ANGLERS_HAT, "lureLevelBonus"), 1);
    public static final IntegerValue CROSS_NECKLACE_BONUS_INVINCIBILITY_TICKS = ModGameRules.integerValue(ModGameRules.createName(ModItems.CROSS_NECKLACE, "bonusInvincibilityTicks"), 20, 1200);
    public static final IntegerValue CHORUS_TOTEM_HEALTH_RESTORED = ModGameRules.integerValue(ModGameRules.createName(ModItems.CHORUS_TOTEM, "healthRestored"), 10);
    public static final IntegerValue CRYSTAL_HEART_HEALTH_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.CRYSTAL_HEART, "healthBonus"), 10, 100);
    public static final IntegerValue DIGGING_CLAWS_TOOL_TIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.DIGGING_CLAWS, "toolTier"), Tiers.STONE.m_6604_() + 1, Tiers.NETHERITE.m_6604_() + 1);
    public static final IntegerValue LUCKY_SCARF_FORTUNE_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.LUCKY_SCARF, "fortuneBonus"), 1, 100);
    public static final IntegerValue POWER_GLOVE_ATTACK_DAMAGE_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.POWER_GLOVE, "attackDamageBonus"), 4);
    public static final IntegerValue SUPERSTITIOUS_HAT_LOOTING_LEVEL_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.SUPERSTITIOUS_HAT, "lootingLevelBonus"), 1, 100);
    public static final IntegerValue THORN_PENDANT_MAX_DAMAGE = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "maxDamage"), 6);
    public static final IntegerValue THORN_PENDANT_MIN_DAMAGE = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "minDamage"), 2);
    public static final IntegerValue VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT = ModGameRules.integerValue(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "maxHealingPerHit"), 6);
    public static final IntegerValue VILLAGER_HAT_REPUTATION_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.VILLAGER_HAT, "reputationBonus"), 100);
    public static final IntegerValue ANTIDOTE_VESSEL_MAX_EFFECT_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.ANTIDOTE_VESSEL, "maxEffectDuration"), 5);
    public static final IntegerValue CHORUS_TOTEM_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.CHORUS_TOTEM, "cooldown"), 0);
    public static final IntegerValue CROSS_NECKLACE_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.CROSS_NECKLACE, "cooldown"), 0);
    public static final IntegerValue ETERNAL_STEAK_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.ETERNAL_STEAK, "cooldown"), 15);
    public static final IntegerValue EVERLASTING_BEEF_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.EVERLASTING_BEEF, "cooldown"), 15);
    public static final IntegerValue FIRE_GAUNTLET_FIRE_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.FIRE_GAUNTLET, "fireDuration"), 8);
    public static final IntegerValue FLAME_PENDANT_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.FLAME_PENDANT, "cooldown"), 0);
    public static final IntegerValue FLAME_PENDANT_FIRE_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.FLAME_PENDANT, "fireDuration"), 10);
    public static final IntegerValue HELIUM_FLAMINGO_FLIGHT_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.HELIUM_FLAMINGO, "flightDuration"), 8);
    public static final IntegerValue HELIUM_FLAMINGO_RECHARGE_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.HELIUM_FLAMINGO, "rechargeDuration"), 15);
    public static final IntegerValue OBSIDIAN_SKULL_FIRE_RESISTANCE_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.OBSIDIAN_SKULL, "fireResistanceCooldown"), 60);
    public static final IntegerValue OBSIDIAN_SKULL_FIRE_RESISTANCE_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.OBSIDIAN_SKULL, "fireResistanceDuration"), 30);
    public static final IntegerValue ONION_RING_HASTE_DURATION_PER_FOOD_POINT = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.ONION_RING, "hasteDurationPerFoodPoint"), 6);
    public static final IntegerValue PANIC_NECKLACE_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.PANIC_NECKLACE, "cooldown"), 0);
    public static final IntegerValue PANIC_NECKLACE_SPEED_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.PANIC_NECKLACE, "speedDuration"), 8);
    public static final IntegerValue ROOTED_BOOTS_HUNGER_REPLENISHING_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.ROOTED_BOOTS, "hungerReplenishingDuration"), 15);
    public static final IntegerValue SHOCK_PENDANT_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.SHOCK_PENDANT, "cooldown"), 0);
    public static final IntegerValue SNORKEL_WATER_BREATHING_DURATION = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.SNORKEL, "waterBreathingDuration"), 15);
    public static final IntegerValue THORN_PENDANT_COOLDOWN = ModGameRules.durationSeconds(ModGameRules.createName(ModItems.THORN_PENDANT, "cooldown"), 0);
    public static final IntegerValue BUNNY_HOPPERS_JUMP_BOOST_LEVEL = ModGameRules.mobEffectLevel(ModGameRules.createName(ModItems.BUNNY_HOPPERS, "jumpBoostLevel"), 2);
    public static final IntegerValue COWBOY_HAT_SPEED_LEVEL = ModGameRules.mobEffectLevel(ModGameRules.createName(ModItems.COWBOY_HAT, "speedLevel"), 2);
    public static final IntegerValue ONION_RING_HASTE_LEVEL = ModGameRules.mobEffectLevel(ModGameRules.createName(ModItems.ONION_RING, "hasteLevel"), 2);
    public static final IntegerValue PANIC_NECKLACE_SPEED_LEVEL = ModGameRules.mobEffectLevel(ModGameRules.createName(ModItems.PANIC_NECKLACE, "speedLevel"), 1);
    public static final DoubleValue CHORUS_TOTEM_TELEPORTATION_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.CHORUS_TOTEM, "teleportationChance"), 100);
    public static final DoubleValue CLOUD_IN_A_BOTTLE_SPRINT_JUMP_VERTICAL_VELOCITY = ModGameRules.doubleValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "sprintJumpVerticalVelocity"), 50, 10000, 100.0);
    public static final DoubleValue CLOUD_IN_A_BOTTLE_SPRINT_JUMP_HORIZONTAL_VELOCITY = ModGameRules.doubleValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "sprintJumpHorizontalVelocity"), 50, 10000, 100.0);
    public static final DoubleValue DIGGING_CLAWS_DIG_SPEED_BONUS = ModGameRules.doubleValue(ModGameRules.createName(ModItems.DIGGING_CLAWS, "digSpeedBonus"), 32, 10);
    public static final DoubleValue FERAL_CLAWS_ATTACK_SPEED_BONUS = ModGameRules.percentage(ModGameRules.createName(ModItems.FERAL_CLAWS, "attackSpeedBonus"), 40);
    public static final DoubleValue FLAME_PENDANT_STRIKE_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.FLAME_PENDANT, "strikeChance"), 40);
    public static final DoubleValue FLIPPERS_SWIM_SPEED_BONUS = ModGameRules.doubleValue(ModGameRules.createName(ModItems.FLIPPERS, "swimSpeedBonus"), 100, 10000, 100.0);
    public static final DoubleValue GOLDEN_HOOK_EXPERIENCE_BONUS = ModGameRules.doubleValue(ModGameRules.createName(ModItems.GOLDEN_HOOK, "experienceBonus"), 75, 1000, 100.0);
    public static final DoubleValue NIGHT_VISION_GOGGLES_STRENGTH = ModGameRules.percentage(ModGameRules.createName(ModItems.NIGHT_VISION_GOGGLES, "strength"), 25);
    public static final DoubleValue NOVELTY_DRINKING_HAT_DRINKING_DURATION_MULTIPLIER = ModGameRules.percentage(ModGameRules.createName(ModItems.NOVELTY_DRINKING_HAT, "drinkingDurationMultiplier"), 30);
    public static final DoubleValue NOVELTY_DRINKING_HAT_EATING_DURATION_MULTIPLIER = ModGameRules.percentage(ModGameRules.createName(ModItems.NOVELTY_DRINKING_HAT, "eatingDurationMultiplier"), 60);
    public static final DoubleValue PLASTIC_DRINKING_HAT_DRINKING_DURATION_MULTIPLIER = ModGameRules.percentage(ModGameRules.createName(ModItems.PLASTIC_DRINKING_HAT, "drinkingDurationMultiplier"), 30);
    public static final DoubleValue PLASTIC_DRINKING_HAT_EATING_DURATION_MULTIPLIER = ModGameRules.percentage(ModGameRules.createName(ModItems.PLASTIC_DRINKING_HAT, "eatingDurationMultiplier"), 60);
    public static final DoubleValue POCKET_PISTON_KNOCKBACK_STRENGTH = ModGameRules.doubleValue(ModGameRules.createName(ModItems.POCKET_PISTON, "knockbackStrength"), 15, 10);
    public static final DoubleValue RUNNING_SHOES_SPEED_BONUS = ModGameRules.doubleValue(ModGameRules.createName(ModItems.RUNNING_SHOES, "speedBonus"), 40, 10000, 100.0);
    public static final DoubleValue SHOCK_PENDANT_STRIKE_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.SHOCK_PENDANT, "strikeChance"), 25);
    public static final DoubleValue STEADFAST_SPIKES_KNOCKBACK_RESISTANCE = ModGameRules.doubleValue(ModGameRules.createName(ModItems.STEADFAST_SPIKES, "knockbackResistance"), 10, 10, 10.0);
    public static final DoubleValue SNOWSHOES_SLIPPERINESS_REDUCTION = ModGameRules.percentage(ModGameRules.createName(ModItems.SNOWSHOES, "slipperinessReduction"), 100);
    public static final DoubleValue THORN_PENDANT_STRIKE_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.THORN_PENDANT, "strikeChance"), 50);
    public static final DoubleValue VAMPIRIC_GLOVE_ABSORPTION_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "absorptionChance"), 100);
    public static final DoubleValue VAMPIRIC_GLOVE_ABSORPTION_RATIO = ModGameRules.doubleValue(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "absorptionRatio"), 20, 100);
    public static final DoubleValue WHOOPEE_CUSHION_FART_CHANCE = ModGameRules.percentage(ModGameRules.createName(ModItems.WHOOPEE_CUSHION, "fartChance"), 12);

    private static String createName(RegistrySupplier<? extends Item> item, String name) {
        return String.format("%s.%s.%s", "artifacts", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, item.getId().m_135815_()), name);
    }

    private static BooleanValue booleanValue(String name) {
        return ModGameRules.booleanValue(name, true);
    }

    private static BooleanValue booleanValue(String name, boolean defaultValue) {
        BooleanValue result = new BooleanValue();
        result.update(defaultValue);
        GameRules.Type<GameRules.BooleanValue> type = BooleanValueInvoker.invokeCreate(defaultValue, (server, value) -> {
            result.update(value.m_46223_());
            NetworkHandler.CHANNEL.sendToPlayers((Iterable)server.m_6846_().m_11314_(), (Object)new BooleanGameRuleChangedPacket(name, value.m_46223_()));
        });
        result.key = GameRules.m_46189_((String)name, (GameRules.Category)GameRules.Category.PLAYER, type);
        BOOLEAN_VALUES.put(name, result);
        return result;
    }

    private static IntegerValue integerValue(String name, int defaultValue) {
        return ModGameRules.integerValue(name, defaultValue, Integer.MAX_VALUE);
    }

    private static IntegerValue integerValue(String name, int defaultValue, int maxValue) {
        return ModGameRules.integerValue(name, defaultValue, maxValue, 1);
    }

    private static IntegerValue integerValue(String name, int defaultValue, int maxValue, int multiplier) {
        IntegerValue result = new IntegerValue(defaultValue, maxValue, multiplier);
        result.update(defaultValue);
        GameRules.Type<GameRules.IntegerValue> type = IntegerValueInvoker.invokeCreate(defaultValue, (server, value) -> {
            result.update(value.m_46288_());
            NetworkHandler.CHANNEL.sendToPlayers((Iterable)server.m_6846_().m_11314_(), (Object)new IntegerGameRuleChangedPacket(name, value.m_46288_()));
        });
        result.key = GameRules.m_46189_((String)name, (GameRules.Category)GameRules.Category.PLAYER, type);
        INTEGER_VALUES.put(name, result);
        return result;
    }

    private static IntegerValue durationSeconds(String name, int defaultValue) {
        return ModGameRules.integerValue(name, defaultValue, 72000, 20);
    }

    private static IntegerValue mobEffectLevel(String name, int defaultValue) {
        return ModGameRules.integerValue(name, defaultValue, 128);
    }

    private static DoubleValue doubleValue(String name, int defaultValue, int maxValue, double factor) {
        return new DoubleValue(ModGameRules.integerValue(name, defaultValue, maxValue), factor);
    }

    private static DoubleValue doubleValue(String name, int defaultValue, int factor) {
        return ModGameRules.doubleValue(name, defaultValue, Integer.MAX_VALUE, factor);
    }

    private static DoubleValue percentage(String name, int defaultValue) {
        return ModGameRules.doubleValue(name, defaultValue, 100, 100.0);
    }

    public static void updateValue(String key, boolean value) {
        BOOLEAN_VALUES.get(key).update(value);
    }

    public static void updateValue(String key, int value) {
        INTEGER_VALUES.get(key).update(value);
    }

    public static void onPlayerJoinLevel(ServerPlayer player) {
        BOOLEAN_VALUES.forEach((key, value) -> NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new BooleanGameRuleChangedPacket((String)key, value.value)));
        INTEGER_VALUES.forEach((key, value) -> NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new IntegerGameRuleChangedPacket((String)key, value.value)));
    }

    public static void onServerStarted(MinecraftServer server) {
        BOOLEAN_VALUES.values().forEach(value -> value.update(server));
        INTEGER_VALUES.values().forEach(value -> value.update(server));
    }

    public static class BooleanValue
    implements Supplier<Boolean> {
        private Boolean value = true;
        private GameRules.Key<GameRules.BooleanValue> key;

        @Override
        public Boolean get() {
            return this.value;
        }

        private void update(MinecraftServer server) {
            this.update(server.m_129900_().m_46207_(this.key));
        }

        private void update(boolean value) {
            this.value = value;
        }
    }

    public static class IntegerValue
    implements Supplier<Integer> {
        private final int max;
        private final int multiplier;
        private int value;
        private GameRules.Key<GameRules.IntegerValue> key;

        private IntegerValue(int defaultValue, int max, int multiplier) {
            this.value = defaultValue;
            this.max = max;
            this.multiplier = multiplier;
        }

        @Override
        public Integer get() {
            return Math.min(this.max, Math.max(0, this.value)) * this.multiplier;
        }

        private void update(MinecraftServer server) {
            this.update(server.m_129900_().m_46215_(this.key));
        }

        private void update(int value) {
            this.value = value;
        }
    }

    public record DoubleValue(IntegerValue integerValue, double factor) implements Supplier<Double>
    {
        @Override
        public Double get() {
            return (double)this.integerValue.get().intValue() / this.factor;
        }

        public boolean fuzzyEquals(double a) {
            return Math.abs(this.get() - a) < 1.0E-10;
        }
    }
}

