/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item;

import artifacts.Artifacts;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.model.BeltModel;
import artifacts.client.item.model.HeadModel;
import artifacts.client.item.model.LegsModel;
import artifacts.client.item.model.NecklaceModel;
import artifacts.client.item.model.ScarfModel;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;

public class ArtifactLayers {
    public static final ModelLayerLocation DRINKING_HAT = ArtifactLayers.createLayerLocation("drinking_hat");
    public static final ModelLayerLocation SNORKEL = ArtifactLayers.createLayerLocation("snorkel");
    public static final ModelLayerLocation NIGHT_VISION_GOGGLES = ArtifactLayers.createLayerLocation("night_vision_goggles");
    public static final ModelLayerLocation SUPERSTITIOUS_HAT = ArtifactLayers.createLayerLocation("superstitious_hat");
    public static final ModelLayerLocation BRIMMED_HAT = ArtifactLayers.createLayerLocation("brimmed_hat");
    public static final ModelLayerLocation COWBOY_HAT = ArtifactLayers.createLayerLocation("cowboy_hat");
    public static final ModelLayerLocation ANGLERS_HAT = ArtifactLayers.createLayerLocation("anglers_hat");
    public static final ModelLayerLocation SCARF = ArtifactLayers.createLayerLocation("scarf");
    public static final ModelLayerLocation CROSS_NECKLACE = ArtifactLayers.createLayerLocation("cross_necklace");
    public static final ModelLayerLocation PANIC_NECKLACE = ArtifactLayers.createLayerLocation("panic_necklace");
    public static final ModelLayerLocation PENDANT = ArtifactLayers.createLayerLocation("pendant");
    public static final ModelLayerLocation CHARM_OF_SINKING = ArtifactLayers.createLayerLocation("charm_of_sinking");
    public static final ModelLayerLocation CLOUD_IN_A_BOTTLE = ArtifactLayers.createLayerLocation("cloud_in_a_bottle");
    public static final ModelLayerLocation OBSIDIAN_SKULL = ArtifactLayers.createLayerLocation("obsidian_skull");
    public static final ModelLayerLocation ANTIDOTE_VESSEL = ArtifactLayers.createLayerLocation("antidote_vessel");
    public static final ModelLayerLocation UNIVERSAL_ATTRACTOR = ArtifactLayers.createLayerLocation("universal_attractor");
    public static final ModelLayerLocation CRYSTAL_HEART = ArtifactLayers.createLayerLocation("crystal_heart");
    public static final ModelLayerLocation HELIUM_FLAMINGO = ArtifactLayers.createLayerLocation("helium_flamingo");
    public static final ModelLayerLocation CHORUS_TOTEM = ArtifactLayers.createLayerLocation("chorus_totem");
    public static final ModelLayerLocation CLAWS_WIDE = ArtifactLayers.createLayerLocation("claws_wide");
    public static final ModelLayerLocation CLAWS_SLIM = ArtifactLayers.createLayerLocation("claws_slim");
    public static final ModelLayerLocation GLOVE_WIDE = ArtifactLayers.createLayerLocation("glove_wide");
    public static final ModelLayerLocation GLOVE_SLIM = ArtifactLayers.createLayerLocation("glove_slim");
    public static final ModelLayerLocation GOLDEN_HOOK_WIDE = ArtifactLayers.createLayerLocation("golden_hook_wide");
    public static final ModelLayerLocation GOLDEN_HOOK_SLIM = ArtifactLayers.createLayerLocation("golden_hook_slim");
    public static final ModelLayerLocation POCKET_PISTON_WIDE = ArtifactLayers.createLayerLocation("pocket_piston_wide");
    public static final ModelLayerLocation POCKET_PISTON_SLIM = ArtifactLayers.createLayerLocation("pocket_piston_slim");
    public static final ModelLayerLocation ONION_RING_WIDE = ArtifactLayers.createLayerLocation("onion_ring_wide");
    public static final ModelLayerLocation ONION_RING_SLIM = ArtifactLayers.createLayerLocation("onion_ring_slim");
    public static final ModelLayerLocation PICKAXE_HEATER_WIDE = ArtifactLayers.createLayerLocation("pickaxe_heater_wide");
    public static final ModelLayerLocation PICKAXE_HEATER_SLIM = ArtifactLayers.createLayerLocation("pickaxe_heater_slim");
    public static final ModelLayerLocation AQUA_DASHERS_SMALL = ArtifactLayers.createLayerLocation("aqua_dashers_small");
    public static final ModelLayerLocation AQUA_DASHERS_LARGE = ArtifactLayers.createLayerLocation("aqua_dashers_large");
    public static final ModelLayerLocation BUNNY_HOPPERS = ArtifactLayers.createLayerLocation("bunny_hoppers");
    public static final ModelLayerLocation KITTY_SLIPPERS = ArtifactLayers.createLayerLocation("kitty_slippers");
    public static final ModelLayerLocation BOOTS_SMALL = ArtifactLayers.createLayerLocation("boots_small");
    public static final ModelLayerLocation BOOTS_LARGE = ArtifactLayers.createLayerLocation("boots_large");
    public static final ModelLayerLocation SNOWSHOES = ArtifactLayers.createLayerLocation("snowshoes");
    public static final ModelLayerLocation STEADFAST_SPIKES = ArtifactLayers.createLayerLocation("steadfast_spikes");
    public static final ModelLayerLocation FLIPPERS = ArtifactLayers.createLayerLocation("flippers");
    public static final ModelLayerLocation WHOOPEE_CUSHION = ArtifactLayers.createLayerLocation("whoopee_cushion");

    public static ModelLayerLocation claws(boolean hasSlimArms) {
        return hasSlimArms ? CLAWS_SLIM : CLAWS_WIDE;
    }

    public static ModelLayerLocation glove(boolean hasSlimArms) {
        return hasSlimArms ? GLOVE_SLIM : GLOVE_WIDE;
    }

    public static ModelLayerLocation goldenHook(boolean hasSlimArms) {
        return hasSlimArms ? GOLDEN_HOOK_SLIM : GOLDEN_HOOK_WIDE;
    }

    public static ModelLayerLocation pocketPiston(boolean hasSlimArms) {
        return hasSlimArms ? POCKET_PISTON_SLIM : POCKET_PISTON_WIDE;
    }

    public static ModelLayerLocation onionRing(boolean hasSlimArms) {
        return hasSlimArms ? ONION_RING_SLIM : ONION_RING_WIDE;
    }

    public static ModelLayerLocation pickaxeHeater(boolean hasSlimArms) {
        return hasSlimArms ? PICKAXE_HEATER_SLIM : PICKAXE_HEATER_WIDE;
    }

    public static ModelLayerLocation createLayerLocation(String name) {
        return new ModelLayerLocation(Artifacts.id(name), name);
    }

    private static Supplier<LayerDefinition> layer(Supplier<MeshDefinition> mesh, int textureWidth, int textureHeight) {
        return () -> LayerDefinition.m_171565_((MeshDefinition)((MeshDefinition)mesh.get()), (int)textureWidth, (int)textureHeight);
    }

    public static void register() {
        EntityModelLayerRegistry.register((ModelLayerLocation)DRINKING_HAT, ArtifactLayers.layer(HeadModel::createDrinkingHat, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SNORKEL, ArtifactLayers.layer(HeadModel::createSnorkel, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)NIGHT_VISION_GOGGLES, ArtifactLayers.layer(HeadModel::createNightVisionGoggles, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SUPERSTITIOUS_HAT, ArtifactLayers.layer(HeadModel::createSuperstitiousHat, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)BRIMMED_HAT, ArtifactLayers.layer(() -> HeadModel.createBrimmedHat(CubeListBuilder.m_171558_()), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)COWBOY_HAT, ArtifactLayers.layer(HeadModel::createCowboyHat, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)ANGLERS_HAT, ArtifactLayers.layer(HeadModel::createAnglersHat, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SCARF, ArtifactLayers.layer(ScarfModel::createScarf, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)CROSS_NECKLACE, ArtifactLayers.layer(NecklaceModel::createCrossNecklace, 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)PANIC_NECKLACE, ArtifactLayers.layer(NecklaceModel::createPanicNecklace, 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)PENDANT, ArtifactLayers.layer(NecklaceModel::createPendant, 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)CHARM_OF_SINKING, ArtifactLayers.layer(NecklaceModel::createCharmOfSinking, 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)CLOUD_IN_A_BOTTLE, ArtifactLayers.layer(BeltModel::createCloudInABottle, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)OBSIDIAN_SKULL, ArtifactLayers.layer(BeltModel::createObsidianSkull, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)ANTIDOTE_VESSEL, ArtifactLayers.layer(BeltModel::createAntidoteVessel, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)UNIVERSAL_ATTRACTOR, ArtifactLayers.layer(BeltModel::createUniversalAttractor, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)CRYSTAL_HEART, ArtifactLayers.layer(BeltModel::createCrystalHeart, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)HELIUM_FLAMINGO, ArtifactLayers.layer(BeltModel::createHeliumFlamingo, 64, 64));
        EntityModelLayerRegistry.register((ModelLayerLocation)CHORUS_TOTEM, ArtifactLayers.layer(BeltModel::createChorusTotem, 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)CLAWS_WIDE, ArtifactLayers.layer(() -> ArmsModel.createClaws(false), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)CLAWS_SLIM, ArtifactLayers.layer(() -> ArmsModel.createClaws(true), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)GLOVE_WIDE, ArtifactLayers.layer(() -> ArmsModel.createSleevedArms(false), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)GLOVE_SLIM, ArtifactLayers.layer(() -> ArmsModel.createSleevedArms(true), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)GOLDEN_HOOK_WIDE, ArtifactLayers.layer(() -> ArmsModel.createGoldenHook(false), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)GOLDEN_HOOK_SLIM, ArtifactLayers.layer(() -> ArmsModel.createGoldenHook(true), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)POCKET_PISTON_WIDE, ArtifactLayers.layer(() -> ArmsModel.createPocketPiston(false), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)POCKET_PISTON_SLIM, ArtifactLayers.layer(() -> ArmsModel.createPocketPiston(true), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)ONION_RING_WIDE, ArtifactLayers.layer(() -> ArmsModel.createOnionRing(false), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)ONION_RING_SLIM, ArtifactLayers.layer(() -> ArmsModel.createOnionRing(true), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)PICKAXE_HEATER_WIDE, ArtifactLayers.layer(() -> ArmsModel.createPickaxeHeater(false), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)PICKAXE_HEATER_SLIM, ArtifactLayers.layer(() -> ArmsModel.createPickaxeHeater(true), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)AQUA_DASHERS_SMALL, ArtifactLayers.layer(() -> LegsModel.createAquaDashers(0.5f), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)AQUA_DASHERS_LARGE, ArtifactLayers.layer(() -> LegsModel.createAquaDashers(1.25f), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)BUNNY_HOPPERS, ArtifactLayers.layer(LegsModel::createBunnyHoppers, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)KITTY_SLIPPERS, ArtifactLayers.layer(LegsModel::createKittySlippers, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)BOOTS_SMALL, ArtifactLayers.layer(() -> LegsModel.createBoots(0.5f), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)BOOTS_LARGE, ArtifactLayers.layer(() -> LegsModel.createBoots(1.25f), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SNOWSHOES, ArtifactLayers.layer(LegsModel::createSnowshoes, 64, 64));
        EntityModelLayerRegistry.register((ModelLayerLocation)STEADFAST_SPIKES, ArtifactLayers.layer(LegsModel::createSteadfastSpikes, 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)FLIPPERS, ArtifactLayers.layer(LegsModel::createFlippers, 64, 64));
        EntityModelLayerRegistry.register((ModelLayerLocation)WHOOPEE_CUSHION, ArtifactLayers.layer(HeadModel::createWhoopeeCushion, 32, 16));
    }
}

