/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.events.OnItemDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class GoldFuelledEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_GOLDEN).slots((List)EquipmentSlots.ALL).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public GoldFuelledEnchantment() {
        super(MajruszsEnchantments.GOLD_FUELLED, GoldFuelledEnchantment.class, false);
        OnItemDamaged.listen(this::restoreInitialDurability).priority(Priority.LOW).addCondition(Condition.isLogicalServer()).addCondition(data -> data.player != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.itemStack)).addCondition(OnItemDamaged::isAboutToBroke);
    }

    private void restoreInitialDurability(OnItemDamaged data) {
        if (this.consumeGoldIngot(data.player)) {
            data.damage -= data.itemStack.m_41776_();
        }
    }

    private boolean consumeGoldIngot(Player player) {
        for (Slot slot : player.f_36095_.f_38839_) {
            ItemStack itemStack = slot.m_7993_();
            if (itemStack.m_41720_() != Items.f_42417_) continue;
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            return true;
        }
        return false;
    }
}

