/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.registry;

import ad_astra_giselle_addon.common.registry.ObjectRegistry;
import ad_astra_giselle_addon.common.registry.ObjectRegistryHolder;
import ad_astra_giselle_addon.common.util.TriFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ObjectRegistryCollection<T> {
    private final String modid;
    private final ResourceKey<? extends Registry<T>> key;
    private final Set<ObjectRegistryHolder<T>> objects;
    private final Set<ObjectRegistryHolder<T>> readonlyObjects;

    public ObjectRegistryCollection(String modid, ResourceKey<? extends Registry<T>> key) {
        this.modid = modid;
        this.key = key;
        this.objects = new HashSet<ObjectRegistryHolder<T>>();
        this.readonlyObjects = Collections.unmodifiableSet(this.objects);
    }

    public static <T> ObjectRegistryCollection<T> create(String modid, ResourceKey<? extends Registry<T>> key) {
        return new ObjectRegistryCollection<T>(modid, key);
    }

    public void register() {
        ObjectRegistry<T> registry = ObjectRegistry.get(this.getKey());
        for (ObjectRegistryHolder<T> object : this.getObjects()) {
            object.register(registry);
        }
    }

    protected <I extends T, HOLDER extends ObjectRegistryHolder<I>> HOLDER add(String name, Supplier<I> initializer, TriFunction<ResourceLocation, Supplier<I>, ResourceKey<? extends Registry<?>>, HOLDER> func) {
        ObjectRegistryHolder holder = (ObjectRegistryHolder)func.apply(new ResourceLocation(this.getModid(), name), initializer, this.getKey());
        this.objects.add(holder);
        return (HOLDER)holder;
    }

    public <I extends T> ObjectRegistryHolder<I> add(String name, Supplier<I> initializer) {
        return this.add(name, initializer, ObjectRegistryHolder::new);
    }

    public String getModid() {
        return this.modid;
    }

    public ResourceKey<? extends Registry<T>> getKey() {
        return this.key;
    }

    public Collection<ObjectRegistryHolder<T>> getObjects() {
        return this.readonlyObjects;
    }

    public Stream<T> stream() {
        return this.getObjects().stream().map(ObjectRegistryHolder::get);
    }

    public Collection<T> getValues() {
        return this.stream().toList();
    }
}

