/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.compat.create.BacktankOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorageItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.CreativeOxygenCanItem;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.OxygenCanItem;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class OxygenStorageUtils {
    public static OptionalDouble getStoredRatio(LivingEntity living) {
        return OxygenStorageUtils.getStoredRatio(OxygenStorageUtils.stream(living));
    }

    public static OptionalDouble getStoredRatio(Stream<ItemStackHolder> items) {
        ItemStackHolder[] array;
        for (ItemStackHolder stack : array = (ItemStackHolder[])items.toArray(ItemStackHolder[]::new)) {
            if (!OxygenStorageUtils.isInfinifySource(stack.getStack())) continue;
            return OptionalDouble.of(Double.POSITIVE_INFINITY);
        }
        long stored = 0L;
        long capacity = 0L;
        for (ItemStackHolder item : array) {
            IOxygenStorage oxygenStorage;
            if (item.getStack().m_41720_() instanceof CreativeOxygenCanItem || (oxygenStorage = OxygenStorageUtils.get(item)) == null) continue;
            stored += oxygenStorage.getOxygenAmount();
            capacity += oxygenStorage.getOxygenCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenStorage firstExtractable(LivingEntity living, long extracting) {
        return OxygenStorageUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<ItemStackHolder> stream(LivingEntity living) {
        Level level = living.m_9236_();
        BlockPos pos = living.m_20183_();
        boolean isCold = TemperatureApi.API.isCold(level, pos);
        boolean isHot = TemperatureApi.API.isHot(level, pos);
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        return Stream.concat(items.stream().filter(item -> OxygenStorageUtils.isInfinifySource(item.getStack())), items.stream().filter(item -> !(item.getStack().m_41720_() instanceof CreativeOxygenCanItem)).filter(item -> {
            IOxygenStorage oxygenStorage = OxygenStorageUtils.get(item);
            return oxygenStorage != null && oxygenStorage.canUse(isCold, isHot);
        }));
    }

    @Nullable
    public static Stream<IOxygenStorage> streamExtractable(LivingEntity living, long extracting) {
        return OxygenStorageUtils.stream(living).map(OxygenStorageUtils::get).filter(oxygenStorage -> {
            long extract = oxygenStorage.extractOxygen(living, extracting, true);
            return extract >= extracting;
        });
    }

    public static boolean isInfinifySource(ItemStack item) {
        CreativeOxygenCanItem type;
        Item item2 = item.m_41720_();
        return item2 instanceof CreativeOxygenCanItem && !(type = (CreativeOxygenCanItem)item2).getFluidContainer(item).isEmpty();
    }

    @Nullable
    public static IOxygenStorage get(ItemStackHolder item) {
        IOxygenStorage storage;
        Item item2 = item.getStack().m_41720_();
        if (item2 instanceof IOxygenStorageItem) {
            IOxygenStorageItem oxygenStorageItem = (IOxygenStorageItem)item2;
            return oxygenStorageItem.getOxygenStorage(item);
        }
        if (CompatibleManager.Create.isLoaded() && (storage = BacktankOxygenStorage.getOxygenStroage(item)) != null) {
            return storage;
        }
        return null;
    }

    public static long insert(LivingEntity living, long amount) {
        for (ItemStackReference item : LivingHelper.getSlotItems(living)) {
            if (amount <= 0L) break;
            if (!(item.getStack().m_41720_() instanceof OxygenCanItem)) continue;
            ItemFluidContainer tank = FluidContainer.of((ItemStackHolder)item);
            FluidHolder containedStack = tank.getFirstFluid();
            Fluid insertingFluid = (Fluid)ModFluids.OXYGEN.get();
            if (!containedStack.isEmpty()) {
                insertingFluid = containedStack.getFluid();
            }
            FluidHolder inserting = FluidHolder.of((Fluid)insertingFluid, (long)amount, null);
            long inserted = tank.insertFluid(inserting, false);
            amount -= inserted;
        }
        return amount;
    }

    private OxygenStorageUtils() {
    }
}

