/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.pneumaticcraft;

import ad_astra_giselle_addon.common.compat.pneumaticcraft.UpgradeRegistryHolder;
import ad_astra_giselle_addon.common.registry.ObjectRegistryCollection;
import ad_astra_giselle_addon.common.registry.ObjectRegistryHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.item.UpgradeItem;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class UpgradeDeferredRegister {
    private final String modid;
    private final Set<UpgradeRegistryHolder<?, ?>> objects;
    private final Set<UpgradeRegistryHolder<?, ?>> readonlyObjects;
    protected final ObjectRegistryCollection<Item> itemRegister;

    public static ResourceLocation getItemName(PNCUpgrade upgrade, int tier) {
        ResourceLocation id = upgrade.getId();
        return new ResourceLocation(id.m_135827_(), UpgradeDeferredRegister.getItemName(id.m_135815_(), upgrade.getMaxTier(), tier));
    }

    public static String getItemName(String name, int maxTier, int tier) {
        String prefix = "pneumatic_" + name + "_upgrade";
        if (maxTier == 1) {
            return prefix;
        }
        return prefix + "_" + tier;
    }

    public UpgradeDeferredRegister(String modid) {
        this.modid = modid;
        this.objects = new HashSet();
        this.readonlyObjects = Collections.unmodifiableSet(this.objects);
        this.itemRegister = new ObjectRegistryCollection(modid, Registries.f_256913_);
    }

    public Optional<UpgradeRegistryHolder<?, ?>> find(PNCUpgrade upgrade) {
        for (UpgradeRegistryHolder<?, ?> holder : this.getObjects()) {
            if (holder.get() != upgrade) continue;
            return Optional.of(holder);
        }
        return Optional.empty();
    }

    public UpgradeRegistryHolder<PNCUpgrade, UpgradeItem> add(String name, Supplier<Item.Properties> propertiesSup) {
        return this.add(name, propertiesSup, 1, new String[0]);
    }

    public UpgradeRegistryHolder<PNCUpgrade, UpgradeItem> add(String name, Supplier<Item.Properties> propertiesSup, int maxTier, String ... depModIds) {
        return this.add(name, () -> ApplicableUpgradesDB.getInstance().registerUpgrade(new ResourceLocation(this.getModid(), name)), u -> new UpgradeItem(u, maxTier, (Item.Properties)propertiesSup.get()));
    }

    public <U extends PNCUpgrade, I extends UpgradeItem> UpgradeRegistryHolder<U, I> add(String name, Supplier<? extends U> upgradeSup, Function<PNCUpgrade, ? extends I> itemFunc) {
        PNCUpgrade upgrade = (PNCUpgrade)upgradeSup.get();
        int maxTier = upgrade.getMaxTier();
        ArrayList<ObjectRegistryHolder<UpgradeItem>> items = new ArrayList<ObjectRegistryHolder<UpgradeItem>>();
        for (int i = 0; i < upgrade.getMaxTier(); ++i) {
            items.add(this.itemRegister.add(UpgradeDeferredRegister.getItemName(name, maxTier, i + 1), () -> (UpgradeItem)itemFunc.apply(upgrade)));
        }
        UpgradeRegistryHolder registryObject = new UpgradeRegistryHolder(upgrade, items);
        this.objects.add(registryObject);
        return registryObject;
    }

    public void register() {
        this.itemRegister.register();
    }

    public String getModid() {
        return this.modid;
    }

    public Collection<UpgradeRegistryHolder<?, ?>> getObjects() {
        return this.readonlyObjects;
    }
}

