/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class CrystalLevelData
extends SavedData {
    public static final String ID = "dragonfight";
    private Set<BlockPos> crystalPendingRespawns = new HashSet<BlockPos>();
    private Set<UUID> toIgnore = new HashSet<UUID>();

    public static CrystalLevelData load(CompoundTag tag) {
        CrystalLevelData data = new CrystalLevelData();
        data.read(tag);
        return data;
    }

    public void read(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("positions", 10);
        this.crystalPendingRespawns.clear();
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            this.crystalPendingRespawns.add(new BlockPos(((CompoundTag)tag).m_128451_("x"), ((CompoundTag)tag).m_128451_("y"), ((CompoundTag)tag).m_128451_("z")));
        }
        if (nbt.m_128441_("uuids")) {
            ListTag uuids = nbt.m_128437_("uuids", 10);
            this.toIgnore.clear();
            for (Tag tag : uuids) {
                if (!(tag instanceof CompoundTag)) continue;
                this.toIgnore.add(((CompoundTag)tag).m_128342_("uuid"));
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (BlockPos data : this.crystalPendingRespawns) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", data.m_123341_());
            tag.m_128405_("y", data.m_123342_());
            tag.m_128405_("z", data.m_123343_());
            list.add((Object)tag);
        }
        nbt.m_128365_("positions", (Tag)list);
        ListTag uuidList = new ListTag();
        for (UUID uuid : this.toIgnore) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("uuid", uuid);
            uuidList.add((Object)tag);
        }
        nbt.m_128365_("uuids", (Tag)uuidList);
        this.m_77760_(false);
        return nbt;
    }

    public void addPosition(BlockPos pos) {
        this.m_77762_();
        this.crystalPendingRespawns.add(pos);
    }

    public void removePosition(BlockPos pos) {
        this.m_77762_();
        this.crystalPendingRespawns.remove(pos);
    }

    public void ignoreUUID(UUID toIgnore) {
        if (this.toIgnore.size() > 500) {
            this.toIgnore.clear();
        }
        this.m_77762_();
        this.toIgnore.add(toIgnore);
    }

    public boolean isIgnored(UUID toCheck) {
        return this.toIgnore.contains(toCheck);
    }

    public Set<BlockPos> getCrystalPendingRespawns() {
        return this.crystalPendingRespawns;
    }

    public static CrystalLevelData getForLevel(ServerLevel level) {
        return (CrystalLevelData)level.m_8895_().m_164861_(CrystalLevelData::load, CrystalLevelData::new, ID);
    }
}

