/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;

public class Settings {
    public static final String KEY_SELF = "settings";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_MODE = "mode";
    public static final String KEY_MULTIBLOCK = "multiblock";
    public static final String KEY_MIRROR = "mirror";
    public static final String KEY_PLACED = "placed";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_POSITION = "pos";
    private Mode mode;
    private Rotation rotation;
    private BlockPos pos = null;
    private MultiblockHandler.IMultiblock multiblock = null;
    private boolean mirror;
    private boolean isPlaced;

    public Settings() {
        this(new CompoundTag());
    }

    public Settings(@Nullable ItemStack stack) {
        this(((Supplier<CompoundTag>)() -> {
            CompoundTag nbt = null;
            if (stack != null && (nbt = stack.m_41737_(KEY_SELF)) == null) {
                nbt = new CompoundTag();
            }
            return nbt;
        }).get());
    }

    public Settings(CompoundTag settingsNbt) {
        if (settingsNbt == null || settingsNbt.m_128456_()) {
            this.mode = Mode.MULTIBLOCK_SELECTION;
            this.rotation = Rotation.NONE;
            this.mirror = false;
            this.isPlaced = false;
        } else {
            this.mode = Mode.values()[Mth.m_14045_((int)settingsNbt.m_128451_(KEY_MODE), (int)0, (int)(Mode.values().length - 1))];
            this.rotation = Rotation.values()[settingsNbt.m_128441_(KEY_ROTATION) ? settingsNbt.m_128451_(KEY_ROTATION) : 0];
            this.mirror = settingsNbt.m_128471_(KEY_MIRROR);
            this.isPlaced = settingsNbt.m_128471_(KEY_PLACED);
            if (settingsNbt.m_128425_(KEY_MULTIBLOCK, 8)) {
                String str = settingsNbt.m_128461_(KEY_MULTIBLOCK);
                this.multiblock = MultiblockHandler.getByUniqueName((ResourceLocation)ResourceLocation.parse((String)str));
            }
            if (settingsNbt.m_128425_(KEY_POSITION, 10)) {
                CompoundTag pos = settingsNbt.m_128469_(KEY_POSITION);
                int x = pos.m_128451_("x");
                int y = pos.m_128451_("y");
                int z = pos.m_128451_("z");
                this.pos = new BlockPos(x, y, z);
            }
        }
    }

    public void rotateCW() {
        this.rotation = this.rotation.m_55952_(Rotation.CLOCKWISE_90);
    }

    public void rotateCCW() {
        this.rotation = this.rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
    }

    public void flip() {
        this.mirror = !this.mirror;
    }

    public void switchMode() {
        int id = this.mode.ordinal() + 1;
        this.mode = Mode.values()[id % Mode.values().length];
    }

    public void sendPacketToServer(InteractionHand hand) {
        MessageProjectorSync.sendToServer(this, hand);
    }

    public void sendPacketToClient(Player player, InteractionHand hand) {
        MessageProjectorSync.sendToClient(player, this, hand);
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMultiblock(@Nullable MultiblockHandler.IMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public void setPlaced(boolean isPlaced) {
        this.isPlaced = isPlaced;
    }

    public void setPos(@Nullable BlockPos pos) {
        this.pos = pos;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public boolean isPlaced() {
        return this.isPlaced;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KEY_MODE, this.mode.ordinal());
        nbt.m_128405_(KEY_ROTATION, this.rotation.ordinal());
        nbt.m_128379_(KEY_MIRROR, this.mirror);
        nbt.m_128379_(KEY_PLACED, this.isPlaced);
        if (this.multiblock != null) {
            nbt.m_128359_(KEY_MULTIBLOCK, this.multiblock.getUniqueName().toString());
        }
        if (this.pos != null) {
            CompoundTag pos = new CompoundTag();
            pos.m_128405_("x", this.pos.m_123341_());
            pos.m_128405_("y", this.pos.m_123342_());
            pos.m_128405_("z", this.pos.m_123343_());
            nbt.m_128365_(KEY_POSITION, (Tag)pos);
        }
        return nbt;
    }

    public ItemStack applyTo(ItemStack stack) {
        stack.m_41698_(KEY_SELF);
        stack.m_41783_().m_128365_(KEY_SELF, (Tag)this.toNbt());
        return stack;
    }

    public String toString() {
        return "\"Settings\":[" + this.toNbt().toString() + "]";
    }

    public static enum Mode {
        MULTIBLOCK_SELECTION,
        PROJECTION;

        final String translation = "desc.immersivepetroleum.info.projector.mode_" + this.ordinal();

        public Component getTranslated() {
            return Component.m_237115_((String)this.translation);
        }
    }
}

