/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersivepetroleum/SRU")
@ZenCodeType.Name(value="mods.immersivepetroleum.Hydrotreater")
public class SulfurRecoveryRecipeTweaker
implements IRecipeManager<HighPressureRefineryRecipe> {
    public RecipeType<HighPressureRefineryRecipe> getRecipeType() {
        return IPRecipeTypes.HYDROTREATER.get();
    }

    @ZenCodeType.Method
    public void removeAll() {
        HighPressureRefineryRecipe.recipes.clear();
    }

    @ZenCodeType.Method
    public void removeByOutputItem(IIngredient output) {
        HighPressureRefineryRecipe.recipes.values().removeIf(recipe -> output.matches((IItemStack)new MCItemStack(recipe.getOutputItem())));
    }

    @ZenCodeType.Method
    public void removeByOutputFluid(IFluidStack output) {
        HighPressureRefineryRecipe.recipes.values().removeIf(recipe -> recipe.getOutputFluid().isFluidEqual((FluidStack)output.getInternal()));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IFluidStack output, IItemStack outputItem, double chance, Many<KnownTag<Fluid>> inputFluid, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation id = ResourceUtils.ct("hydrotreater/" + name);
        FluidTagInput primary = new FluidTagInput(((KnownTag)inputFluid.getData()).getTagKey(), inputFluid.getAmount());
        this.newRecipe(id, output, outputItem, chance, primary, null, energy);
    }

    @ZenCodeType.Method
    public void addRecipeWithSecondary(String name, IFluidStack output, IItemStack outputItem, double chance, Many<KnownTag<Fluid>> inputFluid, Many<KnownTag<Fluid>> inputFluidSecondary, int energy) {
        name = this.fixRecipeName(name);
        ResourceLocation id = ResourceUtils.ct("hydrotreater/" + name);
        FluidTagInput primary = new FluidTagInput(((KnownTag)inputFluid.getData()).getTagKey(), inputFluid.getAmount());
        FluidTagInput secondary = new FluidTagInput(((KnownTag)inputFluidSecondary.getData()).getTagKey(), inputFluidSecondary.getAmount());
        this.newRecipe(id, output, outputItem, chance, primary, secondary, energy);
    }

    private void newRecipe(ResourceLocation id, IFluidStack output, IItemStack outputItem, double chance, FluidTagInput primary, FluidTagInput secondary, int energy) {
        HighPressureRefineryRecipe recipe = new HighPressureRefineryRecipe(id, (FluidStack)output.getInternal(), outputItem.getInternal(), primary, secondary, chance, energy, 1);
        HighPressureRefineryRecipe.recipes.put(id, recipe);
    }
}

