/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.immersivepetroleum.ReservoirRegistry")
public class ReservoirTweaker {
    @ZenCodeType.Method
    public static boolean remove(String name) {
        ResourceLocation id;
        List<ResourceLocation> test = ReservoirType.map.keySet().stream().filter(loc -> loc.m_135815_().contains(name)).toList();
        if (test.size() <= 1 && test.size() == 1 && ReservoirType.map.containsKey(id = test.get(0))) {
            ReservoirType.map.remove(id);
            return true;
        }
        return false;
    }

    @ZenCodeType.Method
    public static void removeAll() {
        ReservoirType.map.clear();
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.immersivepetroleum.ReservoirBuilder")
    public static class ReservoirBuilder {
        private boolean isValid = true;
        private final IFluidStack iFluidStack;
        private final int minSize;
        private final int maxSize;
        private final int traceAmount;
        private final int equilibrium;
        private final int weight;
        private boolean isDimBlacklist = false;
        private final List<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        private boolean isBioBlacklist = false;
        private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();

        @ZenCodeType.Constructor
        public ReservoirBuilder(IFluidStack fluid, int minSize, int maxSize, int traceAmount, int weight, @ZenCodeType.OptionalInt int equilibrium) {
            if (fluid == null) {
                this.isValid = false;
            }
            if (minSize <= 0) {
                this.isValid = false;
            }
            if (maxSize < minSize) {
                this.isValid = false;
            }
            if (weight <= 1) {
                this.isValid = false;
            }
            if (equilibrium <= 0) {
                this.isValid = false;
            }
            this.iFluidStack = fluid;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.traceAmount = traceAmount;
            this.weight = weight;
            this.equilibrium = equilibrium;
        }

        @ZenCodeType.Method
        public ReservoirBuilder setDimensions(boolean blacklist, String[] names) {
            if (!this.dimensions.isEmpty()) {
                throw new IllegalArgumentException("Dimensions B/W-List already set!");
            }
            this.isDimBlacklist = blacklist;
            for (String name : names) {
                try {
                    ResourceLocation rl = ResourceLocation.parse((String)name);
                    this.dimensions.add(rl);
                }
                catch (ResourceLocationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        @ZenCodeType.Method
        public ReservoirBuilder setBiomes(boolean blacklist, String[] names) {
            if (!this.dimensions.isEmpty()) {
                throw new IllegalArgumentException("Biomes B/W-List already set!");
            }
            this.isBioBlacklist = blacklist;
            for (String name : names) {
                try {
                    ResourceLocation rl = ResourceLocation.parse((String)name);
                    this.biomes.add(rl);
                }
                catch (ResourceLocationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        @ZenCodeType.Method
        public void build(String name) {
            ResourceLocation id;
            if (name.isEmpty()) {
                this.isValid = false;
            }
            if (this.isValid && !ReservoirType.map.containsKey(id = ResourceUtils.ct(name))) {
                ReservoirType reservoir = new ReservoirType(name, id, this.iFluidStack.getFluid(), this.minSize, this.maxSize, this.traceAmount, this.equilibrium, this.weight);
                reservoir.setDimensions(this.isDimBlacklist, this.dimensions);
                reservoir.setDimensions(this.isBioBlacklist, this.biomes);
                ReservoirHandler.addReservoir(id, reservoir);
            }
        }
    }
}

