/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.client.gui.SeismicSurveyScreen;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessageSurveyResultDetails {
    public static void sendRequestToServer(SurveyScan scan) {
        IPPacketHandler.sendToServer(new ClientToServer(scan));
    }

    private static void sendReply(Player player, UUID scanId, BitSet replyBitSet) {
        IPPacketHandler.sendToPlayer(player, new ServerToClient(scanId, replyBitSet));
    }

    public static class ClientToServer
    implements INetMessage {
        private int x;
        private int z;
        private UUID scanId;

        public ClientToServer(SurveyScan scan) {
            this.x = scan.getX();
            this.z = scan.getZ();
            this.scanId = scan.getUuid();
        }

        public ClientToServer(FriendlyByteBuf buf) {
            this.x = buf.readInt();
            this.z = buf.readInt();
            this.scanId = buf.m_130259_();
        }

        @Override
        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.z);
            buf.m_130077_(this.scanId);
        }

        @Override
        public void process(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer sPlayer = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender());
                ServerLevel sLevel = sPlayer.m_284548_();
                if (sLevel.isAreaLoaded(new BlockPos(this.x, 0, this.z), 32)) {
                    BitSet set = this.compileBitSet((Level)sLevel);
                    MessageSurveyResultDetails.sendReply((Player)sPlayer, this.scanId, set);
                }
            });
        }

        private BitSet compileBitSet(Level level) {
            ArrayList<ReservoirIsland> islandCache = new ArrayList<ReservoirIsland>();
            BitSet set = new BitSet(4225);
            int r = 32;
            int j = -32;
            int a = 0;
            while (j <= 32) {
                int i = -32;
                int b = 0;
                while (i <= 32) {
                    int x = this.x - i;
                    int z = this.z - j;
                    double current = ReservoirHandler.getValueOf(level, x, z);
                    if (current != -1.0) {
                        Optional<ReservoirIsland> optional = islandCache.stream().filter(res -> res.contains(x, z)).findFirst();
                        ReservoirIsland nearbyIsland = optional.orElse(null);
                        if (nearbyIsland == null && (nearbyIsland = ReservoirHandler.getIslandNoCache(level, new ColumnPos(x, z))) != null) {
                            islandCache.add(nearbyIsland);
                        }
                        if (nearbyIsland != null) {
                            set.set(a * 65 + b);
                        }
                    }
                    ++i;
                    ++b;
                }
                ++j;
                ++a;
            }
            return set;
        }
    }

    public static class ServerToClient
    implements INetMessage {
        private BitSet replyBitSet;
        private UUID scanId;

        public ServerToClient(UUID scanId, BitSet replyBitSet) {
            this.scanId = scanId;
            this.replyBitSet = replyBitSet;
        }

        public ServerToClient(FriendlyByteBuf buf) {
            this.scanId = buf.m_130259_();
            this.replyBitSet = buf.m_178384_();
        }

        @Override
        public void toBytes(FriendlyByteBuf buf) {
            buf.m_130077_(this.scanId);
            buf.m_178350_(this.replyBitSet);
        }

        @Override
        public void process(Supplier<NetworkEvent.Context> context) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                Screen patt4381$temp = MCUtil.getScreen();
                if (patt4381$temp instanceof SeismicSurveyScreen) {
                    SeismicSurveyScreen surveyScreen = (SeismicSurveyScreen)patt4381$temp;
                    if (this.scanId.equals(surveyScreen.scan.getUuid())) {
                        surveyScreen.setBitSet(this.replyBitSet);
                    }
                }
            });
        }
    }
}

