/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.PumpjackLogic;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PumpjackLubricationHandler
implements LubricatedHandler.ILubricationHandler<IMultiblockBEHelperMaster<PumpjackLogic.State>, PumpjackLogic.State> {
    private static final BlockPos RELATIVE_GHOST_POS = new BlockPos(3, 0, 4);
    private static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/lube_pipe.png");
    @OnlyIn(value=Dist.CLIENT)
    private static Supplier<IPModel> pipes_normal;
    @OnlyIn(value=Dist.CLIENT)
    private static Supplier<IPModel> pipes_mirrored;

    @Override
    public boolean isPlacedCorrectly(Level world, BlockPos lubricatorPosition, Direction lubricatorFacing) {
        IMultiblockLevel level;
        IMultiblockBE mb;
        BlockPos target = lubricatorPosition.m_121945_(lubricatorFacing);
        BlockEntity blockEntity = world.m_7702_(target);
        if (blockEntity instanceof IMultiblockBE && (mb = (IMultiblockBE)blockEntity).getHelper().getContext() != null && (level = mb.getHelper().getContext().getLevel()).toRelative(lubricatorPosition).equals((Object)RELATIVE_GHOST_POS)) {
            MultiblockOrientation orientation = level.getOrientation();
            return orientation.front().m_122427_() == (orientation.mirrored() ? lubricatorFacing : lubricatorFacing.m_122424_());
        }
        return false;
    }

    @Override
    public LubricatedHandler.ILubricationHandler.GhostInfo getGhostBlockPosition(Level world, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte) {
        IMultiblockLevel level = mbte.getContext().getLevel();
        BlockPos position = level.toAbsolute(RELATIVE_GHOST_POS);
        MultiblockOrientation orientation = level.getOrientation();
        Direction facing = (orientation.mirrored() ? orientation.front().m_122424_() : orientation.front()).m_122428_();
        return new LubricatedHandler.ILubricationHandler.GhostInfo(position, facing);
    }

    @Override
    public boolean isMachineEnabled(Level world, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte) {
        return ((PumpjackLogic.State)mbte.getState()).wasActive;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void lubricateClient(ClientLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte) {
        ((PumpjackLogic.State)mbte.getState()).activeTicks += 0.25f;
    }

    @Override
    public void lubricateServer(ServerLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte) {
        if (ticks % 4 == 0) {
            mbte.tickServer();
        }
    }

    @Override
    public void spawnLubricantParticles(ClientLevel world, BlockPos lubricatorPosition, Direction facing, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte) {
        Direction f = mbte.getContext().getLevel().getOrientation().mirrored() ? facing : facing.m_122424_();
        float location = world.f_46441_.m_188501_();
        boolean flip = f.m_122434_() == Direction.Axis.Z ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE ^ !mbte.getContext().getLevel().getOrientation().mirrored();
        float xO = 2.5f;
        float zO = -0.15f;
        float yO = 2.25f;
        if (location > 0.5f) {
            xO = 1.7f;
            yO = 2.9f;
            zO = -1.5f;
        }
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricatorPosition.m_123341_() + (f.m_122434_() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricatorPosition.m_123342_() + yO;
        float z = (float)lubricatorPosition.m_123343_() + (f.m_122434_() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r2 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r3 = world.f_46441_.m_188501_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, IMultiblockBEHelperMaster<PumpjackLogic.State> mbte, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IPModel model;
        if (mbte.getContext() == null) {
            return;
        }
        MultiblockOrientation orientation = mbte.getContext().getLevel().getOrientation();
        boolean mirrored = orientation.mirrored();
        Direction rotation = orientation.front();
        if (rotation == Direction.NORTH) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrix.m_252880_(-2.0f, 0.0f, mirrored ? 1.0f : -3.0f);
        } else if (rotation == Direction.SOUTH) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            matrix.m_252880_(-1.0f, 0.0f, mirrored ? 0.0f : -4.0f);
        } else if (rotation == Direction.EAST) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            matrix.m_252880_(-1.0f, 0.0f, mirrored ? 1.0f : -3.0f);
        } else if (rotation == Direction.WEST) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252880_(-2.0f, 0.0f, mirrored ? 0.0f : -4.0f);
        }
        if (mirrored) {
            if (pipes_mirrored == null) {
                pipes_mirrored = IPModels.getSupplier("pumpjack_lubepipes_mirrored");
            }
            model = pipes_mirrored.get();
        } else {
            if (pipes_normal == null) {
                pipes_normal = IPModels.getSupplier("pumpjack_lubepipes_normal");
            }
            model = pipes_normal.get();
        }
        if (model != null) {
            model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

