/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BucketWheelLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ExcavatorLogic;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExcavatorLubricationHandler
implements LubricatedHandler.ILubricationHandler<IMultiblockBEHelperMaster<ExcavatorLogic.State>, ExcavatorLogic.State> {
    private static final BlockPos RELATIVE_GHOST_POS = new BlockPos(3, 0, 1);
    private static final ResourceLocation TEXTURE = ResourceUtils.ip("textures/models/lube_pipe.png");
    private static Supplier<IPModel> pipes_normal;
    private static Supplier<IPModel> pipes_mirrored;

    @Override
    public boolean isPlacedCorrectly(Level world, BlockPos lubricatorPosition, Direction lubricatorFacing) {
        IMultiblockLevel level;
        IMultiblockBE mb;
        BlockPos target = lubricatorPosition.m_121945_(lubricatorFacing);
        BlockEntity blockEntity = world.m_7702_(target);
        if (blockEntity instanceof IMultiblockBE && (mb = (IMultiblockBE)blockEntity).getHelper().getContext() != null && (level = mb.getHelper().getContext().getLevel()).toRelative(lubricatorPosition).equals((Object)RELATIVE_GHOST_POS)) {
            MultiblockOrientation orientation = level.getOrientation();
            Direction dir = orientation.mirrored() ? orientation.front().m_122427_() : orientation.front().m_122428_();
            return dir == lubricatorFacing;
        }
        return false;
    }

    @Override
    public LubricatedHandler.ILubricationHandler.GhostInfo getGhostBlockPosition(Level world, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        IMultiblockLevel level = mbte.getContext().getLevel();
        BlockPos position = level.toAbsolute(RELATIVE_GHOST_POS);
        MultiblockOrientation orientation = level.getOrientation();
        Direction facing = orientation.mirrored() ? orientation.front().m_122427_() : orientation.front().m_122428_();
        return new LubricatedHandler.ILubricationHandler.GhostInfo(position, facing);
    }

    @Override
    public boolean isMachineEnabled(Level world, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        MultiblockBlockEntityMaster<BucketWheelLogic.State> wheelMaster = this.getWheelMaster(world, mbte);
        return wheelMaster != null && ((BucketWheelLogic.State)wheelMaster.getHelper().getState()).active;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void lubricateClient(ClientLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        MultiblockBlockEntityMaster<BucketWheelLogic.State> wheelMaster = this.getWheelMaster((Level)world, mbte);
        if (wheelMaster == null) {
            return;
        }
        ((BucketWheelLogic.State)wheelMaster.getHelper().getState()).rotation += (float)((Double)IEServerConfig.MACHINES.excavator_speed.get() / 4.0);
        ((BucketWheelLogic.State)wheelMaster.getHelper().getState()).rotation %= 360.0f;
    }

    @Override
    public void lubricateServer(ServerLevel world, Fluid lubricant, int ticks, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        MultiblockBlockEntityMaster<BucketWheelLogic.State> wheelMaster = this.getWheelMaster((Level)world, mbte);
        if (wheelMaster == null) {
            return;
        }
        if (ticks % 4 == 0) {
            wheelMaster.getHelper().tickServer();
        }
    }

    @Nullable
    private MultiblockBlockEntityMaster<BucketWheelLogic.State> getWheelMaster(Level world, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        MultiblockBlockEntityMaster wheel;
        BlockPos wheelPos = mbte.getContext().getLevel().toAbsolute(ExcavatorLogic.WHEEL_CENTER);
        BlockEntity center = world.m_7702_(wheelPos);
        return center instanceof MultiblockBlockEntityMaster ? (wheel = (MultiblockBlockEntityMaster)center) : null;
    }

    @Override
    public void spawnLubricantParticles(ClientLevel world, BlockPos lubricatorPosition, Direction facing, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte) {
        boolean mirrored = mbte.getContext().getLevel().getOrientation().mirrored();
        Direction f = mirrored ? facing : facing.m_122424_();
        float location = world.f_46441_.m_188501_();
        boolean flip = f.m_122434_() == Direction.Axis.Z ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE ^ !mirrored;
        float xO = 1.2f;
        float zO = -0.5f;
        float yO = 0.5f;
        if (location > 0.5f) {
            xO = 0.9f;
            yO = 0.8f;
            zO = 1.75f;
        }
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricatorPosition.m_123341_() + (f.m_122434_() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricatorPosition.m_123342_() + yO;
        float z = (float)lubricatorPosition.m_123343_() + (f.m_122434_() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r2 = (world.f_46441_.m_188501_() - 0.5f) * 2.0f;
            float r3 = world.f_46441_.m_188501_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, IMultiblockBEHelperMaster<ExcavatorLogic.State> mbte, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IPModel model;
        MultiblockOrientation orientation = mbte.getContext().getLevel().getOrientation();
        boolean mirrored = orientation.mirrored();
        Direction rotation = orientation.front();
        if (rotation == Direction.NORTH) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrix.m_252880_(-5.0f, 0.0f, mirrored ? 1.0f : -3.0f);
        } else if (rotation == Direction.SOUTH) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            matrix.m_252880_(-4.0f, 0.0f, mirrored ? 0.0f : -4.0f);
        } else if (rotation == Direction.EAST) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            matrix.m_252880_(-4.0f, 0.0f, mirrored ? 1.0f : -3.0f);
        } else if (rotation == Direction.WEST) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252880_(-5.0f, 0.0f, mirrored ? 0.0f : -4.0f);
        }
        if (mirrored) {
            if (pipes_mirrored == null) {
                pipes_mirrored = IPModels.getSupplier("excavator_lubepipes_mirrored");
            }
            model = pipes_mirrored.get();
        } else {
            if (pipes_normal == null) {
                pipes_normal = IPModels.getSupplier("excavator_lubepipes_normal");
            }
            model = pipes_normal.get();
        }
        if (model != null) {
            model.m_7695_(matrix, buffer.m_6299_(model.m_103119_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

