/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class OilCanItem
extends IPItemBase {
    public OilCanItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new FluidHandlerItemStack(stack, 8000);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (ForgeCapabilities.FLUID_HANDLER_ITEM == null) {
            return;
        }
        FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fluid -> {
            if (!fluid.isEmpty() && fluid.getAmount() > 0) {
                MutableComponent out = ((MutableComponent)fluid.getDisplayName()).m_7220_((Component)Component.m_237113_((String)(": " + fluid.getAmount() + "/8000mB"))).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)out);
            } else {
                tooltip.add((Component)Component.m_237113_((String)I18n.m_118938_((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0])));
            }
        });
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        BlockEntity te = level.m_7702_(pos);
        if (te != null) {
            LazyOptional capability = te.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (capability.isPresent()) {
                capability.ifPresent(handler -> FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)handler));
                return InteractionResult.SUCCESS;
            }
            return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> this.tryLubricateMachine(level, pos, player, (IFluidHandlerItem)handler)).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryLubricateMachine(Level level, BlockPos pos, Player player, @NotNull IFluidHandlerItem handler) {
        if (!(handler instanceof FluidHandlerItemStack)) {
            return InteractionResult.PASS;
        }
        FluidHandlerItemStack can = (FluidHandlerItemStack)handler;
        FluidStack fs = can.getFluid();
        if (!fs.isEmpty() && LubricantHandler.isValidLube(fs.getFluid())) {
            int amountNeeded = LubricantHandler.getLubeAmount(fs.getFluid()) * 5 * 20;
            if (fs.getAmount() >= amountNeeded && LubricatedHandler.lubricateTile(level, pos, fs.getFluid(), 600)) {
                player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    can.drain(amountNeeded, IFluidHandler.FluidAction.EXECUTE);
                }
                Utils.unlockIPAdvancement(player, "main/oil_can");
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        this.m_6880_(stack, null, target, InteractionHand.MAIN_HAND);
        return true;
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        if (target instanceof IronGolem) {
            IronGolem golem = (IronGolem)target;
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(con -> {
                FluidHandlerItemStack handler;
                if (con instanceof FluidHandlerItemStack && !(handler = (FluidHandlerItemStack)con).getFluid().isEmpty() && LubricantHandler.isValidLube(handler.getFluid().getFluid())) {
                    int amountNeeded = LubricantHandler.getLubeAmount(handler.getFluid().getFluid()) * 5 * 20;
                    if (handler.getFluid().getAmount() >= amountNeeded) {
                        player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                        golem.m_21153_(Math.max(golem.m_21223_() + 2.0f, golem.m_21233_()));
                        golem.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 1));
                        golem.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 1));
                        if (!player.m_7500_()) {
                            handler.drain(amountNeeded, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack).isPresent();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain")) {
            ItemStack ret = stack.m_41777_();
            FluidUtil.getFluidHandler((ItemStack)ret).ifPresent(handler -> {
                handler.drain(ItemNBTHelper.getInt((ItemStack)ret, (String)"jerrycanDrain"), IFluidHandler.FluidAction.EXECUTE);
                ItemNBTHelper.remove((ItemStack)ret, (String)"jerrycanDrain");
            });
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack).isPresent()) {
            ItemStack ret = stack.m_41777_();
            FluidUtil.getFluidHandler((ItemStack)ret).ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
            return ret;
        }
        return stack;
    }
}

