/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.gui.IESlot;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class MotorboatItem
extends IPItemBase
implements IUpgradeableTool {
    public static final String UPGRADE_TYPE = "MOTORBOAT";

    public MotorboatItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new IPItemStackHandler(4);
    }

    public CompoundTag getUpgrades(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128469_("upgrades") : new CompoundTag();
    }

    public void clearUpgrades(ItemStack stack) {
        ItemUtils.removeTag((ItemStack)stack, (String)"upgrades");
    }

    protected NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (handler == null) {
            ImmersivePetroleum.log.debug("No valid inventory handler found for " + stack);
            return NonNullList.m_122779_();
        }
        if (handler instanceof IPItemStackHandler) {
            IPItemStackHandler ipStackHandler = (IPItemStackHandler)handler;
            return ipStackHandler.getContainedItems();
        }
        ImmersivePetroleum.log.warn("Inefficiently getting contained items. Why does " + stack + " have a non-IP IItemHandler?");
        NonNullList inv = NonNullList.m_122780_((int)handler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < handler.getSlots(); ++i) {
            inv.set(i, (Object)handler.getStackInSlot(i));
        }
        return inv;
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        if (w.f_46443_) {
            return;
        }
        this.clearUpgrades(stack);
        LazyOptional lazy = stack.getCapability(ForgeCapabilities.ITEM_HANDLER);
        lazy.ifPresent(handler -> {
            CompoundTag nbt = new CompoundTag();
            for (int i = 0; i < handler.getSlots(); ++i) {
                IUpgrade upg;
                ItemStack u = handler.getStackInSlot(i);
                Item patt4037$temp = u.m_41720_();
                if (!(patt4037$temp instanceof IUpgrade) || !(upg = (IUpgrade)patt4037$temp).getUpgradeTypes(u).contains(UPGRADE_TYPE) || !upg.canApplyUpgrades(stack, u)) continue;
                upg.applyUpgrades(stack, u, nbt);
            }
            stack.m_41784_().m_128365_("upgrades", (Tag)nbt);
            this.finishUpgradeRecalculation(stack);
        });
    }

    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level world, Supplier<Player> getPlayer, IItemHandler inv) {
        if (inv != null) {
            return new Slot[]{new IESlot.Upgrades(container, inv, 0, 78, 30, UPGRADE_TYPE, stack, true, world, getPlayer), new IESlot.Upgrades(container, inv, 1, 98, 40, UPGRADE_TYPE, stack, true, world, getPlayer), new IESlot.Upgrades(container, inv, 2, 118, 30, UPGRADE_TYPE, stack, true, world, getPlayer)};
        }
        return new Slot[0];
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        boolean hasUpgrades = this.getContainedItems(stack).stream().anyMatch(s -> s != ItemStack.f_41583_);
        Component c = super.m_7626_(stack);
        if (hasUpgrades) {
            c = Component.m_237115_((String)"desc.immersivepetroleum.flavour.speedboat.prefix").m_7220_(c).m_130940_(ChatFormatting.GOLD);
        }
        return c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        FluidStack fs;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128441_("tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("tank"))) != null) {
            tooltip.add((Component)((MutableComponent)fs.getDisplayName()).m_130946_(": " + fs.getAmount() + "mB").m_130940_(ChatFormatting.GRAY));
        }
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                tooltip.add((Component)Component.m_237110_((String)"desc.immersivepetroleum.flavour.speedboat.upgrade", (Object[])new Object[]{i + 1}).m_7220_(handler.getStackInSlot(i).m_41786_()));
            }
        });
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        float f1 = playerIn.f_19860_ + (playerIn.m_146909_() - playerIn.f_19860_);
        float f2 = playerIn.f_19859_ + (playerIn.m_146908_() - playerIn.f_19859_);
        double d0 = playerIn.f_19854_ + (playerIn.m_20185_() - playerIn.f_19854_);
        double d1 = playerIn.f_19855_ + (playerIn.m_20186_() - playerIn.f_19855_) + (double)playerIn.m_20192_();
        double d2 = playerIn.f_19856_ + (playerIn.m_20189_() - playerIn.f_19856_);
        Vec3 vec3d = new Vec3(d0, d1, d2);
        float f3 = Mth.m_14089_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = Mth.m_14031_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec3d1 = vec3d.m_82520_((double)f7 * 5.0, (double)f6 * 5.0, (double)f8 * 5.0);
        BlockHitResult raytraceresult = worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)playerIn));
        Vec3 vec3d2 = playerIn.m_20252_(1.0f);
        boolean flag = false;
        AABB bb = playerIn.m_20191_();
        List list = worldIn.m_45933_((Entity)playerIn, bb.m_82363_(vec3d2.f_82479_ * 5.0, vec3d2.f_82480_ * 5.0, vec3d2.f_82481_ * 5.0).m_82400_(1.0));
        for (Entity entity : list) {
            AABB axisalignedbb;
            if (!entity.m_6087_() || !(axisalignedbb = entity.m_20191_()).m_82400_((double)entity.m_6143_()).m_82390_(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        Vec3 hit = raytraceresult.m_82450_();
        Block block = worldIn.m_8055_(BlockPos.m_274446_((Position)hit.m_82520_(0.0, 0.5, 0.0))).m_60734_();
        boolean flag1 = block == Blocks.f_49990_;
        MotorboatEntity entityboat = new MotorboatEntity(worldIn, hit.f_82479_, flag1 ? hit.f_82480_ - 0.12 : hit.f_82480_, hit.f_82481_);
        entityboat.m_146922_(playerIn.f_19859_);
        entityboat.setUpgrades(this.getContainedItems(itemstack));
        entityboat.readTank(itemstack.m_41783_());
        if (worldIn.m_186434_((Entity)entityboat, entityboat.m_20191_().m_82400_(-0.1)).iterator().hasNext()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (!worldIn.f_46443_) {
            worldIn.m_7967_((Entity)entityboat);
        }
        if (!playerIn.m_7500_()) {
            itemstack.m_41774_(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }
}

