/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.entity.MolotovItemEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MolotovItem
extends IPItemBase {
    private static final int SECONDS = 15;
    private final boolean isLit;

    private static Item.Properties makeProperty(boolean isLit) {
        Item.Properties prop = new Item.Properties().m_41487_(isLit ? 1 : 64).m_41503_(15).setNoRepair();
        return prop;
    }

    public MolotovItem(boolean isLit) {
        super(MolotovItem.makeProperty(isLit));
        this.isLit = isLit;
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return !this.isLit;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (this.isLit && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pStack.m_41782_() && pStack.m_41783_().m_128425_("lit_time", 4)) {
                int duration = (int)(pLevel.m_46467_() - pStack.m_41783_().m_128454_("lit_time")) / 20;
                if (player.m_150110_().f_35937_) {
                    if (duration > 0 && pStack.m_41773_() == 0) {
                        pStack.m_41721_(1);
                    }
                } else {
                    if (duration > 15) {
                        player.m_141942_(pSlotId).m_142104_(new ItemStack((ItemLike)Items.f_42590_, 1));
                        return;
                    }
                    if (pStack.m_41773_() != duration) {
                        pStack.m_41721_(duration);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (this.isLit) {
            ItemStack stack = pPlayer.m_21120_(pUsedHand);
            if (stack.m_41768_() && !pLevel.f_46443_) {
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11870_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
                MolotovItemEntity entity = new MolotovItemEntity(pLevel, (LivingEntity)pPlayer);
                entity.m_37446_(stack);
                entity.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 0.75f, 1.0f);
                pLevel.m_7967_((Entity)entity);
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pUsedHand));
        }
        ItemStack mainStack = pPlayer.m_21120_(pUsedHand);
        ItemStack offStack = pPlayer.m_21120_(InteractionHand.OFF_HAND);
        if (mainStack.m_41720_() == this && offStack.m_41720_() == Items.f_42409_) {
            pPlayer.m_6672_(pUsedHand);
        }
        return InteractionResultHolder.m_19096_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!this.isLit && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ItemStack mainStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (mainStack.m_41720_() == this && offStack.m_41720_() == Items.f_42409_) {
                pStack.m_41774_(1);
                if (player instanceof ServerPlayer && !player.m_150110_().f_35937_) {
                    offStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
                }
                ItemStack lit = new ItemStack((ItemLike)IPContent.Items.MOLOTOV_LIT.get(), 1);
                lit.m_41784_().m_128356_("lit_time", pLevel.m_46467_() - 1L);
                return lit;
            }
        }
        return pStack;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 20;
    }
}

