/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class IPSlot
extends SlotItemHandler {
    private final Predicate<ItemStack> consumer;

    public IPSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
        this.consumer = null;
    }

    public IPSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition, Predicate<ItemStack> placeCheck) {
        super(inventoryIn, index, xPosition, yPosition);
        this.consumer = placeCheck;
    }

    public boolean m_5857_(ItemStack pStack) {
        if (this.consumer != null) {
            return this.consumer.test(pStack);
        }
        return super.m_5857_(pStack);
    }

    public static class FluidContainer
    extends IPSlot {
        FluidFilter filter;

        public FluidContainer(IItemHandler inv, int id, int x, int y, FluidFilter filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        @Override
        public boolean m_5857_(@Nonnull ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                return switch (this.filter) {
                    default -> throw new IncompatibleClassChangeError();
                    case FluidFilter.FULL -> !handler.getFluidInTank(0).isEmpty();
                    case FluidFilter.EMPTY -> handler.getFluidInTank(0).isEmpty();
                    case FluidFilter.ANY -> true;
                };
            }).orElse(false);
        }

        public static enum FluidFilter {
            ANY,
            EMPTY,
            FULL;

        }
    }

    public static class CokerInput
    extends IPSlot {
        public CokerInput(AbstractContainerMenu container, IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        @Override
        public boolean m_5857_(ItemStack stack) {
            return !stack.m_41619_() && CokerUnitRecipe.hasRecipeWithInput(stack, true);
        }
    }

    public static class ItemOutput
    extends IPSlot {
        public ItemOutput(IItemHandler inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Override
        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

