/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.collect.Lists;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.entity.IPEntityTypes;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.items.GasolineBottleItem;
import flaxbeard.immersivepetroleum.common.items.MotorboatItem;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MotorboatEntity
extends Boat
implements IEntityAdditionalSpawnData {
    static final EntityDataAccessor<String> TANK_FLUID = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    static final EntityDataAccessor<Integer> TANK_AMOUNT = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<ItemStack> UPGRADE_0 = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    static final EntityDataAccessor<ItemStack> UPGRADE_1 = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    static final EntityDataAccessor<ItemStack> UPGRADE_2 = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    static final EntityDataAccessor<ItemStack> UPGRADE_3 = SynchedEntityData.m_135353_(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public boolean isFireproof = false;
    public boolean hasIcebreaker = false;
    public boolean hasTank = false;
    public boolean hasRudders = false;
    public boolean hasPaddles = false;
    public boolean isBoosting = false;
    public float lastMoving;
    public float propellerYRotation = 0.0f;
    public float propellerXRot = 0.0f;
    public float propellerXRotSpeed = 0.0f;
    protected float oYRot;
    protected boolean fastEnough;
    protected int oFuelAmount;

    public static EntityDataAccessor<Byte> getFlags() {
        return f_19805_;
    }

    public MotorboatEntity(Level world) {
        this((EntityType<MotorboatEntity>)((EntityType)IPEntityTypes.MOTORBOAT.get()), world);
    }

    public MotorboatEntity(Level world, double x, double y, double z) {
        this((EntityType<MotorboatEntity>)((EntityType)IPEntityTypes.MOTORBOAT.get()), world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public MotorboatEntity(EntityType<MotorboatEntity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TANK_FLUID, (Object)"");
        this.f_19804_.m_135372_(TANK_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(UPGRADE_0, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(UPGRADE_1, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(UPGRADE_2, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(UPGRADE_3, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        String fluid = "";
        int amount = 0;
        ItemStack stack0 = ItemStack.f_41583_;
        ItemStack stack1 = ItemStack.f_41583_;
        ItemStack stack2 = ItemStack.f_41583_;
        ItemStack stack3 = ItemStack.f_41583_;
        if (compound.m_128441_("tank")) {
            CompoundTag tank = compound.m_128469_("tank");
            fluid = tank.m_128461_("fluid");
            amount = tank.m_128451_("amount");
        }
        if (compound.m_128441_("upgrades")) {
            CompoundTag upgrades = compound.m_128469_("upgrades");
            stack0 = ItemStack.m_41712_((CompoundTag)upgrades.m_128469_("0"));
            stack1 = ItemStack.m_41712_((CompoundTag)upgrades.m_128469_("1"));
            stack2 = ItemStack.m_41712_((CompoundTag)upgrades.m_128469_("2"));
            stack3 = ItemStack.m_41712_((CompoundTag)upgrades.m_128469_("3"));
        }
        this.f_19804_.m_135381_(TANK_FLUID, (Object)fluid);
        this.f_19804_.m_135381_(TANK_AMOUNT, (Object)amount);
        this.f_19804_.m_135381_(UPGRADE_0, (Object)stack0);
        this.f_19804_.m_135381_(UPGRADE_1, (Object)stack1);
        this.f_19804_.m_135381_(UPGRADE_2, (Object)stack2);
        this.f_19804_.m_135381_(UPGRADE_3, (Object)stack3);
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        String fluid = (String)this.f_19804_.m_135370_(TANK_FLUID);
        int amount = (Integer)this.f_19804_.m_135370_(TANK_AMOUNT);
        ItemStack stack0 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_0);
        ItemStack stack1 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_1);
        ItemStack stack2 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_2);
        ItemStack stack3 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_3);
        CompoundTag tank = new CompoundTag();
        tank.m_128359_("fluid", fluid);
        tank.m_128405_("amount", amount);
        compound.m_128365_("tank", (Tag)tank);
        CompoundTag upgrades = new CompoundTag();
        upgrades.m_128365_("0", (Tag)stack0.serializeNBT());
        upgrades.m_128365_("1", (Tag)stack1.serializeNBT());
        upgrades.m_128365_("2", (Tag)stack2.serializeNBT());
        upgrades.m_128365_("3", (Tag)stack3.serializeNBT());
        compound.m_128365_("upgrades", (Tag)upgrades);
    }

    public void setUpgrades(NonNullList<ItemStack> stacks) {
        if (stacks != null && stacks.size() > 0) {
            ItemStack o0 = (ItemStack)stacks.get(0);
            ItemStack o1 = (ItemStack)stacks.get(1);
            ItemStack o2 = (ItemStack)stacks.get(2);
            ItemStack o3 = (ItemStack)stacks.get(3);
            this.f_19804_.m_135381_(UPGRADE_0, (Object)o0);
            this.f_19804_.m_135381_(UPGRADE_1, (Object)o1);
            this.f_19804_.m_135381_(UPGRADE_2, (Object)o2);
            this.f_19804_.m_135381_(UPGRADE_3, (Object)o3);
        }
    }

    public boolean isLeftDown() {
        return this.f_38273_;
    }

    public boolean isRightDown() {
        return this.f_38274_;
    }

    public boolean isForwardDown() {
        return this.f_38275_;
    }

    public boolean isBackDown() {
        return this.f_38276_;
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == UPGRADE_0 || key == UPGRADE_1 || key == UPGRADE_2 || key == UPGRADE_3) {
            NonNullList<ItemStack> upgrades = this.getUpgrades();
            this.isFireproof = false;
            this.hasIcebreaker = false;
            for (ItemStack upgrade : upgrades) {
                if (upgrade == null || upgrade == ItemStack.f_41583_) continue;
                Item item = upgrade.m_41720_();
                if (item == IPContent.BoatUpgrades.REINFORCED_HULL.get()) {
                    this.isFireproof = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.ICE_BREAKER.get()) {
                    this.hasIcebreaker = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.TANK.get()) {
                    this.hasTank = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.RUDDERS.get()) {
                    this.hasRudders = true;
                    continue;
                }
                if (item != IPContent.BoatUpgrades.PADDLES.get()) continue;
                this.hasPaddles = true;
            }
        }
    }

    public void setContainedFluid(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            this.f_19804_.m_135381_(TANK_FLUID, (Object)"");
            this.f_19804_.m_135381_(TANK_AMOUNT, (Object)0);
        } else {
            this.f_19804_.m_135381_(TANK_FLUID, (Object)(stack.getFluid() == null ? "" : RegistryUtils.getRegistryNameOf(stack.getFluid()).toString()));
            this.f_19804_.m_135381_(TANK_AMOUNT, (Object)stack.getAmount());
        }
    }

    public FluidStack getContainedFluid() {
        String fluidName = (String)this.f_19804_.m_135370_(TANK_FLUID);
        int amount = (Integer)this.f_19804_.m_135370_(TANK_AMOUNT);
        if (fluidName == null || fluidName.isEmpty() || amount == 0) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.parse((String)fluidName));
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, amount);
    }

    public double m_6048_() {
        return 0.05;
    }

    @Nonnull
    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Vec3 vec3 = MotorboatEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)pLivingEntity.m_20205_(), (float)pLivingEntity.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)this.m_20191_().f_82292_, (double)d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1) && !this.m_9236_().m_6425_(blockpos1).m_205070_(FluidTags.f_13132_)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.m_9236_().m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : pLivingEntity.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec31, (LivingEntity)pLivingEntity, (Pose)pose)) continue;
                    pLivingEntity.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return new Vec3(this.m_20185_(), this.m_20191_().f_82292_, this.m_20189_());
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.m_6673_(source) || this.isFireproof && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            boolean isCreativePlayer;
            if (source.m_269014_() && source.m_7640_() != null && this.m_20363_(source.m_7640_())) {
                return false;
            }
            this.m_38362_(-this.m_38386_());
            this.m_38354_(10);
            this.m_38311_(this.m_38384_() + amount * 10.0f);
            this.m_5834_();
            boolean isPlayer = source.m_7640_() instanceof Player;
            boolean bl = isCreativePlayer = isPlayer && ((Player)source.m_7640_()).m_150110_().f_35937_;
            if ((isCreativePlayer || this.m_38384_() > 40.0f) && (!this.isFireproof || isPlayer) || this.m_38384_() > 240.0f) {
                if (!isCreativePlayer && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    MotorboatItem item = (MotorboatItem)this.m_38369_();
                    ItemStack stack = new ItemStack((ItemLike)item, 1);
                    LazyOptional handler = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    handler.ifPresent(itemHandler -> {
                        if (itemHandler instanceof IPItemStackHandler) {
                            NonNullList<ItemStack> upgrades = this.getUpgrades();
                            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                                itemHandler.insertItem(i, (ItemStack)upgrades.get(i), false);
                            }
                        }
                    });
                    this.writeTank(stack.m_41784_(), true);
                    if (isPlayer) {
                        Player player = (Player)source.m_7640_();
                        if (!player.m_36356_(stack)) {
                            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                            itemEntity.m_32061_();
                            this.m_9236_().m_7967_((Entity)itemEntity);
                        }
                    } else {
                        this.m_5552_(stack, 0.0f);
                    }
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return true;
    }

    public void readTank(CompoundTag nbt) {
        FluidTank tank = new FluidTank(this.getMaxFuel());
        if (nbt != null) {
            tank.readFromNBT(nbt.m_128469_("tank"));
        }
        this.setContainedFluid(tank.getFluid());
    }

    public void writeTank(CompoundTag nbt, boolean toItem) {
        boolean write;
        FluidTank tank = new FluidTank(this.getMaxFuel());
        tank.setFluid(this.getContainedFluid());
        boolean bl = write = tank.getFluidAmount() > 0;
        if (!toItem || write) {
            nbt.m_128365_("tank", (Tag)tank.writeToNBT(new CompoundTag()));
        }
    }

    @Nonnull
    public InteractionResult m_6096_(Player player, @Nonnull InteractionHand hand) {
        Item tank;
        Item item;
        ItemStack stack = player.m_21120_(hand);
        if (stack != ItemStack.f_41583_ && (item = stack.m_41720_()) instanceof DebugItem) {
            DebugItem debugItem = (DebugItem)item;
            debugItem.onSpeedboatClick(this, player, stack);
            return InteractionResult.SUCCESS;
        }
        if (Utils.isFluidRelatedItemStack(stack)) {
            FluidStack fstack = FluidUtil.getFluidContained((ItemStack)stack).orElse(null);
            if (fstack != null && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)(tank = this.getInternalTank()))) {
                this.setContainedFluid(tank.getFluid());
                this.advancement((FluidTank)tank, fstack, player);
            }
            return InteractionResult.SUCCESS;
        }
        tank = stack.m_41720_();
        if (tank instanceof GasolineBottleItem) {
            FluidStack fstack;
            GasolineBottleItem gasbottle = (GasolineBottleItem)tank;
            tank = this.getInternalTank();
            if (tank.fill(fstack = new FluidStack(IPContent.Fluids.GASOLINE.get(), 250), IFluidHandler.FluidAction.SIMULATE) >= 250) {
                tank.fill(fstack, IFluidHandler.FluidAction.EXECUTE);
                gasbottle.toEmptyBottle(player, stack);
                this.setContainedFluid(tank.getFluid());
                this.advancement((FluidTank)tank, fstack, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().f_46443_ && !player.m_6144_() && this.f_38265_ < 60.0f && !player.m_20365_((Entity)this)) {
            player.m_20329_((Entity)this);
            if (this.m_9236_().m_46472_().equals((Object)Level.f_46429_) && this.isFireproof) {
                Utils.unlockIPAdvancement(player, "main/reinforced_hull");
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private FluidTank getInternalTank() {
        FluidTank tank = new FluidTank(this.getMaxFuel(), e -> FuelHandler.isValidBoatFuel(e.getFluid()));
        FluidStack fs = this.getContainedFluid();
        tank.setFluid(fs);
        return tank;
    }

    private void advancement(FluidTank tank, FluidStack fstack, Player player) {
        if (tank.isFluidValid(fstack)) {
            Utils.unlockIPAdvancement(player, "main/motorboat");
            if (this.hasTank && tank.getFluidAmount() == tank.getCapacity()) {
                Utils.unlockIPAdvancement(player, "main/tank");
            }
        }
    }

    public void m_38342_(boolean pLeftInputDown, boolean pRightInputDown, boolean pForwardInputDown, boolean pBackInputDown) {
        super.m_38342_(pLeftInputDown, pRightInputDown, pForwardInputDown, pBackInputDown);
        this.isBoosting = !this.isEmergency() && pForwardInputDown && Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
    }

    public boolean isSpinningFastEnough() {
        return this.fastEnough;
    }

    public void m_8119_() {
        List list;
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            float diff = this.m_146908_() - this.oYRot;
            this.fastEnough = diff <= -5.0f || diff >= 5.0f;
            this.oYRot = this.m_146908_();
            int current = (Integer)this.f_19804_.m_135370_(TANK_AMOUNT);
            int diff2 = current - this.oFuelAmount;
            if (diff2 != 0 && current == 0 && (entity = this.m_146895_()) instanceof Player) {
                Player player = (Player)entity;
                if (this.hasPaddles) {
                    Utils.unlockIPAdvancement(player, "main/paddles");
                }
            }
            this.oFuelAmount = current;
        }
        this.f_38280_ = this.f_38279_;
        this.f_38279_ = this.m_38392_();
        this.f_38265_ = this.f_38279_ != Boat.Status.UNDER_WATER && this.f_38279_ != Boat.Status.UNDER_FLOWING_WATER ? 0.0f : (this.f_38265_ += 1.0f);
        if (!this.m_9236_().f_46443_ && this.f_38265_ >= 60.0f) {
            this.m_20153_();
        }
        if (this.m_38385_() > 0) {
            this.m_38354_(this.m_38385_() - 1);
        }
        if (this.m_38384_() > 0.0f) {
            this.m_38311_(this.m_38384_() - 1.0f);
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.m_6075_();
        this.m_38391_();
        if (this.m_6109_()) {
            if (!(this.m_146895_() instanceof Player)) {
                this.m_38339_(false, false);
            }
            this.m_38395_();
            if (this.m_9236_().f_46443_) {
                this.m_38396_();
                this.m_9236_().m_5503_((Packet)new ServerboundPaddleBoatPacket(this.m_38313_(0), this.m_38313_(1)));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_38388_();
        if (this.m_9236_().f_46443_ && !this.isEmergency()) {
            float moving;
            float f = this.f_38275_ || this.f_38276_ ? (this.isBoosting ? 0.9f : 0.7f) : (moving = 0.5f);
            if (this.lastMoving != moving) {
                this.lastMoving = moving;
                ImmersivePetroleum.proxy.handleEntitySound((SoundEvent)IESounds.dieselGenerator.get(), (Entity)this, false, 0.5f, 0.5f);
            }
            ImmersivePetroleum.proxy.handleEntitySound((SoundEvent)IESounds.dieselGenerator.get(), (Entity)this, this.m_20160_() && this.getContainedFluid() != FluidStack.EMPTY && this.getContainedFluid().getAmount() > 0, this.f_38275_ || this.f_38276_ ? 0.5f : 0.3f, moving);
            if (this.f_38275_ && this.m_9236_().f_46441_.m_188503_(2) == 0) {
                if (this.m_20077_()) {
                    if (this.m_9236_().f_46441_.m_188503_(3) == 0) {
                        float xO = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                        float zO = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                        float yO = 0.4f + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                        Vec3 motion = this.m_20184_();
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() - (double)(xO * 1.5f), this.m_20186_() + (double)yO, this.m_20189_() - (double)(zO * 1.5f), -2.0 * motion.m_7096_(), 0.0, -2.0 * motion.m_7094_());
                    }
                } else {
                    float xO = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                    float zO = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                    float yO = 0.1f + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - (double)(xO * 1.5f), this.m_20186_() + (double)yO, this.m_20189_() - (double)(zO * 1.5f), 0.0, 0.0, 0.0);
                }
            }
            if (this.isBoosting && this.m_9236_().f_46441_.m_188503_(2) == 0) {
                float xO = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                float zO = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                float yO = 0.8f + (this.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.3f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() - (double)(xO * 1.3f), this.m_20186_() + (double)yO, this.m_20189_() - (double)(zO * 1.3f), 0.0, 0.0, 0.0);
            }
        }
        if (this.isEmergency()) {
            for (int i = 0; i <= 1; ++i) {
                if (this.m_38313_(i)) {
                    SoundEvent soundevent;
                    if (!this.m_20067_() && (double)(this.f_38263_[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.f_38263_[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundevent = this.m_38370_()) != null) {
                        Vec3 vec3 = this.m_20252_(1.0f);
                        double d0 = i == 1 ? -vec3.f_82481_ : vec3.f_82481_;
                        double d1 = i == 1 ? vec3.f_82479_ : -vec3.f_82479_;
                        this.m_9236_().m_6263_((Player)null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                        this.m_9236_().m_142346_((Entity)this.m_6688_(), GameEvent.f_157784_, BlockPos.m_274561_((double)(this.m_20185_() + d0), (double)this.m_20186_(), (double)(this.m_20189_() + d1)));
                    }
                    int n = i;
                    this.f_38263_[n] = this.f_38263_[n] + 0.3926991f;
                    continue;
                }
                this.f_38263_[i] = 0.0f;
            }
        } else if (this.m_38313_(0)) {
            this.f_38263_[0] = (float)((double)this.f_38263_[0] + (this.isBoosting ? 0.02 : 0.01));
        } else if (this.m_38313_(1)) {
            this.f_38263_[0] = (float)((double)this.f_38263_[0] - 0.01);
        }
        float xO = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180)));
        float zO = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        Vector3f vec = new Vector3f(xO, zO, 0.0f);
        vec.normalize();
        if (!this.m_9236_().f_46443_ && this.hasIcebreaker && !this.isEmergency()) {
            AABB bb = this.m_20191_().m_82400_(0.1);
            BlockPos.MutableBlockPos mutableBlockPos0 = new BlockPos.MutableBlockPos(bb.f_82288_ + 0.001, bb.f_82289_ + 0.001, bb.f_82290_ + 0.001);
            BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos(bb.f_82291_ - 0.001, bb.f_82292_ - 0.001, bb.f_82293_ - 0.001);
            BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
            if (this.m_9236_().m_46832_((BlockPos)mutableBlockPos0, (BlockPos)mutableBlockPos1)) {
                Entity j2;
                boolean brokeIce = false;
                for (int i = mutableBlockPos0.m_123341_(); i <= mutableBlockPos1.m_123341_(); ++i) {
                    for (int j2 = mutableBlockPos0.m_123342_(); j2 <= mutableBlockPos1.m_123342_(); ++j2) {
                        for (int k = mutableBlockPos0.m_123343_(); k <= mutableBlockPos1.m_123343_(); ++k) {
                            mutableBlockPos2.m_122178_(i, j2, k);
                            BlockState BlockState2 = this.m_9236_().m_8055_((BlockPos)mutableBlockPos2);
                            Vector3f vec2 = new Vector3f((float)((double)((float)i + 0.5f) - this.m_20185_()), (float)((double)((float)k + 0.5f) - this.m_20189_()), 0.0f);
                            vec2.normalize();
                            float sim = vec2.dot((Vector3fc)vec);
                            if (BlockState2.m_60734_() != Blocks.f_50126_ || !(sim > 0.3f)) continue;
                            this.m_9236_().m_46961_((BlockPos)mutableBlockPos2, false);
                            this.m_9236_().m_46597_((BlockPos)mutableBlockPos2, Blocks.f_49990_.m_49966_());
                            brokeIce = true;
                        }
                    }
                }
                if (brokeIce && (j2 = this.m_146895_()) instanceof Player) {
                    Player player = (Player)j2;
                    Utils.unlockIPAdvancement(player, "main/ice_breaker");
                }
            }
        }
        this.m_20101_();
        if (!this.m_9236_().f_46443_ && !(list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this))).isEmpty()) {
            boolean flag = !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                LivingEntity player;
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 2 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
                if (!this.hasIcebreaker || !(entity instanceof LivingEntity) || entity instanceof Player || !((player = this.m_6688_()) instanceof Player)) continue;
                Player player2 = (Player)player;
                Vector3f vec2 = new Vector3f((float)(entity.m_20185_() - this.m_20185_()), (float)(entity.m_20189_() - this.m_20189_()), 0.0f);
                vec2.normalize();
                float sim = vec2.dot((Vector3fc)vec);
                if (!(sim > 0.5f)) continue;
                Vec3 motion = entity.m_20184_();
                entity.m_6469_(this.m_9236_().m_269111_().m_269075_(player2), 4.0f);
                entity.m_20256_(new Vec3(motion.f_82479_ + (double)(vec2.x() * 0.75f), motion.f_82480_, motion.f_82481_ + (double)(vec2.y() * 0.75f)));
            }
        }
    }

    protected void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.isEmergency()) {
                if (this.f_38273_) {
                    this.f_38266_ -= 1.0f;
                }
                if (this.f_38274_) {
                    this.f_38266_ += 1.0f;
                }
                if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                    f += 0.005f;
                }
                this.m_146922_(this.m_146908_() + this.f_38266_);
                if (this.f_38275_) {
                    f += 0.04f;
                }
                if (this.f_38276_) {
                    f -= 0.005f;
                }
                double xa = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f;
                double za = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f;
                Vec3 motion = this.m_20184_().m_82520_(xa, 0.0, za);
                this.m_20256_(motion);
                this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
            } else {
                FluidStack fluid = this.getContainedFluid();
                int consumeAmount = 0;
                if (!fluid.isEmpty()) {
                    consumeAmount = FuelHandler.getBoatFuelUse(fluid.getFluid());
                }
                if (!fluid.isEmpty() && fluid.getAmount() >= consumeAmount && (this.f_38275_ || this.f_38276_)) {
                    int toConsume = consumeAmount;
                    if (this.f_38275_) {
                        f += 0.05f;
                        if (this.isBoosting && fluid.getAmount() >= 3 * consumeAmount) {
                            f = (float)((double)f * 1.6);
                            toConsume *= 3;
                        }
                    }
                    if (this.f_38276_) {
                        f -= 0.01f;
                    }
                    if (!fluid.isEmpty()) {
                        fluid.setAmount(Math.max(0, fluid.getAmount() - toConsume));
                    }
                    this.setContainedFluid(fluid);
                    IPPacketHandler.sendToServer(new MessageConsumeBoatFuel(toConsume));
                    this.m_38339_(this.f_38275_, this.f_38276_);
                } else {
                    this.m_38339_(false, false);
                }
                double xa = Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f;
                double za = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f;
                Vec3 motion = this.m_20184_().m_82520_(xa, 0.0, za);
                this.m_20256_(motion);
                if (this.f_38273_ || this.f_38274_) {
                    float speed = Mth.m_14116_((float)((float)(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
                    if (this.f_38274_) {
                        this.f_38266_ += 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.f_38276_ && !this.f_38275_ ? 2.0f : 1.0f);
                        this.propellerYRotation = Mth.m_14036_((float)(this.propellerYRotation - 0.2f), (float)-1.0f, (float)1.0f);
                    }
                    if (this.f_38273_) {
                        this.f_38266_ -= 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.f_38276_ && !this.f_38275_ ? 2.0f : 1.0f);
                        this.propellerYRotation = Mth.m_14036_((float)(this.propellerYRotation + 0.2f), (float)-1.0f, (float)1.0f);
                    }
                }
                if (!this.f_38273_ && !this.f_38274_ && this.propellerYRotation != 0.0f) {
                    this.propellerYRotation *= 0.7f;
                    if (this.propellerYRotation > -0.01f && this.propellerYRotation < 0.01f) {
                        this.propellerYRotation = 0.0f;
                    }
                }
                this.m_146922_(this.m_146908_() + this.f_38266_);
                this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
            }
        }
    }

    public int getMaxFuel() {
        return this.hasTank ? 16000 : 8000;
    }

    @Nonnull
    public Item m_38369_() {
        return (Item)IPContent.Items.SPEEDBOAT.get();
    }

    public boolean m_6060_() {
        if (this.isFireproof) {
            return false;
        }
        return super.m_6060_();
    }

    public boolean isEmergency() {
        FluidStack fluid = this.getContainedFluid();
        if (fluid != FluidStack.EMPTY) {
            int consumeAmount = FuelHandler.getBoatFuelUse(fluid.getFluid());
            return fluid.getAmount() < consumeAmount && this.hasPaddles;
        }
        return this.hasPaddles;
    }

    public NonNullList<ItemStack> getUpgrades() {
        NonNullList stackList = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        stackList.set(0, (Object)((ItemStack)this.f_19804_.m_135370_(UPGRADE_0)));
        stackList.set(1, (Object)((ItemStack)this.f_19804_.m_135370_(UPGRADE_1)));
        stackList.set(2, (Object)((ItemStack)this.f_19804_.m_135370_(UPGRADE_2)));
        stackList.set(3, (Object)((ItemStack)this.f_19804_.m_135370_(UPGRADE_3)));
        return stackList;
    }

    public String[] getOverlayText(Player player, HitResult mop) {
        if (Utils.isFluidRelatedItemStack(player.m_21120_(InteractionHand.MAIN_HAND))) {
            Object s = null;
            FluidStack stack = this.getContainedFluid();
            s = stack != FluidStack.EMPTY ? stack.getDisplayName().getString() + ": " + stack.getAmount() + "mB" : I18n.m_118938_((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public float m_38371_() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.f_38281_));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_) || this.isFireproof && fluidstate.m_205070_(FluidTags.f_13132_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos.m_123342_() + f;
        }
        return l + 1;
    }

    protected boolean m_38393_() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.f_38277_ = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) && (!this.isFireproof || !fluidstate.m_205070_(FluidTags.f_13132_))) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos);
                    this.f_38277_ = Math.max((double)f, this.f_38277_);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    protected Boat.Status m_38394_() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) && (!this.isFireproof || !fluidstate.m_205070_(FluidTags.f_13132_)) || !(d0 < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Boat.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Boat.Status.UNDER_WATER : null;
    }

    public boolean isLeftInDown() {
        return this.f_38273_;
    }

    public boolean isRightInDown() {
        return this.f_38274_;
    }

    public boolean isForwardInDown() {
        return this.f_38275_;
    }

    public boolean isBackInDown() {
        return this.f_38276_;
    }

    public boolean m_20291_(int flag) {
        return super.m_20291_(flag);
    }

    public void m_20115_(int flag, boolean set) {
        super.m_20115_(flag, set);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        String fluid = buffer.m_130277_();
        int amount = buffer.readInt();
        ItemStack stack0 = buffer.m_130267_();
        ItemStack stack1 = buffer.m_130267_();
        ItemStack stack2 = buffer.m_130267_();
        ItemStack stack3 = buffer.m_130267_();
        this.f_19804_.m_135381_(TANK_FLUID, (Object)fluid);
        this.f_19804_.m_135381_(TANK_AMOUNT, (Object)amount);
        this.f_19804_.m_135381_(UPGRADE_0, (Object)stack0);
        this.f_19804_.m_135381_(UPGRADE_1, (Object)stack1);
        this.f_19804_.m_135381_(UPGRADE_2, (Object)stack2);
        this.f_19804_.m_135381_(UPGRADE_3, (Object)stack3);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        String fluid = (String)this.f_19804_.m_135370_(TANK_FLUID);
        int amount = (Integer)this.f_19804_.m_135370_(TANK_AMOUNT);
        ItemStack stack0 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_0);
        ItemStack stack1 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_1);
        ItemStack stack2 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_2);
        ItemStack stack3 = (ItemStack)this.f_19804_.m_135370_(UPGRADE_3);
        buffer.m_130070_(fluid);
        buffer.writeInt(amount);
        buffer.m_130055_(stack0);
        buffer.m_130055_(stack1);
        buffer.m_130055_(stack2);
        buffer.m_130055_(stack3);
    }
}

