/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ReservoirSerializer
extends IERecipeSerializer<ReservoirType> {
    public ReservoirType readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        ArrayList<ResourceLocation> list;
        JsonArray array;
        boolean isBlacklist;
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        ResourceLocation fluid = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        int min = GsonHelper.m_13927_((JsonObject)json, (String)"fluidminimum");
        int max = GsonHelper.m_13927_((JsonObject)json, (String)"fluidcapacity");
        int trace = GsonHelper.m_13927_((JsonObject)json, (String)"fluidtrace");
        int equilibrium = GsonHelper.m_13824_((JsonObject)json, (String)"equilibrium", (int)0);
        int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
        ReservoirType reservoir = new ReservoirType(name, recipeId, fluid, min, max, trace, equilibrium, weight);
        ImmersivePetroleum.log.debug("Loaded reservoir {} as {}, with {}mB to {}mB of {} and {}mB trace at {}mB equilibrium, with {} of weight.", (Object)recipeId, (Object)name, (Object)min, (Object)max, (Object)fluid, (Object)trace, (Object)equilibrium, (Object)weight);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"dimensions")) {
            JsonObject dimensions = GsonHelper.m_13930_((JsonObject)json, (String)"dimensions");
            isBlacklist = GsonHelper.m_13912_((JsonObject)dimensions, (String)"isBlacklist");
            if (GsonHelper.m_13900_((JsonObject)dimensions, (String)"list")) {
                array = GsonHelper.m_13933_((JsonObject)dimensions, (String)"list");
                list = new ArrayList<ResourceLocation>();
                array.forEach(rl -> list.add(ResourceLocation.parse((String)rl.getAsString())));
                reservoir.setDimensions(isBlacklist, list);
            }
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"biomes")) {
            JsonObject biomes = GsonHelper.m_13930_((JsonObject)json, (String)"biomes");
            isBlacklist = GsonHelper.m_13912_((JsonObject)biomes, (String)"isBlacklist");
            if (GsonHelper.m_13900_((JsonObject)biomes, (String)"list")) {
                array = GsonHelper.m_13933_((JsonObject)biomes, (String)"list");
                list = new ArrayList();
                array.forEach(rl -> list.add(ResourceLocation.parse((String)rl.getAsString())));
                reservoir.setBiomes(isBlacklist, list);
            }
        }
        return reservoir;
    }

    public ReservoirType fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        return new ReservoirType(buffer.m_130260_());
    }

    public void toNetwork(FriendlyByteBuf buffer, ReservoirType recipe) {
        buffer.m_130079_(recipe.writeToNBT());
    }

    public ItemStack getIcon() {
        return ItemStack.f_41583_;
    }
}

