/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.builders.DistillationTowerRecipeBuilder;
import flaxbeard.immersivepetroleum.common.IPContent;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class HighPressureRefineryRecipeSerializer
extends IERecipeSerializer<HighPressureRefineryRecipe> {
    public HighPressureRefineryRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        FluidStack output = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        FluidTagInput inputFluid0 = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        FluidTagInput inputFluid1 = null;
        Tuple<ItemStack, Double> itemWithChance = new Tuple<ItemStack, Double>((Object)ItemStack.f_41583_, (Object)0.0);
        if (json.has("secondary_input")) {
            inputFluid1 = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"secondary_input"));
        }
        if (json.has("secondary_result")) {
            itemWithChance = DistillationTowerRecipeBuilder.deserializeItemStackWithChance(json.get("secondary_result").getAsJsonObject());
        }
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new HighPressureRefineryRecipe(recipeId, output, (ItemStack)itemWithChance.m_14418_(), inputFluid0, inputFluid1, (Double)itemWithChance.m_14419_(), energy, time);
    }

    public HighPressureRefineryRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
        ItemStack outputItem = buffer.m_130267_();
        double chance = buffer.readDouble();
        FluidStack output = buffer.readFluidStack();
        FluidTagInput inputFluid0 = FluidTagInput.read((FriendlyByteBuf)buffer);
        FluidTagInput inputFluid1 = null;
        boolean hasSecondary = buffer.readBoolean();
        if (hasSecondary) {
            inputFluid1 = FluidTagInput.read((FriendlyByteBuf)buffer);
        }
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new HighPressureRefineryRecipe(id, output, outputItem, inputFluid0, inputFluid1, chance, energy, time);
    }

    public void toNetwork(FriendlyByteBuf buffer, HighPressureRefineryRecipe recipe) {
        buffer.m_130055_(recipe.getOutputItem());
        buffer.writeDouble(recipe.getOutputItemChance());
        buffer.writeFluidStack(recipe.getOutputFluid());
        recipe.getPrimaryInputFluid().write(buffer);
        FluidTagInput secondaryInputFluid = recipe.getSecondaryInputFluid();
        boolean hasSecondary = secondaryInputFluid != null;
        buffer.writeBoolean(hasSecondary);
        if (hasSecondary) {
            secondaryInputFluid.write(buffer);
        }
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IPContent.Multiblock.HYDROTREATER.iconStack().m_41720_());
    }
}

