/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.api.crafting.builders.DistillationTowerRecipeBuilder;
import flaxbeard.immersivepetroleum.common.IPContent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class DistillationTowerRecipeSerializer
extends IERecipeSerializer<DistillationTowerRecipe> {
    public DistillationTowerRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        JsonArray fluidResults = GsonHelper.m_13933_((JsonObject)json, (String)"results");
        FluidStack[] fluidOutput = new FluidStack[fluidResults.size()];
        for (int i = 0; i < fluidOutput.length; ++i) {
            fluidOutput[i] = ApiUtils.jsonDeserializeFluidStack((JsonObject)fluidResults.get(i).getAsJsonObject());
        }
        ItemStack[] array0 = new ItemStack[]{};
        double[] array1 = new double[]{};
        if (json.has("byproducts")) {
            int i;
            JsonArray itemResults = GsonHelper.m_13933_((JsonObject)json, (String)"byproducts");
            ArrayList<ItemStack> byproducts = new ArrayList<ItemStack>(0);
            ArrayList<Double> chances = new ArrayList<Double>(0);
            for (i = 0; i < itemResults.size(); ++i) {
                Tuple<ItemStack, Double> chancedStack = DistillationTowerRecipeBuilder.deserializeItemStackWithChance(itemResults.get(i).getAsJsonObject());
                byproducts.add((ItemStack)chancedStack.m_14418_());
                chances.add((Double)chancedStack.m_14419_());
            }
            if (byproducts.size() != chances.size()) {
                int d;
                throw new JsonSyntaxException(d + " byproduct" + ((d = Math.abs(chances.size() - byproducts.size())) > 1 ? "s have" : " has") + " a missing value or too many.");
            }
            array0 = byproducts.toArray(new ItemStack[0]);
            array1 = new double[chances.size()];
            for (i = 0; i < chances.size(); ++i) {
                array1[i] = (Double)chances.get(i);
            }
        }
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new DistillationTowerRecipe(recipeId, fluidOutput, array0, input, energy, time, array1);
    }

    public DistillationTowerRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        FluidStack[] fluidOutput = new FluidStack[buffer.readInt()];
        for (int i = 0; i < fluidOutput.length; ++i) {
            fluidOutput[i] = buffer.readFluidStack();
        }
        ItemStack[] byproducts = new ItemStack[buffer.readInt()];
        for (int i = 0; i < byproducts.length; ++i) {
            byproducts[i] = buffer.m_130267_();
        }
        double[] chances = new double[buffer.readInt()];
        for (int i = 0; i < chances.length; ++i) {
            chances[i] = buffer.readDouble();
        }
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new DistillationTowerRecipe(recipeId, fluidOutput, byproducts, input, energy, time, chances);
    }

    public void toNetwork(FriendlyByteBuf buffer, DistillationTowerRecipe recipe) {
        buffer.writeInt(recipe.getFluidOutputs().size());
        for (FluidStack stack : recipe.getFluidOutputs()) {
            buffer.writeFluidStack(stack);
        }
        buffer.writeInt(recipe.getItemOutputs().size());
        for (FluidStack stack : recipe.getItemOutputs()) {
            buffer.m_130055_((ItemStack)stack);
        }
        buffer.writeInt(recipe.chances().length);
        for (Object d : (Object)recipe.chances()) {
            buffer.writeDouble((double)d);
        }
        recipe.getInputFluid().write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IPContent.Multiblock.DISTILLATIONTOWER.iconStack().m_41720_());
    }
}

