/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.IPContent;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class CokerUnitRecipeSerializer
extends IERecipeSerializer<CokerUnitRecipe> {
    public CokerUnitRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        FluidStack outputFluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"resultfluid"));
        FluidTagInput inputFluid = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"inputfluid"));
        Lazy outputItem = CokerUnitRecipeSerializer.readOutput((JsonElement)json.get("result"));
        IngredientWithSize inputItem = IngredientWithSize.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        return new CokerUnitRecipe(recipeId, (Lazy<ItemStack>)outputItem, outputFluid, inputItem, inputFluid, energy, time);
    }

    public CokerUnitRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        IngredientWithSize inputItem = IngredientWithSize.read((FriendlyByteBuf)buffer);
        ItemStack outputItem = buffer.m_130267_();
        FluidTagInput inputFluid = FluidTagInput.read((FriendlyByteBuf)buffer);
        FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        int time = buffer.readInt();
        return new CokerUnitRecipe(recipeId, (Lazy<ItemStack>)Lazy.of(() -> outputItem), outputFluid, inputItem, inputFluid, energy, time);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, CokerUnitRecipe recipe) {
        recipe.getInputItem().write(buffer);
        buffer.m_130055_(recipe.getOutputItem());
        recipe.getInputFluid().write(buffer);
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.getTotalProcessTime());
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IPContent.Multiblock.COKERUNIT.iconStack().m_41720_());
    }
}

