/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IBlockEntityDrop;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlacementReader;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlayerInteraction;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.wooden.AutoLubricatorBlock;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AutoLubricatorTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile,
IPlacementReader,
IPlayerInteraction,
IBlockEntityDrop,
IEBlockInterfaces.IBlockOverlayText {
    public boolean isSlave;
    public Direction facing = Direction.NORTH;
    public FluidTank tank = new FluidTank(8000, fluid -> fluid != null && LubricantHandler.isValidLube(fluid.getFluid()));
    private LazyOptional<IFluidHandler> outputHandler;
    int count = 0;
    int countClient = 0;
    int lastTank = 0;

    public AutoLubricatorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.AUTOLUBE.get(), pWorldPosition, pBlockState);
    }

    public AutoLubricatorTileEntity master() {
        AutoLubricatorTileEntity autolube;
        if (!this.isSlave) {
            return this;
        }
        BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_7495_());
        return te instanceof AutoLubricatorTileEntity ? (autolube = (AutoLubricatorTileEntity)te) : null;
    }

    @Override
    protected void readCustom(CompoundTag compound) {
        this.isSlave = compound.m_128471_("slave");
        Direction facing = Direction.m_122402_((String)compound.m_128461_("facing"));
        this.facing = facing.m_122416_() == -1 ? Direction.NORTH : facing;
        this.tank.readFromNBT(compound.m_128469_("tank"));
    }

    @Override
    protected void writeCustom(CompoundTag compound) {
        compound.m_128379_("slave", this.isSlave);
        compound.m_128359_("facing", this.facing.m_122433_());
        compound.m_128405_("count", this.count);
        CompoundTag tank = this.tank.writeToNBT(new CompoundTag());
        compound.m_128365_("tank", (Tag)tank);
    }

    public void readTank(CompoundTag nbt) {
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    public void writeTank(CompoundTag nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        if (!toItem || write) {
            nbt.m_128365_("tank", (Tag)tankTag);
        }
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.readTank(stack.m_41783_());
        }
        if (placer instanceof Player) {
            IMultiblockBE me;
            LubricatedHandler.ILubricationHandler<?, ?> handler;
            Player player = (Player)placer;
            BlockPos target = this.f_58858_.m_121945_(this.facing);
            BlockEntity te = this.f_58857_.m_7702_(target);
            if (te instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((me = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.f_58857_, this.m_58899_(), this.facing)) {
                Utils.unlockIPAdvancement(player, "main/auto_lubricator");
            }
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (((Boolean)state.m_61143_((Property)AutoLubricatorBlock.SLAVE)).booleanValue()) {
            return List.of(ItemStack.f_41583_);
        }
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        BlockEntity te = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (te instanceof AutoLubricatorTileEntity) {
            AutoLubricatorTileEntity autolube = (AutoLubricatorTileEntity)te;
            CompoundTag tag = new CompoundTag();
            autolube.writeTank(tag, true);
            if (!tag.m_128456_()) {
                stack.m_41751_(tag);
            }
        }
        return List.of(stack);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.isSlave && (side == null || side == Direction.UP)) {
            AutoLubricatorTileEntity master = this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (this.outputHandler == null) {
                this.outputHandler = LazyOptional.of(() -> master.tank);
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.outputHandler != null) {
            this.outputHandler.invalidate();
        }
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.outputHandler != null) {
            this.outputHandler.invalidate();
        }
    }

    public Direction getFacing() {
        return this.facing;
    }

    public boolean isMaster() {
        return !this.isSlave;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-3, -3, -3), pos.m_7918_(3, 3, 3));
    }

    public Component[] getOverlayText(Player player, @Nonnull HitResult mop, boolean hammer) {
        AutoLubricatorTileEntity master;
        if (Utils.isFluidRelatedItemStack(player.m_21120_(InteractionHand.MAIN_HAND)) && (master = this.master()) != null) {
            MutableComponent s = switch (master.tank.isEmpty() ? 0 : 1) {
                case 0 -> Component.m_237115_((String)"gui.immersiveengineering.empty");
                case 1 -> ((MutableComponent)master.tank.getFluid().getDisplayName()).m_130946_(": " + master.tank.getFluidAmount() + "mB");
                default -> null;
            };
            return new Component[]{s};
        }
        return null;
    }

    public boolean useNixieFont(@Nonnull Player player, @Nonnull HitResult mop) {
        return false;
    }

    @Override
    public InteractionResult interact(@Nonnull Direction side, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        AutoLubricatorTileEntity master = this.master();
        if (master != null) {
            if (!this.f_58857_.f_46443_ && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)master.tank)) {
                this.m_6596_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void tickClient() {
        IMultiblockBEHelperMaster<?> masterHelper;
        IMultiblockBE mb;
        LubricatedHandler.ILubricationHandler<?, ?> handler;
        BlockPos target;
        BlockEntity te;
        if (this.isSlave) {
            return;
        }
        if (!this.tank.isEmpty() && LubricantHandler.isValidLube(this.tank.getFluid()) && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid()) && (te = this.f_58857_.m_7702_(target = this.f_58858_.m_121945_(this.facing))) instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((mb = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.f_58857_, this.m_58899_(), this.facing) && handler.isMachineEnabled(this.f_58857_, masterHelper = Utils.getMultiblockMasterHelper(this.f_58857_, mb.getHelper()))) {
            handler.lubricateClient((ClientLevel)this.f_58857_, this.tank.getFluid().getFluid(), this.count, masterHelper);
            if (this.countClient++ % 50 == 0) {
                this.countClient = this.f_58857_.f_46441_.m_188503_(40);
                handler.spawnLubricantParticles((ClientLevel)this.f_58857_, this.m_58899_(), this.facing, masterHelper);
            }
        }
    }

    @Override
    public void tickServer() {
        IMultiblockBEHelperMaster<?> masterHelper;
        IMultiblockBE mb;
        LubricatedHandler.ILubricationHandler<?, ?> handler;
        BlockPos target;
        BlockEntity te;
        if (this.isSlave) {
            return;
        }
        if (!this.tank.isEmpty() && LubricantHandler.isValidLube(this.tank.getFluid()) && this.tank.getFluidAmount() >= LubricantHandler.getLubeAmount(this.tank.getFluid()) && (te = this.f_58857_.m_7702_(target = this.f_58858_.m_121945_(this.facing))) instanceof IMultiblockBE && (handler = LubricatedHandler.getHandlerForTile((mb = (IMultiblockBE)te).getHelper())) != null && handler.isPlacedCorrectly(this.f_58857_, this.m_58899_(), this.facing) && (masterHelper = Utils.getMultiblockMasterHelper(this.f_58857_, mb.getHelper())) != null && handler.isMachineEnabled(this.f_58857_, masterHelper)) {
            handler.lubricateServer((ServerLevel)this.f_58857_, this.tank.getFluid().getFluid(), this.count, masterHelper);
            if (this.count++ % 4 == 0) {
                this.tank.drain(LubricantHandler.getLubeAmount(this.tank.getFluid()), IFluidHandler.FluidAction.EXECUTE);
            }
            this.m_6596_();
        }
        if (!this.f_58857_.f_46443_ && this.lastTank != this.tank.getFluidAmount()) {
            this.lastTank = this.tank.getFluidAmount();
            this.m_6596_();
        }
    }
}

