/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.stone;

import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.ForgeHooks;

public class WellPipeBlock
extends IPBlockBase
implements EntityBlock {
    public static final BooleanProperty BROKEN = BooleanProperty.m_61465_((String)"broken");

    public WellPipeBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283819_).m_60913_(75.0f, 10.0f).m_60918_(SoundType.f_56742_).m_60999_().m_222994_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BROKEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BROKEN});
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
    }

    public float m_5880_(BlockState state, @Nonnull Player player, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        float f = state.m_60800_(worldIn, pos);
        if (((Boolean)state.m_61143_((Property)BROKEN)).booleanValue()) {
            f /= 5.0f;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public void m_6810_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
            this.removed(state, world, pos);
            world.m_46747_(pos);
        }
    }

    private void removed(BlockState state, Level world, BlockPos pos) {
        if (world.f_46443_ || ((Boolean)state.m_61143_((Property)BROKEN)).booleanValue()) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof WellPipeTileEntity) {
            WellTileEntity well = null;
            for (int y = pos.m_123342_() - 1; y >= world.m_141937_(); --y) {
                WellTileEntity w;
                BlockEntity teLow = world.m_7702_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()));
                if (!(teLow instanceof WellTileEntity)) continue;
                well = w = (WellTileEntity)teLow;
                break;
            }
            if (well != null && !well.pastPhysicalPart) {
                well.phyiscalPipesList.remove((Object)pos.m_123342_());
                if (well.wellPipeLength > 0) {
                    --well.wellPipeLength;
                }
                well.m_6596_();
            }
        }
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return ((BlockEntityType)IPTileTypes.WELL_PIPE.get()).m_155264_(pPos, pState);
    }
}

