/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.IReadWriteNBT;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater.HydroTreaterProcess;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.HydroTreaterShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HydroTreaterLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_INPUT_A = 0;
    public static final int TANK_INPUT_B = 1;
    public static final int TANK_OUTPUT = 2;
    public static final CapabilityPosition Fluid_IN_A = new CapabilityPosition(1, 0, 3, RelativeBlockFace.BACK);
    public static final CapabilityPosition Fluid_IN_B = new CapabilityPosition(2, 2, 1, RelativeBlockFace.UP);
    public static final MultiblockFace FLUID_OUT = new MultiblockFace(0, 1, 2, RelativeBlockFace.UP);
    public static final CapabilityPosition Fluid_OUT = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 2);
    public static final CapabilityPosition Energy_IN = new CapabilityPosition(2, 2, 3, RelativeBlockFace.UP);
    public static final BlockPos Redstone_IN = new BlockPos(0, 1, 3);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
    }

    public void tickServer(IMultiblockContext<State> context) {
        HighPressureRefineryRecipe recipe;
        boolean update = false;
        State state = (State)context.getState();
        Level level = context.getLevel().getRawLevel();
        if (!(!state.rsState.isEnabled(context) || state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize() || state.tanks.primary().getFluidAmount() <= 0 && state.tanks.secondary().getFluidAmount() <= 0 || (recipe = HighPressureRefineryRecipe.findRecipe(state.tanks.primary().getFluid(), state.tanks.secondary().getFluid())) == null || state.energy.getEnergyStored() < recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime() || state.tanks.primary().getFluidAmount() < recipe.getPrimaryInputFluid().getAmount() || recipe.getSecondaryInputFluid() != null && state.tanks.secondary().getFluidAmount() < recipe.getSecondaryInputFluid().getAmount())) {
            int[] inputAmounts;
            int[] inputs;
            if (recipe.getSecondaryInputFluid() != null) {
                inputs = new int[]{0, 1};
                inputAmounts = new int[]{recipe.getPrimaryInputFluid().getAmount(), recipe.getSecondaryInputFluid().getAmount()};
            } else {
                inputs = new int[]{0};
                inputAmounts = new int[]{recipe.getPrimaryInputFluid().getAmount()};
            }
            MultiblockProcessInMachine process = new HydroTreaterProcess(recipe, new int[0]).setInputTanks(inputs).setInputAmounts(inputAmounts);
            if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
                state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                update = true;
            }
        }
        if (!state.processor.getQueue().isEmpty()) {
            update = true;
            state.processor.tickServer((ProcessContext)state, context.getLevel(), true);
        }
        if (state.tanks.output().getFluidAmount() > 0) {
            BlockPos outPos = context.getLevel().toAbsolute(Fluid_OUT.posInMultiblock()).m_7494_();
            update |= FluidUtil.getFluidHandler((Level)level, (BlockPos)outPos, (Direction)Direction.DOWN).map(output -> {
                boolean ret = false;
                FluidStack target = state.tanks.output().getFluid();
                int accepted = output.fill(target = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 1000)), IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    int drained = output.fill(FluidHelper.copyFluid(target, Math.min(target.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    state.tanks.output().drain(new FluidStack(target.getFluid(), drained), IFluidHandler.FluidAction.EXECUTE);
                    ret = true;
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            context.markDirtyAndSync();
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ENERGY) {
            if (position.equalsOrNullFace(Energy_IN)) {
                return state.energyCap.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equalsOrNullFace(Fluid_IN_A)) {
                return state.fluidInputMain.cast(ctx);
            }
            if (position.equalsOrNullFace(Fluid_IN_B)) {
                return state.fluidInputSecondary.cast(ctx);
            }
            if (position.equalsOrNullFace(Fluid_OUT)) {
                return state.fluidOutput.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    public static HighPressureRefineryRecipe getRecipeForId(Level level, ResourceLocation id) {
        return HighPressureRefineryRecipe.recipes.get(id);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return HydroTreaterShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<HighPressureRefineryRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(8000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final Tanks tanks = new Tanks();
        public final MultiblockProcessor.InMachineProcessor<HighPressureRefineryRecipe> processor;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability((Object)this.energy);
        private final StoredCapability<IFluidHandler> fluidInputMain;
        private final StoredCapability<IFluidHandler> fluidInputSecondary;
        private final StoredCapability<IFluidHandler> fluidOutput;
        private final CapabilityReference<IFluidHandler> outputRef;

        public State(IInitialMultiblockContext<State> context) {
            this.processor = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), HydroTreaterLogic::getRecipeForId);
            this.outputRef = context.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUT);
            this.fluidInputMain = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.primary(), (Runnable)context.getMarkDirtyRunnable()));
            this.fluidInputSecondary = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.secondary(), (Runnable)context.getMarkDirtyRunnable()));
            this.fluidOutput = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output(), (Runnable)context.getMarkDirtyRunnable()));
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", (Tag)this.tanks.writeNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            this.rsState.writeSaveNBT(nbt);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.energy.deserializeNBT((Tag)nbt.m_128469_("energy"));
            this.processor.fromNBT(nbt.m_128423_("processor"), HydroTreaterProcess::new);
            this.rsState.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IFluidTank[] getInternalTanks() {
            return this.tanks.asArray();
        }

        public int[] getOutputTanks() {
            return new int[]{2};
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<HighPressureRefineryRecipe, ?> process, Level level) {
            int outputAmount = 0;
            for (FluidStack outputFluid : ((HighPressureRefineryRecipe)process.getRecipe(level)).getFluidOutputs()) {
                outputAmount += outputFluid.getAmount();
            }
            return this.tanks.output().getCapacity() >= this.tanks.output().getFluidAmount() + outputAmount;
        }
    }

    public record Tanks(FluidTank primary, FluidTank secondary, FluidTank output) implements IReadWriteNBT
    {
        public Tanks() {
            this(new FluidTank(12000, fluidStack -> HighPressureRefineryRecipe.hasRecipeWithInput(fluidStack, true)), new FluidTank(12000, fluidStack -> HighPressureRefineryRecipe.hasRecipeWithSecondaryInput(fluidStack, true)), new FluidTank(12000));
        }

        public IFluidTank[] asArray() {
            return new IFluidTank[]{this.primary(), this.secondary(), this.output()};
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            this.primary.readFromNBT(nbt.m_128469_("primary"));
            this.secondary.readFromNBT(nbt.m_128469_("secondary"));
            this.output.readFromNBT(nbt.m_128469_("output"));
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("primary", (Tag)this.primary.writeToNBT(new CompoundTag()));
            nbt.m_128365_("secondary", (Tag)this.secondary.writeToNBT(new CompoundTag()));
            nbt.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return nbt;
        }
    }
}

