/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.IReadWriteNBT;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower.DistillationTowerProcess;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.DistillationTowerShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.inventory.MultiFluidTankFiltered;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DistillationTowerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int INV_0 = 0;
    public static final int INV_1 = 1;
    public static final int INV_2 = 2;
    public static final int INV_3 = 3;
    public static final CapabilityPosition Fluid_IN = new CapabilityPosition(3, 0, 3, RelativeBlockFace.LEFT);
    public static final CapabilityPosition Fluid_OUT = new CapabilityPosition(1, 0, 3, RelativeBlockFace.BACK);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 1);
    public static final CapabilityPosition ENERGY_IN = new CapabilityPosition(3, 1, 3, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 3);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
    }

    public void tickServer(IMultiblockContext<State> context) {
        ItemStack emptyContainer;
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean update = false;
        if (state.wasActive && state.cooldownTicks == 0) {
            state.wasActive = false;
            update = true;
        }
        if (state.cooldownTicks > 0) {
            --state.cooldownTicks;
        }
        if (rsEnabled) {
            MultiblockProcessInMachine process;
            DistillationTowerRecipe recipe;
            if (state.energy.getEnergyStored() > 0 && state.processor.getQueueSize() < state.processor.getMaxQueueSize() && state.tanks.input().getFluidAmount() > 0 && (recipe = DistillationTowerRecipe.findRecipe(state.tanks.input().getFluid())) != null && state.tanks.input().getFluidAmount() >= recipe.getInputFluid().getAmount() && state.energy.getEnergyStored() >= recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime() && state.processor.addProcessToQueue((MultiblockProcess)(process = new DistillationTowerProcess(recipe, new int[0]).setInputTanks(new int[]{0})), level.getRawLevel(), true)) {
                state.processor.addProcessToQueue((MultiblockProcess)process, level.getRawLevel(), false);
                update = true;
            }
            if (!state.processor.getQueue().isEmpty()) {
                state.wasActive = true;
                state.cooldownTicks = 10;
                update = true;
            }
            state.processor.tickServer((ProcessContext)state, level, state.wasActive);
        }
        if (state.inventory.get(0) != ItemStack.f_41583_ && state.tanks.input().getFluidAmount() < state.tanks.input().getCapacity() && !(emptyContainer = Utils.drainFluidContainer((IFluidHandler)state.tanks.input(), (ItemStack)((ItemStack)state.inventory.get(0)), (ItemStack)((ItemStack)state.inventory.get(1)))).m_41619_()) {
            if (!((ItemStack)state.inventory.get(1)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)state.inventory.get(1)), (ItemStack)emptyContainer)) {
                ((ItemStack)state.inventory.get(1)).m_41769_(emptyContainer.m_41613_());
            } else if (((ItemStack)state.inventory.get(1)).m_41619_()) {
                state.inventory.set(1, (Object)emptyContainer.m_41777_());
            }
            ((ItemStack)state.inventory.get(0)).m_41774_(1);
            if (((ItemStack)state.inventory.get(0)).m_41613_() <= 0) {
                state.inventory.set(0, (Object)ItemStack.f_41583_);
            }
            update = true;
        }
        if (state.tanks.output().getFluidAmount() > 0) {
            if (state.inventory.get(2) != ItemStack.f_41583_ && state.tanks.output().getFluidTypes() > 0) {
                MultiFluidTankFiltered outTank = state.tanks.output();
                for (int i = outTank.getFluidTypes() - 1; i >= 0; --i) {
                    ItemStack filledContainer;
                    FluidStack fs = outTank.getFluidInTank(i);
                    if (fs.getAmount() <= 0 || (filledContainer = FluidHelper.fillFluidContainer((IFluidTank)outTank, fs, (ItemStack)state.inventory.get(2), (ItemStack)state.inventory.get(3))).m_41619_()) continue;
                    if (((ItemStack)state.inventory.get(3)).m_41613_() == 1 && !FluidHelper.isFluidContainerFull(filledContainer)) {
                        state.inventory.set(3, (Object)filledContainer.m_41777_());
                    } else {
                        if (!((ItemStack)state.inventory.get(3)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)state.inventory.get(3)), (ItemStack)filledContainer)) {
                            ((ItemStack)state.inventory.get(3)).m_41769_(filledContainer.m_41613_());
                        } else if (((ItemStack)state.inventory.get(3)).m_41619_()) {
                            state.inventory.set(3, (Object)filledContainer.m_41777_());
                        }
                        ((ItemStack)state.inventory.get(2)).m_41774_(1);
                        if (((ItemStack)state.inventory.get(2)).m_41613_() <= 0) {
                            state.inventory.set(2, (Object)ItemStack.f_41583_);
                        }
                    }
                    update = true;
                    break;
                }
            }
            MultiblockOrientation orientation = level.getOrientation();
            BlockPos outPos = level.toAbsolute(Fluid_OUT.posInMultiblock()).m_121945_(orientation.front().m_122424_());
            update |= FluidUtil.getFluidHandler((Level)level.getRawLevel(), (BlockPos)outPos, (Direction)orientation.front()).map(output -> {
                boolean ret = false;
                if (!state.tanks.input().fluids.isEmpty()) {
                    ArrayList<FluidStack> toDrain = new ArrayList<FluidStack>();
                    boolean iePipe = level.getRawLevel().m_7702_(outPos) instanceof IFluidPipe;
                    for (FluidStack target : state.tanks.output().fluids) {
                        FluidStack outStack = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 100), iePipe);
                        int accepted = output.fill(outStack, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) continue;
                        int drained = output.fill(FluidHelper.copyFluid(outStack, Math.min(outStack.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                        toDrain.add(new FluidStack(target.getFluid(), drained));
                        ret = true;
                    }
                    toDrain.forEach(fluid -> state.tanks.output().drain((FluidStack)fluid, IFluidHandler.FluidAction.EXECUTE));
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            context.markDirtyAndSync();
        }
    }

    public static DistillationTowerRecipe getRecipeForId(Level level, ResourceLocation id) {
        return DistillationTowerRecipe.recipes.get(id);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equalsOrNullFace(Fluid_IN)) {
                return state.fluidInput.cast(ctx);
            }
            if (position.equalsOrNullFace(Fluid_OUT)) {
                return state.fluidOutput.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.ENERGY && position.equalsOrNullFace(ENERGY_IN)) {
            return state.energyHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return DistillationTowerShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<DistillationTowerRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final MultiblockProcessor.InMachineProcessor<DistillationTowerRecipe> processor;
        public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        public final Tanks tanks = new Tanks();
        public int cooldownTicks = 0;
        public boolean wasActive = false;
        private final StoredCapability<IEnergyStorage> energyHandler = new StoredCapability((Object)this.energy);
        private final StoredCapability<IFluidHandler> fluidInput;
        private final StoredCapability<IFluidHandler> fluidOutput;

        public State(IInitialMultiblockContext<State> context) {
            this.processor = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), DistillationTowerLogic::getRecipeForId);
            this.fluidInput = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.input(), (Runnable)context.getMarkDirtyRunnable()));
            this.fluidOutput = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output(), (Runnable)context.getMarkDirtyRunnable()));
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public MultiFluidTankFiltered[] getInternalTanks() {
            return this.tanks.asArray();
        }

        public int[] getOutputTanks() {
            return new int[]{1};
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<DistillationTowerRecipe, ?> process, Level level) {
            int outputAmount = 0;
            for (FluidStack outputFluid : ((DistillationTowerRecipe)process.getRecipe(level)).getFluidOutputs()) {
                outputAmount += outputFluid.getAmount();
            }
            return this.tanks.output().getCapacity() >= this.tanks.output().getFluidAmount() + outputAmount;
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.energy.deserializeNBT((Tag)nbt.m_128469_("energy"));
            this.cooldownTicks = nbt.m_128451_("cooldownTicks");
            this.processor.fromNBT((Tag)nbt.m_128469_("recipeworker"), DistillationTowerProcess::new);
            this.inventory = this.readInventory(nbt.m_128469_("inventory"));
            this.rsState.readSaveNBT(nbt);
            this.wasActive = nbt.m_128471_("wasActive");
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tanks", (Tag)this.tanks.writeNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128405_("cooldownTicks", this.cooldownTicks);
            nbt.m_128365_("recipeworker", this.processor.toNBT());
            nbt.m_128365_("inventory", (Tag)this.writeInventory(this.inventory));
            this.rsState.writeSaveNBT(nbt);
            nbt.m_128379_("wasActive", this.wasActive);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        protected NonNullList<ItemStack> readInventory(CompoundTag nbt) {
            NonNullList list = NonNullList.m_122779_();
            ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)list);
            if (list.isEmpty()) {
                list = this.inventory.size() == 4 ? this.inventory : NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            } else if (list.size() < 4) {
                while (list.size() < 4) {
                    list.add((Object)ItemStack.f_41583_);
                }
            }
            return list;
        }

        protected CompoundTag writeInventory(NonNullList<ItemStack> list) {
            return ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), list);
        }
    }

    public record Tanks(MultiFluidTankFiltered input, MultiFluidTankFiltered output) implements IReadWriteNBT
    {
        public static final int CAPACITY = 24000;

        public Tanks() {
            this(new MultiFluidTankFiltered(24000, fs -> DistillationTowerRecipe.findRecipe(fs) != null), new MultiFluidTankFiltered(24000));
        }

        public MultiFluidTankFiltered[] asArray() {
            return new MultiFluidTankFiltered[]{this.input, this.output};
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            this.input.readFromNBT(nbt.m_128469_("input"));
            this.output.readFromNBT(nbt.m_128469_("output"));
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            nbt.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return nbt;
        }
    }
}

