/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokerUnitLogic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CokingChamber {
    @Nullable
    CokerUnitRecipe recipe = null;
    State state = State.STANDBY;
    FluidTank tank;
    int capacity;
    int inputAmount = 0;
    int outputAmount = 0;
    int timer = 0;

    public CokingChamber(int itemCapacity, int fluidCapacity) {
        this.capacity = itemCapacity;
        this.tank = new FluidTank(fluidCapacity);
    }

    public CokingChamber readFromNBT(CompoundTag nbt) {
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.timer = nbt.m_128451_("timer");
        this.inputAmount = nbt.m_128451_("input");
        this.outputAmount = nbt.m_128451_("output");
        this.state = State.values()[nbt.m_128451_("state")];
        if (nbt.m_128425_("recipe", 8)) {
            try {
                this.recipe = CokerUnitRecipe.recipes.get(ResourceLocation.parse((String)nbt.m_128461_("recipe")));
            }
            catch (ResourceLocationException e) {
                ImmersivePetroleum.log.error("Tried to load a coking recipe with an invalid name", (Throwable)e);
            }
        } else {
            this.recipe = null;
        }
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("timer", this.timer);
        nbt.m_128405_("input", this.inputAmount);
        nbt.m_128405_("output", this.outputAmount);
        nbt.m_128405_("state", this.state.id());
        if (this.recipe != null) {
            nbt.m_128359_("recipe", this.recipe.m_6423_().toString());
        }
        return nbt;
    }

    public boolean setRecipe(@Nullable CokerUnitRecipe recipe) {
        if (this.state == State.STANDBY) {
            this.recipe = recipe;
            return true;
        }
        return false;
    }

    public int addStack(@Nonnull ItemStack stack, boolean simulate) {
        if (this.recipe != null && !stack.m_41619_() && this.recipe.getInputItem().test(stack)) {
            int capacity = this.getCapacity() * this.recipe.getInputItem().getCount();
            int current = this.getTotalAmount() * this.recipe.getInputItem().getCount();
            if (simulate) {
                return Math.min(capacity - current, stack.m_41613_());
            }
            int filled = capacity - current;
            if (stack.m_41613_() < filled) {
                filled = stack.m_41613_();
            }
            ++this.inputAmount;
            return filled;
        }
        return 0;
    }

    public State getState() {
        return this.state;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getInputAmount() {
        return this.inputAmount;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getTotalAmount() {
        return this.inputAmount + this.outputAmount;
    }

    public int getTimer() {
        return this.timer;
    }

    private boolean setStage(State state) {
        if (this.state != state) {
            this.state = state;
            return true;
        }
        return false;
    }

    @Nullable
    public CokerUnitRecipe getRecipe() {
        return this.recipe;
    }

    public ItemStack getInputItem() {
        if (this.recipe == null) {
            return ItemStack.f_41583_;
        }
        return this.recipe.getInputItem().getMatchingStacks()[0];
    }

    public ItemStack getOutputItem() {
        if (this.recipe == null) {
            return ItemStack.f_41583_;
        }
        return this.recipe.getOutputItem();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean tick(IMultiblockContext<CokerUnitLogic.State> context, int chamberId) {
        if (this.recipe == null) {
            return this.setStage(State.STANDBY);
        }
        CokerUnitLogic.State logicState = (CokerUnitLogic.State)context.getState();
        switch (this.state) {
            case STANDBY: {
                if (this.recipe == null) break;
                return this.setStage(State.PROCESSING);
            }
            case PROCESSING: {
                if (this.inputAmount <= 0 || this.getInputItem().m_41619_() || this.tank.getCapacity() - this.tank.getFluidAmount() < this.recipe.getOutputFluid().getAmount() || logicState.energy.getEnergyStored() < this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime()) break;
                logicState.energy.extractEnergy(this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime(), false);
                ++this.timer;
                if (this.timer >= this.recipe.getTotalProcessTime() * this.recipe.getInputItem().getCount()) {
                    this.timer = 0;
                    this.tank.fill(Utils.copyFluidStackWithAmount((FluidStack)this.recipe.getOutputFluid(), (int)this.recipe.getOutputFluid().getAmount(), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                    --this.inputAmount;
                    ++this.outputAmount;
                    if (this.inputAmount <= 0) {
                        this.setStage(State.DRAIN_RESIDUE);
                    }
                }
                return true;
            }
            case DRAIN_RESIDUE: {
                if (this.tank.getFluidAmount() > 0) {
                    FluidStack drained;
                    FluidTank buffer = logicState.bufferTanks.output();
                    int accepted = buffer.fill(drained = this.tank.drain(25, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted <= 0) break;
                    int amount = Math.min(drained.getAmount(), accepted);
                    this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    buffer.fill(Utils.copyFluidStackWithAmount((FluidStack)drained, (int)amount, (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return this.setStage(State.FLOODING);
            }
            case FLOODING: {
                ++this.timer;
                if (this.timer < 2) break;
                this.timer = 0;
                int max = this.getTotalAmount() * this.recipe.getInputFluid().getAmount();
                if (this.tank.getFluidAmount() < max) {
                    FluidStack accepted = logicState.bufferTanks.input().drain(this.recipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted.getAmount() < this.recipe.getInputFluid().getAmount()) break;
                    logicState.bufferTanks.input().drain(this.recipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    this.tank.fill(accepted, IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                if (this.tank.getFluidAmount() < max) break;
                return this.setStage(State.DUMPING);
            }
            case DUMPING: {
                boolean update = false;
                ++this.timer;
                if (this.timer >= 5) {
                    this.timer = 0;
                    if (this.outputAmount > 0) {
                        IMultiblockLevel multiLevel = context.getLevel();
                        Level world = multiLevel.getRawLevel();
                        int amount = Math.min(this.outputAmount, 1);
                        ItemStack copy = this.recipe.getOutputItem();
                        copy.m_41764_(amount);
                        BlockPos itemOutPos = multiLevel.toAbsolute(chamberId == 0 ? CokerUnitLogic.Chamber_A_OUT.posInMultiblock() : CokerUnitLogic.Chamber_B_OUT.posInMultiblock());
                        Vec3 center = new Vec3((double)itemOutPos.m_123341_() + 0.5, (double)itemOutPos.m_123342_() - 0.5, (double)itemOutPos.m_123343_() + 0.5);
                        ItemEntity ent = new ItemEntity(world, center.f_82479_, center.f_82480_, center.f_82481_, copy);
                        ent.m_20334_(0.0, 0.0, 0.0);
                        world.m_7967_((Entity)ent);
                        this.outputAmount -= amount;
                        update = true;
                    }
                }
                if (this.tank.getFluidAmount() > 0) {
                    this.tank.drain(25, IFluidHandler.FluidAction.EXECUTE);
                    update = true;
                }
                if (this.outputAmount <= 0 && this.tank.isEmpty()) {
                    this.recipe = null;
                    this.setStage(State.STANDBY);
                    update = true;
                }
                if (!update) break;
                return true;
            }
        }
        return false;
    }

    public static enum State {
        STANDBY,
        PROCESSING,
        DRAIN_RESIDUE,
        FLOODING,
        DUMPING;


        public int id() {
            return this.ordinal();
        }
    }
}

