/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.IReadWriteNBT;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokingChamber;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.CokerShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CokerUnitLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int CHAMBER_A = 0;
    public static final int CHAMBER_B = 1;
    public static final CapabilityPosition Chamber_A_OUT = new CapabilityPosition(2, 0, 2, RelativeBlockFace.BACK);
    public static final CapabilityPosition Chamber_B_OUT = new CapabilityPosition(6, 0, 2, RelativeBlockFace.BACK);
    public static final CapabilityPosition Fluid_IN = new CapabilityPosition(2, 0, 4, RelativeBlockFace.BACK);
    public static final CapabilityPosition Fluid_OUT = new CapabilityPosition(5, 0, 4, RelativeBlockFace.BACK);
    public static final CapabilityPosition Item_IN = new CapabilityPosition(3, 0, 4, RelativeBlockFace.BACK);
    public static final CapabilityPosition[] Energy_IN = new CapabilityPosition[]{new CapabilityPosition(6, 1, 4, RelativeBlockFace.BACK), new CapabilityPosition(7, 1, 4, RelativeBlockFace.BACK)};
    public static final BlockPos Redstone_IN = new BlockPos(6, 1, 4);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        InitialMultiblockContext capSource = (InitialMultiblockContext)capabilitySource;
        return new State(capabilitySource, capSource.masterBE().m_58899_());
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel mbLevel = context.getLevel();
        Level level = mbLevel.getRawLevel();
        if (!state.rsState.isEnabled(context)) {
            return;
        }
        CokingChamber[] chambers = state.chambers.get();
        boolean debug = false;
        for (int i = 0; i < chambers.length; ++i) {
            if (!debug && chambers[i].getState() != CokingChamber.State.DUMPING) continue;
            BlockPos cOutPos = mbLevel.toAbsolute(i == 0 ? Chamber_A_OUT.posInMultiblock() : Chamber_B_OUT.posInMultiblock());
            Vec3 origin = new Vec3((double)cOutPos.m_123341_() + 0.5, (double)cOutPos.m_123342_() + 2.125, (double)cOutPos.m_123343_() + 0.5);
            for (int j = 0; j < 10; ++j) {
                double rX = (Math.random() - 0.5) * 0.4;
                double rY = (Math.random() - 0.5) * 0.5;
                double rdx = (Math.random() - 0.5) * 0.1;
                double rdy = (Math.random() - 0.5) * 0.1;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, origin.f_82479_ + rX, origin.f_82480_, origin.f_82481_ + rY, rdx, -(Math.random() * 0.06 + 0.11), rdy);
            }
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        ItemStack container;
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean update = false;
        if (rsEnabled) {
            CokerUnitRecipe recipe;
            ItemStack inputStack = state.getInventory(Inventory.INPUT);
            FluidStack inputFluid = state.bufferTanks.input().getFluid();
            if (!inputStack.m_41619_() && inputFluid.getAmount() > 0 && CokerUnitRecipe.hasRecipeWithInput(inputStack, inputFluid) && (recipe = CokerUnitRecipe.findRecipe(inputStack, inputFluid)) != null && inputStack.m_41613_() >= recipe.getInputItem().getCount() && inputFluid.getAmount() >= recipe.getInputFluid().getAmount()) {
                for (CokingChamber chamber : state.chambers.get()) {
                    boolean skipNext = false;
                    switch (chamber.getState()) {
                        case STANDBY: {
                            if (!chamber.setRecipe(recipe)) break;
                            update = true;
                            skipNext = true;
                            break;
                        }
                        case PROCESSING: {
                            int acceptedStack = chamber.addStack(state.copyStack(inputStack, recipe.getInputItem().getCount()), true);
                            if (acceptedStack < recipe.getInputItem().getCount()) break;
                            acceptedStack = Math.min(acceptedStack, inputStack.m_41613_());
                            chamber.addStack(state.copyStack(inputStack, acceptedStack), false);
                            inputStack.m_41774_(acceptedStack);
                            skipNext = true;
                            update = true;
                            break;
                        }
                    }
                    if (skipNext) break;
                }
            }
            CokingChamber[] chambers = state.chambers.get();
            for (int i = 0; i < chambers.length; ++i) {
                update |= chambers[i].tick(context, i);
            }
        }
        if (!state.getInventory(Inventory.INPUT_FILLED).m_41619_() && state.bufferTanks.input().getFluidAmount() < state.bufferTanks.input().getCapacity() && !(container = Utils.drainFluidContainer((IFluidHandler)state.bufferTanks.input(), (ItemStack)state.getInventory(Inventory.INPUT_FILLED), (ItemStack)state.getInventory(Inventory.INPUT_EMPTY))).m_41619_()) {
            if (!state.getInventory(Inventory.INPUT_EMPTY).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)state.getInventory(Inventory.INPUT_EMPTY), (ItemStack)container)) {
                state.getInventory(Inventory.INPUT_EMPTY).m_41769_(container.m_41613_());
            } else if (state.getInventory(Inventory.INPUT_EMPTY).m_41619_()) {
                state.setInventory(Inventory.INPUT_EMPTY, container.m_41777_());
            }
            state.getInventory(Inventory.INPUT_FILLED).m_41774_(1);
            if (state.getInventory(Inventory.INPUT_FILLED).m_41613_() <= 0) {
                state.setInventory(Inventory.INPUT_FILLED, ItemStack.f_41583_);
            }
            update = true;
        }
        if (state.bufferTanks.output().getFluidAmount() > 0) {
            ItemStack filledContainer;
            if (!state.getInventory(Inventory.OUTPUT_EMPTY).m_41619_() && !(filledContainer = FluidHelper.fillFluidContainer((IFluidHandler)state.bufferTanks.output(), state.getInventory(Inventory.OUTPUT_EMPTY), state.getInventory(Inventory.OUTPUT_FILLED), null)).m_41619_()) {
                if (state.getInventory(Inventory.OUTPUT_FILLED).m_41613_() == 1 && !FluidHelper.isFluidContainerFull(filledContainer)) {
                    state.setInventory(Inventory.OUTPUT_FILLED, filledContainer.m_41777_());
                } else {
                    if (!state.getInventory(Inventory.OUTPUT_FILLED).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)state.getInventory(Inventory.OUTPUT_FILLED), (ItemStack)filledContainer)) {
                        state.getInventory(Inventory.OUTPUT_FILLED).m_41769_(filledContainer.m_41613_());
                    } else if (state.getInventory(Inventory.OUTPUT_FILLED).m_41619_()) {
                        state.setInventory(Inventory.OUTPUT_FILLED, filledContainer.m_41777_());
                    }
                    state.getInventory(Inventory.OUTPUT_EMPTY).m_41774_(1);
                    if (state.getInventory(Inventory.OUTPUT_EMPTY).m_41613_() <= 0) {
                        state.setInventory(Inventory.OUTPUT_EMPTY, ItemStack.f_41583_);
                    }
                }
                update = true;
            }
            BlockPos outPos = level.toAbsolute(Fluid_OUT.posInMultiblock()).m_121945_(level.getOrientation().front().m_122424_());
            update |= FluidUtil.getFluidHandler((Level)level.getRawLevel(), (BlockPos)outPos, (Direction)level.getOrientation().front()).map(out -> {
                if (state.bufferTanks.output().getFluidAmount() > 0) {
                    FluidStack fs = state.bufferTanks.output().getFluid();
                    int accepted = out.fill(fs = FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), 250)), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted > 0) {
                        boolean iePipe = level.getBlockEntity(outPos) instanceof IFluidPipe;
                        int drained = out.fill(FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                        state.bufferTanks.output().drain(FluidHelper.copyFluid(fs, drained), IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                }
                return false;
            }).orElse(false).booleanValue();
        }
        if (update) {
            context.markDirtyAndSync();
        }
        this.updateComparatorOutput(context);
    }

    private void updateComparatorOutput(IMultiblockContext<State> context) {
        boolean update = false;
        State state = (State)context.getState();
        ItemStack stack = state.getInventory(Inventory.INPUT);
        if (!stack.m_41619_()) {
            int compared = Mth.m_14045_((int)Mth.m_14143_((float)((float)stack.m_41613_() / (float)Math.min(64, stack.m_41741_()) * 15.0f)), (int)0, (int)15);
            if (compared != state.lastCompared) {
                state.lastCompared = compared;
                update = true;
            }
        } else if (state.lastCompared != 0) {
            state.lastCompared = 0;
            update = true;
        }
        if (update) {
            BlockPos p = context.getLevel().toAbsolute(Redstone_IN);
            context.getLevel().getRawLevel().m_46672_(p, context.getLevel().getBlockState(p).m_60734_());
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (position.equalsOrNullFace(Item_IN)) {
                return state.itemInput.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equalsOrNullFace(Fluid_OUT)) {
                return state.fluidOutput.cast(ctx);
            }
            if (position.equalsOrNullFace(Fluid_IN)) {
                return state.fluidInput.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.ENERGY && (position.equalsOrNullFace(Energy_IN[0]) || position.equalsOrNullFace(Energy_IN[1]))) {
            return state.energyCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return CokerShape.GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(24000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        int lastCompared = 0;
        public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)Inventory.values().length, (Object)ItemStack.f_41583_);
        public final BufferTanks bufferTanks = new BufferTanks();
        public final Chambers chambers = new Chambers();
        private final StoredCapability<IItemHandler> itemInput = new StoredCapability((Object)new FilteredItemStackhandler(this.inventory));
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability((Object)this.energy);
        private final StoredCapability<IFluidHandler> fluidInput;
        private final StoredCapability<IFluidHandler> fluidOutput;
        public BlockPos masterPos;

        public State(IInitialMultiblockContext<State> context, BlockPos pos) {
            this.masterPos = pos;
            this.fluidInput = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.bufferTanks.input(), (Runnable)context.getMarkDirtyRunnable()));
            this.fluidOutput = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.bufferTanks.output(), (Runnable)context.getMarkDirtyRunnable()));
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("buffertanks", (Tag)this.bufferTanks.writeNBT());
            nbt.m_128365_("chambers", (Tag)this.chambers.writeNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("inventory", (Tag)this.writeInventory(this.inventory));
            this.rsState.writeSaveNBT(nbt);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.bufferTanks.readNBT(nbt.m_128469_("buffertanks"));
            this.chambers.readNBT(nbt.m_128469_("chambers"));
            this.readInventory(nbt.m_128469_("inventory"));
            this.energy.deserializeNBT((Tag)nbt.m_128469_("energy"));
            this.rsState.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        protected void readInventory(CompoundTag nbt) {
            NonNullList list = NonNullList.m_122779_();
            ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)list);
            for (int i = 0; i < this.inventory.size(); ++i) {
                ItemStack stack = ItemStack.f_41583_;
                if (i < list.size()) {
                    stack = (ItemStack)list.get(i);
                }
                this.inventory.set(i, (Object)stack);
            }
        }

        protected CompoundTag writeInventory(NonNullList<ItemStack> list) {
            return ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), list);
        }

        public ItemStack getInventory(Inventory inv) {
            return (ItemStack)this.inventory.get(inv.id());
        }

        public ItemStack setInventory(Inventory inv, ItemStack stack) {
            return (ItemStack)this.inventory.set(inv.id(), (Object)stack);
        }

        public ItemStack copyStack(ItemStack stack, int amount) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
    }

    public static class Chambers
    implements IReadWriteNBT {
        private final CokingChamber[] array = new CokingChamber[]{new CokingChamber(64, 8000), new CokingChamber(64, 8000)};

        public CokingChamber[] get() {
            return this.array;
        }

        public CokingChamber primary() {
            return this.array[0];
        }

        public CokingChamber secondary() {
            return this.array[1];
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            this.array[0].readFromNBT(nbt.m_128469_("primary"));
            this.array[1].readFromNBT(nbt.m_128469_("secondary"));
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("primary", (Tag)this.array[0].writeToNBT(new CompoundTag()));
            nbt.m_128365_("secondary", (Tag)this.array[1].writeToNBT(new CompoundTag()));
            return nbt;
        }
    }

    public static enum Inventory {
        INPUT,
        INPUT_FILLED,
        INPUT_EMPTY,
        OUTPUT_EMPTY,
        OUTPUT_FILLED;


        public int id() {
            return this.ordinal();
        }
    }

    public static class BufferTanks
    implements IReadWriteNBT {
        private final FluidTank input = new FluidTank(16000);
        private final FluidTank output = new FluidTank(16000);

        public FluidTank input() {
            return this.input;
        }

        public FluidTank output() {
            return this.output;
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            this.input.readFromNBT(nbt.m_128469_("input"));
            this.output.readFromNBT(nbt.m_128469_("output"));
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("input", (Tag)this.input.writeToNBT(new CompoundTag()));
            nbt.m_128365_("output", (Tag)this.output.writeToNBT(new CompoundTag()));
            return nbt;
        }
    }

    private static class FilteredItemStackhandler
    extends ItemStackHandler {
        public FilteredItemStackhandler(NonNullList<ItemStack> inventory) {
            super(inventory);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == Inventory.INPUT.id()) {
                ItemStack existing = this.getStackInSlot(slot);
                return !existing.m_41619_() && ItemStack.m_41656_((ItemStack)existing, (ItemStack)stack) || CokerUnitRecipe.hasRecipeWithInput(stack, true);
            }
            return false;
        }
    }
}

