/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.PumpjackShape;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class PumpjackLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 5);
    public static final CapabilityPosition ENERGY_IN = new CapabilityPosition(2, 1, 5, RelativeBlockFace.UP);
    public static final MultiblockFace EAST_PORT_OFFSET = new MultiblockFace(3, 0, 2, RelativeBlockFace.RIGHT);
    public static final CapabilityPosition EAST_PORT = CapabilityPosition.opposing((MultiblockFace)EAST_PORT_OFFSET);
    public static final MultiblockFace WEST_PORT_OFFSET = new MultiblockFace(-1, 0, 2, RelativeBlockFace.LEFT);
    public static final CapabilityPosition WEST_PORT = CapabilityPosition.opposing((MultiblockFace)WEST_PORT_OFFSET);
    public static final BlockPos DOWN_PORT = new BlockPos(1, 0, 0);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.wasActive) {
            state.activeTicks += 1.0f;
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        int consumption;
        int extracted;
        WellPipeTileEntity pipe;
        WellTileEntity well;
        BlockEntity teLow;
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean active = false;
        if (rsEnabled && (teLow = level.getBlockEntity(DOWN_PORT.m_7495_())) instanceof WellPipeTileEntity && (well = (pipe = (WellPipeTileEntity)teLow).getWell()) != null && (extracted = state.energy.extractEnergy(consumption = ((Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get()).intValue(), true)) >= consumption) {
            boolean foundPressurizedIsland = false;
            for (ColumnPos cPos : well.tappedIslands) {
                ReservoirIsland island = ReservoirHandler.getIsland(level.getRawLevel(), cPos);
                if (island == null || !(island.getPressure(level.getRawLevel(), cPos.f_140723_(), cPos.f_140724_()) > 0.0f)) continue;
                foundPressurizedIsland = true;
                break;
            }
            if (!foundPressurizedIsland) {
                int extractSpeed = (Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get();
                IFluidHandler portEast_output = (IFluidHandler)state.east_port_output.getNullable();
                IFluidHandler portWest_output = (IFluidHandler)state.west_port_output.getNullable();
                for (ColumnPos cPos : well.tappedIslands) {
                    int drained;
                    int accepted;
                    ReservoirIsland island = ReservoirHandler.getIsland(level.getRawLevel(), cPos);
                    if (island == null) continue;
                    FluidStack fluid = new FluidStack(island.getFluid(), island.extract(extractSpeed, IFluidHandler.FluidAction.SIMULATE));
                    if (portEast_output != null && (accepted = portEast_output.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                        drained = portEast_output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                        island.extract(drained, IFluidHandler.FluidAction.EXECUTE);
                        fluid = FluidHelper.copyFluid(fluid, fluid.getAmount() - drained);
                        active = true;
                    }
                    if (portWest_output == null || fluid.getAmount() <= 0 || (accepted = portWest_output.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                    drained = portWest_output.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    island.extract(drained, IFluidHandler.FluidAction.EXECUTE);
                    active = true;
                }
                if (active) {
                    state.energy.extractEnergy(consumption, false);
                    state.activeTicks += 1.0f;
                }
            }
        }
        if (active != state.wasActive) {
            context.markMasterDirty();
            context.requestMasterBESync();
        }
        state.wasActive = active;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equalsOrNullFace(EAST_PORT)) {
                return state.fakeFluidHandler.cast(ctx);
            }
            if (position.equalsOrNullFace(WEST_PORT)) {
                return state.fakeFluidHandler.cast(ctx);
            }
        }
        if (cap == ForgeCapabilities.ENERGY && position.equalsOrNullFace(ENERGY_IN)) {
            return state.energyStorage.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return PumpjackShape.GETTER;
    }

    public static class State
    implements IMultiblockState {
        public static final FluidTank FAKE_TANK = new FluidTank(0);
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean wasActive = false;
        public float activeTicks = 0.0f;
        private final StoredCapability<IFluidHandler> fakeFluidHandler = new StoredCapability((Object)FAKE_TANK);
        private final StoredCapability<IEnergyStorage> energyStorage = new StoredCapability((Object)this.energy);
        private final CapabilityReference<@Nullable IFluidHandler> east_port_output;
        private final CapabilityReference<@Nullable IFluidHandler> west_port_output;

        public State(IInitialMultiblockContext<State> context) {
            this.east_port_output = context.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, EAST_PORT_OFFSET);
            this.west_port_output = context.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, WEST_PORT_OFFSET);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128379_("wasActive", this.wasActive);
            nbt.m_128365_("energy", this.energy.serializeNBT());
            this.rsState.writeSaveNBT(nbt);
        }

        public void readSaveNBT(CompoundTag nbt) {
            boolean lastActive = this.wasActive;
            this.wasActive = nbt.m_128471_("wasActive");
            if (!this.wasActive && lastActive) {
                this.activeTicks += 1.0f;
            }
            this.energy.deserializeNBT((Tag)nbt.m_128469_("energy"));
            this.rsState.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("wasActive", this.wasActive);
        }

        public void readSyncNBT(CompoundTag nbt) {
            boolean lastActive = this.wasActive;
            this.wasActive = nbt.m_128471_("wasActive");
            if (!this.wasActive && lastActive) {
                this.activeTicks += 1.0f;
            }
        }
    }
}

