/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.DerrickShape;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellBlock;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class DerrickLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int REQUIRED_WATER_AMOUNT = 125;
    public static final int REQUIRED_CONCRETE_AMOUNT = 125;
    public static final FluidTank DUMMY_TANK = new FluidTank(0);
    public static final CapabilityPosition Fluid_IN = new CapabilityPosition(2, 0, 4, RelativeBlockFace.BACK);
    public static final CapabilityPosition FLUID_OUT = new CapabilityPosition(4, 0, 2, RelativeBlockFace.LEFT);
    public static final CapabilityPosition Energy_IN = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos Redstone_IN = new BlockPos(0, 1, 1);
    private static final BlockState[] PARTICLE_STATES = new BlockState[]{Blocks.f_50069_.m_49966_(), Blocks.f_50122_.m_49966_(), Blocks.f_49994_.m_49966_(), Blocks.f_152550_.m_49966_(), Blocks.f_50228_.m_49966_(), Blocks.f_49992_.m_49966_(), Blocks.f_50334_.m_49966_()};

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        InitialMultiblockContext capSource = (InitialMultiblockContext)capabilitySource;
        return new State(capabilitySource, capSource.masterBE().m_58899_());
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        if (state.drilling) {
            state.rotation += 10;
            state.rotation %= 2160;
            double x = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).m_123341_() + 0.5;
            double y = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).m_123342_() + 1.0;
            double z = (double)level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()).m_123343_() + 0.5;
            int r = level.getRawLevel().f_46441_.m_188503_(PARTICLE_STATES.length);
            for (int i = 0; i < 5; ++i) {
                float xa = (level.getRawLevel().f_46441_.m_188501_() - 0.5f) * 10.0f;
                float ya = 5.0f;
                float za = (level.getRawLevel().f_46441_.m_188501_() - 0.5f) * 10.0f;
                level.getRawLevel().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, PARTICLE_STATES[r]), x, y, z, (double)xa, (double)ya, (double)za);
            }
        }
        if (state.spilling) {
            ClientProxy.spawnSpillParticles(level.getRawLevel(), level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()), state.fluidSpilled, 5, 1.25f, state.clientFlow);
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        if (state.level == null) {
            state.level = () -> ((IMultiblockLevel)level).getRawLevel();
        }
        if (state.originPos == null) {
            state.originPos = level.getAbsoluteOrigin();
        }
        boolean wasActive = false;
        boolean lastDrilling = state.drilling;
        boolean lastSpilling = state.spilling;
        state.spilling = false;
        state.drilling = false;
        if (level.getAbsoluteOrigin().m_123342_() < level.getRawLevel().m_5736_()) {
            if (state.fluidSpilled == Fluids.f_76191_) {
                state.fluidSpilled = Fluids.f_76193_;
            }
            state.spilling = true;
        } else {
            WellTileEntity well = DerrickLogic.createAndGetWell(state.level, state, level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()), this.getInventory(state, Inventory.INPUT) != ItemStack.f_41583_);
            if (rsEnabled && state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), true) >= (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get() && well != null && well.wellPipeLength < well.getMaxPipeLength()) {
                ItemStack stack;
                if (well.pipes <= 0 && this.getInventory(state, Inventory.INPUT) != ItemStack.f_41583_ && (stack = this.getInventory(state, Inventory.INPUT)).m_41613_() > 0) {
                    stack.m_41774_(1);
                    well.pipes = 6;
                    if (stack.m_41613_() <= 0) {
                        this.setInventory(state, Inventory.INPUT, ItemStack.f_41583_);
                    }
                    well.m_6596_();
                    wasActive = true;
                }
                if (well.pipes > 0) {
                    BlockPos dPos = level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB());
                    BlockPos wPos = well.m_58899_();
                    int realPipeLength = dPos.m_123342_() - 1 - wPos.m_123342_();
                    if (well.phyiscalPipesList.size() < realPipeLength && well.wellPipeLength < realPipeLength) {
                        if (state.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer(state)) {
                                BlockPos current;
                                BlockState blockState;
                                Level world = level.getRawLevel();
                                for (int y = dPos.m_123342_() - 1; y > wPos.m_123342_() && (blockState = world.m_8055_(current = new BlockPos(dPos.m_123341_(), y, dPos.m_123343_()))).m_60734_() != Blocks.f_50752_ && blockState.m_60734_() != IPContent.Blocks.WELL.get(); --y) {
                                    if (blockState.m_60734_() == IPContent.Blocks.WELL_PIPE.get() && !((Boolean)blockState.m_61143_((Property)WellPipeBlock.BROKEN)).booleanValue()) continue;
                                    world.m_46961_(current, false);
                                    world.m_46597_(current, ((WellPipeBlock)IPContent.Blocks.WELL_PIPE.get()).m_49966_());
                                    well.phyiscalPipesList.add(y);
                                    state.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                    well.usePipe();
                                    break;
                                }
                                if (well.phyiscalPipesList.size() >= realPipeLength && well.wellPipeLength >= realPipeLength) {
                                    well.pastPhysicalPart = true;
                                    well.m_6596_();
                                }
                            }
                            wasActive = true;
                            state.drilling = true;
                        }
                    } else {
                        if (!state.tank.getFluid().isEmpty() && ExternalModContent.IE.isConcrete(state.tank.getFluid())) {
                            state.tank.drain(state.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                            wasActive = true;
                        }
                        if (state.tank.drain(125, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 125) {
                            state.energy.extractEnergy(((Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()).intValue(), false);
                            if (this.advanceTimer(state)) {
                                this.restorePhysicalPipeProgress(well, dPos, realPipeLength);
                                state.tank.drain(125, IFluidHandler.FluidAction.EXECUTE);
                                well.usePipe();
                            }
                            wasActive = true;
                            state.drilling = true;
                        }
                    }
                }
            }
            if (well != null && well.wellPipeLength == well.getMaxPipeLength()) {
                this.outputReservoirFluid(level, state, level.toAbsolute(FLUID_OUT.posInMultiblock()), context);
            }
        }
        if (state.spilling && state.fluidSpilled == Fluids.f_76191_) {
            state.fluidSpilled = IPContent.Fluids.CRUDEOIL.get();
        }
        if (!state.spilling && state.fluidSpilled != Fluids.f_76191_) {
            state.fluidSpilled = Fluids.f_76191_;
        }
        if (wasActive || lastDrilling != state.drilling || lastSpilling != state.spilling) {
            context.markDirtyAndSync();
        }
    }

    private static boolean acceptsFluid(Supplier<Level> level, State state, BlockPos inPos, FluidStack fs) {
        int waterNeeded;
        boolean isWater;
        if (fs.isEmpty()) {
            return false;
        }
        WellTileEntity well = DerrickLogic.createAndGetWell(level, state, inPos, false);
        if (well == null) {
            return false;
        }
        Fluid inFluid = fs.getFluid();
        boolean isConcrete = inFluid == ExternalModContent.IE.fluidConcrete();
        boolean bl = isWater = inFluid == Fluids.f_76193_;
        if (!isConcrete && !isWater) {
            return false;
        }
        int realPipeLength = inPos.m_123342_() - 1 - well.m_58899_().m_123342_();
        int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
        if (concreteNeeded > 0 && isConcrete) {
            FluidStack tankFluidStack = state.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= concreteNeeded) {
                return false;
            }
            return concreteNeeded >= fs.getAmount();
        }
        if (concreteNeeded <= 0 && (waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength)) > 0 && isWater) {
            FluidStack tankFluidStack = state.tank.getFluid();
            if (!tankFluidStack.isEmpty() && inFluid != tankFluidStack.getFluid() || tankFluidStack.getAmount() >= waterNeeded) {
                return false;
            }
            return waterNeeded >= fs.getAmount();
        }
        return false;
    }

    public static WellTileEntity createAndGetWell(Supplier<Level> level, State state, BlockPos inPos, boolean popList) {
        Level rawLevel = level.get();
        if (state.wellCache != null && state.wellCache.m_58901_()) {
            state.wellCache = null;
        }
        if (state.wellCache == null) {
            WellTileEntity well = null;
            for (int y = inPos.m_7495_().m_123342_(); y >= rawLevel.m_141937_() - 1; --y) {
                BlockPos current = new BlockPos(inPos.m_123341_(), y, inPos.m_123343_());
                BlockState blockState = rawLevel.m_8055_(current);
                if (blockState.m_60734_() == IPContent.Blocks.WELL.get()) {
                    well = (WellTileEntity)rawLevel.m_7702_(current);
                    break;
                }
                if (blockState.m_60734_() != Blocks.f_50752_) continue;
                rawLevel.m_46597_(current, ((WellBlock)IPContent.Blocks.WELL.get()).m_49966_());
                well = (WellTileEntity)rawLevel.m_7702_(current);
                break;
            }
            state.wellCache = well;
        }
        if (popList && state.wellCache != null && state.wellCache.tappedIslands.isEmpty()) {
            if (state.gridStorage != null) {
                DerrickLogic.transferGridDataToWell(inPos, state, state.wellCache);
            } else {
                state.wellCache.tappedIslands.add(Utils.toColumnPos(inPos));
                state.wellCache.m_6596_();
            }
        }
        if (state.wellCache != null) {
            state.wellCache.abortSelfDestructSequence();
        }
        return state.wellCache;
    }

    public ItemStack getInventory(State state, Inventory inv) {
        return (ItemStack)state.inventory.get(inv.id());
    }

    public ItemStack setInventory(State state, Inventory inv, ItemStack stack) {
        return (ItemStack)state.inventory.set(inv.id(), (Object)stack);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        if (!((ItemStack)state.inventory.get(0)).m_41619_()) {
            drop.accept((ItemStack)state.inventory.get(0));
        }
    }

    private boolean advanceTimer(State state) {
        if (state.timer-- <= 0) {
            state.timer = 10;
            return true;
        }
        return false;
    }

    public void restorePhysicalPipeProgress(@Nonnull WellTileEntity well, BlockPos dPos, int realPipeLength) {
        int min = Math.min(well.wellPipeLength, realPipeLength);
        for (int i = 1; i < min; ++i) {
            BlockPos current = new BlockPos(dPos.m_123341_(), dPos.m_123342_() - i, dPos.m_123343_());
            BlockState blockState = well.m_58904_().m_8055_(current);
            if (blockState.m_60734_() instanceof WellPipeBlock) continue;
            well.m_58904_().m_46961_(current, false);
            well.m_58904_().m_46597_(current, ((WellPipeBlock)IPContent.Blocks.WELL_PIPE.get()).m_49966_());
        }
    }

    private void outputReservoirFluid(IMultiblockLevel level, State state, BlockPos inPos, IMultiblockContext<State> ctx) {
        WellTileEntity well = DerrickLogic.createAndGetWell(() -> level.getRawLevel(), state, inPos, true);
        boolean mirrored = level.getOrientation().mirrored();
        Direction front = level.getOrientation().front();
        if (well == null) {
            return;
        }
        FluidStack extracted = this.getExtractedFluidStack(well);
        if (!extracted.isEmpty()) {
            Direction facing = mirrored ? front.m_122428_() : front.m_122427_();
            BlockPos outPos = level.toAbsolute(FLUID_OUT.posInMultiblock()).m_5484_(facing, 1);
            BlockEntity target = level.getRawLevel().m_7702_(outPos);
            if (target != null) {
                boolean isIEPipe = target instanceof IFluidPipe;
                LazyOptional output = target.getCapability(ForgeCapabilities.FLUID_HANDLER, mirrored ? front.m_122427_() : front.m_122428_());
                state.spilling = output.map(out -> DerrickLogic.iterativeOutput(out, extracted, isIEPipe)).orElse(true);
            } else {
                state.spilling = true;
            }
        }
        if (state.spilling && !extracted.isEmpty() && state.fluidSpilled != extracted.getFluid()) {
            state.fluidSpilled = extracted.getFluid();
        }
        if (!state.spilling && state.fluidSpilled != Fluids.f_76191_) {
            state.fluidSpilled = Fluids.f_76191_;
        }
    }

    private static boolean iterativeOutput(IFluidHandler out, FluidStack extracted, boolean isIEPipe) {
        FluidStack fluid = FluidHelper.copyFluid(extracted, extracted.getAmount(), isIEPipe);
        int drainedTotal = 0;
        for (int attempt = 0; attempt < 10 && fluid.getAmount() > 0; ++attempt) {
            int accepted = out.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
            if (accepted == 0) {
                return true;
            }
            int drained = out.fill(FluidHelper.copyFluid(fluid, Math.min(fluid.getAmount(), accepted), isIEPipe), IFluidHandler.FluidAction.EXECUTE);
            fluid = FluidHelper.copyFluid(extracted, fluid.getAmount() - drained, isIEPipe);
            drainedTotal += drained;
        }
        return extracted.getAmount() - drainedTotal > 0;
    }

    public static void transferGridDataToWell(BlockPos masterPos, State state, @Nullable WellTileEntity well) {
        if (well == null) {
            return;
        }
        int additionalPipes = 0;
        ArrayList<ColumnPos> list = new ArrayList<ColumnPos>();
        PipeConfig.Grid grid = state.gridStorage;
        for (int j = 0; j < grid.getHeight(); ++j) {
            for (int i = 0; i < grid.getWidth(); ++i) {
                int type = grid.get(i, j);
                if (type <= 0) continue;
                switch (type) {
                    case 2: 
                    case 3: {
                        int x = i - grid.getWidth() / 2;
                        int z = j - grid.getHeight() / 2;
                        ColumnPos pos = new ColumnPos(masterPos.m_123341_() + x, masterPos.m_123343_() + z);
                        list.add(pos);
                    }
                    case 1: {
                        ++additionalPipes;
                    }
                }
            }
        }
        well.tappedIslands = list;
        well.additionalPipes = additionalPipes;
        well.m_6596_();
    }

    private FluidStack getExtractedFluidStack(@Nonnull WellTileEntity well) {
        Fluid extractedFluid = Fluids.f_76191_;
        int extractedAmount = 0;
        for (ColumnPos cPos : well.tappedIslands) {
            ReservoirIsland island = ReservoirHandler.getIsland(well.m_58904_(), cPos);
            if (island == null) continue;
            if (extractedFluid == Fluids.f_76191_) {
                extractedFluid = island.getFluid();
            } else if (island.getFluid() != extractedFluid) continue;
            extractedAmount += island.extractWithPressure(well.m_58904_(), cPos.f_140723_(), cPos.f_140724_());
        }
        return new FluidStack(extractedFluid, extractedAmount);
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = (State)ctx.getState();
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (position.equalsOrNullFace(Fluid_IN)) {
                return state.fluidHandler.cast(ctx);
            }
            if (position.equalsOrNullFace(FLUID_OUT)) {
                return state.emptyHandler.cast(ctx);
            }
        } else if (cap == ForgeCapabilities.ENERGY && position.equalsOrNullFace(Energy_IN)) {
            return state.energyHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void onRemoved(IMultiblockContext<State> context) {
        if (context.getLevel().getRawLevel().f_46443_) {
            return;
        }
        IMultiblockLevel mbLevel = context.getLevel();
        Level rawLevel = mbLevel.getRawLevel();
        WellTileEntity well = ((State)context.getState()).getWell(mbLevel, mbLevel.toRelative(IPContent.Multiblock.DERRICK.masterPosInMB()));
        if (well != null && !well.drillingCompleted) {
            if (well.wellPipeLength > 0) {
                well.startSelfDestructSequence();
            } else {
                rawLevel.m_46597_(well.m_58899_(), Blocks.f_50752_.m_49966_());
            }
        }
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return DerrickShape.GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public int timer = 0;
        public int rotation = 0;
        public boolean drilling;
        public boolean spilling;
        private Fluid fluidSpilled = Fluids.f_76191_;
        public final FluidTank tank;
        public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        private WellTileEntity wellCache = null;
        @Nullable
        public PipeConfig.Grid gridStorage;
        private int clientFlow;
        private Supplier<Level> level;
        public BlockPos originPos;
        private final StoredCapability<IEnergyStorage> energyHandler = new StoredCapability((Object)this.energy);
        private final StoredCapability<IFluidHandler> fluidHandler;
        private final StoredCapability<IFluidHandler> emptyHandler;
        private final StoredCapability<IItemHandler> itemHandler;

        public State(IInitialMultiblockContext<State> context, BlockPos pos) {
            this.emptyHandler = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)DUMMY_TANK, (Runnable)context.getMarkDirtyRunnable()));
            this.itemHandler = new StoredCapability((Object)new ItemStackHandler(this.inventory));
            this.level = context.levelSupplier();
            this.originPos = pos;
            this.tank = new FluidTank(8000, fluidStack -> DerrickLogic.acceptsFluid(this.level, this, pos, fluidStack));
            this.fluidHandler = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.tank, (Runnable)context.getMarkDirtyRunnable()));
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.drilling = nbt.m_128471_("drilling");
            this.spilling = nbt.m_128471_("spilling");
            this.clientFlow = nbt.m_128451_("spillflow");
            try {
                this.fluidSpilled = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.parse((String)nbt.m_128461_("spillingfluid")));
            }
            catch (ResourceLocationException rle) {
                this.fluidSpilled = Fluids.f_76191_;
            }
            if (nbt.m_128425_("grid", 10)) {
                this.gridStorage = PipeConfig.Grid.fromCompound(nbt.m_128469_("grid"));
            }
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.rsState.readSaveNBT(nbt);
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128379_("drilling", this.drilling);
            nbt.m_128379_("spilling", this.spilling);
            nbt.m_128405_("spillflow", this.getReservoirFlow());
            nbt.m_128359_("spillingfluid", RegistryUtils.getRegistryNameOf(this.fluidSpilled).toString());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            if (this.gridStorage != null) {
                nbt.m_128365_("grid", (Tag)this.gridStorage.toCompound());
            }
            this.rsState.writeSaveNBT(nbt);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }

        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }

        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        private int getReservoirFlow() {
            ReservoirIsland island = ReservoirHandler.getIsland(this.level.get(), this.originPos);
            if (island == null || this.originPos.m_123342_() < this.level.get().m_5736_()) {
                return 10;
            }
            return island.getFlowFromPressure(this.level.get(), this.originPos);
        }

        public WellTileEntity getWell(IMultiblockLevel level, BlockPos inPos) {
            if (this.wellCache != null && this.wellCache.m_58901_()) {
                this.wellCache = null;
            }
            if (this.wellCache == null) {
                Level world = level.getRawLevel();
                WellTileEntity well = null;
                for (int y = inPos.m_7495_().m_123342_(); y >= world.m_141937_(); --y) {
                    BlockPos current = new BlockPos(inPos.m_123341_(), y, inPos.m_123343_());
                    BlockState blockState = world.m_8055_(current);
                    if (blockState.m_60734_() != IPContent.Blocks.WELL.get()) continue;
                    well = (WellTileEntity)world.m_7702_(current);
                    break;
                }
                this.wellCache = well;
            }
            return this.wellCache;
        }
    }

    public static enum Inventory {
        INPUT;


        public int id() {
            return this.ordinal();
        }
    }
}

