/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.DerrickRenderer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.IPClientMultiblockProperties;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.IPTemplateMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.model.data.ModelData;

public class DerrickMultiblock
extends IPTemplateMultiblock {
    public static final DerrickMultiblock INSTANCE = new DerrickMultiblock();

    public DerrickMultiblock() {
        super(ResourceUtils.ip("multiblocks/derrick"), new BlockPos(2, 0, 2), new BlockPos(2, 0, 4), new BlockPos(5, 8, 5), IPContent.Multiblock.DERRICK);
    }

    public float getManualScale() {
        return 10.0f;
    }

    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
        consumer.accept(new DerrickMultiblockProperties());
    }

    protected void prepareBlockForDisassembly(@Nonnull Level world, @Nonnull BlockPos pos) {
        IMultiblockBEHelperMaster masterHelper;
        IMultiblockLogic iMultiblockLogic;
        IMultiblockBE mbBE;
        IMultiblockBEHelper iMultiblockBEHelper;
        super.prepareBlockForDisassembly(world, pos);
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMultiblockBE && (iMultiblockBEHelper = (mbBE = (IMultiblockBE)be).getHelper()) instanceof IMultiblockBEHelperMaster && (iMultiblockLogic = (masterHelper = (IMultiblockBEHelperMaster)iMultiblockBEHelper).getMultiblock().logic()) instanceof DerrickLogic) {
            DerrickLogic logic = (DerrickLogic)iMultiblockLogic;
            IMultiblockContext ctx = masterHelper.getContext();
            logic.onRemoved((IMultiblockContext<DerrickLogic.State>)ctx);
        }
    }

    public static class DerrickMultiblockProperties
    extends IPClientMultiblockProperties {
        public DerrickMultiblockProperties() {
            super(INSTANCE, 2.5, 0.5, 2.5);
        }

        @Override
        public void renderExtras(PoseStack matrix, MultiBufferSource buffer) {
            matrix.m_85837_(0.0, 0.5, 0.0);
            DerrickMultiblockProperties.renderObj(DerrickRenderer.DRILL, buffer, matrix);
            for (int i = 0; i < 6; ++i) {
                matrix.m_85836_();
                matrix.m_85837_(0.0, (double)i + 0.75, 0.0);
                DerrickMultiblockProperties.renderObj(i < 5 ? DerrickRenderer.PIPE_SEGMENT : DerrickRenderer.PIPE_TOP, buffer, matrix);
                matrix.m_85849_();
            }
        }

        private static void renderObj(ResourceLocation modelRL, @Nonnull MultiBufferSource bufferIn, @Nonnull PoseStack matrix) {
            List quads = MCUtil.getModel(modelRL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
            PoseStack.Pose last = matrix.m_85850_();
            VertexConsumer solid = bufferIn.m_6299_(RenderType.m_110451_());
            for (BakedQuad quad : quads) {
                solid.m_85987_(last, quad, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
    }
}

