/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks;

import flaxbeard.immersivepetroleum.common.IPCreativeTab;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlacementReader;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.IPlayerInteraction;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPClientTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPServerTickableTile;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class IPBlockBase
extends Block
implements IPCreativeTab.IMightShowUpInCreativeTab {
    private final boolean isEntityBlock = this instanceof EntityBlock;

    public IPBlockBase(BlockBehaviour.Properties props) {
        super(props);
    }

    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new IPBlockItemBase(this, new Item.Properties());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (this.isEntityBlock && (blockEntity = pLevel.m_7702_(pPos)) instanceof IPlayerInteraction) {
            IPlayerInteraction inst = (IPlayerInteraction)blockEntity;
            Vec3 loc = pHit.m_82450_();
            return inst.interact(pHit.m_82434_(), pPlayer, pHand, pPlayer.m_21120_(pHand), (float)loc.f_82479_, (float)loc.f_82480_, (float)loc.f_82481_);
        }
        return InteractionResult.FAIL;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity blockEntity;
        if (!pLevel.f_46443_ && this.isEntityBlock && (blockEntity = pLevel.m_7702_(pPos)) instanceof IPlacementReader) {
            IPlacementReader read = (IPlacementReader)blockEntity;
            read.readOnPlacement(pPlacer, pStack);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createCommonTicker(boolean isClient, BlockEntityType<A> actual, RegistryObject<BlockEntityType<E>> expected) {
        return IPBlockBase.createCommonTicker(isClient, actual, (BlockEntityType)expected.get());
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createCommonTicker(boolean isClient, BlockEntityType<A> actual, BlockEntityType<E> expected) {
        if (isClient) {
            return IPBlockBase.createClientTicker(actual, expected);
        }
        return IPBlockBase.createServerTicker(actual, expected);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createClientTicker(BlockEntityType<A> actual, BlockEntityType<E> expected) {
        return IPBlockBase.createTickerHelper(actual, expected, IPClientTickableTile::makeTicker);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createServerTicker(BlockEntityType<A> actual, BlockEntityType<E> expected) {
        return IPBlockBase.createTickerHelper(actual, expected, IPServerTickableTile::makeTicker);
    }

    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, BlockEntityType<E> expected, Supplier<BlockEntityTicker<? super E>> ticker) {
        return expected == actual ? ticker.get() : null;
    }
}

