/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import flaxbeard.immersivepetroleum.common.shaderscases.ShaderCaseProjector;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;

public class IPToolShaders {
    public static void preInit() {
        String warnings = "Do not touch the operational end of the device.\nDo not look directly at the operational end of the device.";
        IPToolShaders.addProjectorShader("blue", Rarity.COMMON, -16744449, -16777216, -1, false, true, (primary, secondary, background, layers) -> {
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_portal"), -1));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_1_0"), primary.intValue()));
        }).setInfo("Aperture", "Portal", "Do not touch the operational end of the device.\nDo not look directly at the operational end of the device.");
        IPToolShaders.addProjectorShader("orange", Rarity.UNCOMMON, -33024, -16777216, -1, false, true, (primary, secondary, background, layers) -> {
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_portal"), -1));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_1_0"), primary.intValue()));
        }).setInfo("Aperture", "Portal", "Do not touch the operational end of the device.\nDo not look directly at the operational end of the device.");
        IPToolShaders.addProjectorShader("cube0", Rarity.COMMON, -12914177, -16777216, -1, false, true, (primary, secondary, background, layers) -> {
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_cube"), -1));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_1_1"), primary.intValue()));
        }).setInfo("Aperture", "Portal", "Designed to be used on the 1500 Megawatt Aperture Science Heavy Duty Super-Colliding Super Button");
        IPToolShaders.addProjectorShader("cube1", Rarity.EPIC, -39250, -16777216, -1, false, true, (primary, secondary, background, layers) -> {
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_cube"), -1));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_1_1"), primary.intValue()));
        }).setInfo("Aperture", "Portal", "Can not speak");
    }

    public static ShaderRegistry.ShaderRegistryEntry addProjectorShader(String name, Rarity rarity, int colorPrimary, int colorSecondary, int colorBackground, boolean loot, boolean bags) {
        return IPToolShaders.addProjectorShader(name, rarity, colorPrimary, colorSecondary, colorBackground, loot, bags, (primary, secondary, background, layers) -> {
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_0_0"), 0xFF000000 | primary));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_0_1"), 0xFF000000 | secondary));
            layers.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_0_2"), 0xFF000000 | background));
        });
    }

    private static ShaderRegistry.ShaderRegistryEntry addProjectorShader(String name, Rarity rarity, int colorPrimary, int colorSecondary, int colorBackground, boolean loot, boolean bags, LayerAdder<Integer, Integer, Integer, List<ShaderLayer>> extraLayers) {
        ResourceLocation rlName = ResourceUtils.ip(name);
        ShaderRegistry.registerShader_Item((ResourceLocation)rlName, (Rarity)rarity, (int)colorBackground, (int)colorPrimary, (int)colorSecondary);
        ArrayList<ShaderLayer> list = new ArrayList<ShaderLayer>();
        extraLayers.accept(colorPrimary, colorSecondary, colorBackground, list);
        list.add(new ShaderLayer(ResourceUtils.ip("projectors/shaders/projector_uncolored"), -1));
        ShaderCaseProjector shader = new ShaderCaseProjector((ShaderLayer[])list.toArray(ShaderLayer[]::new));
        return IPToolShaders.registerCase(rlName, shader, rarity, colorPrimary, colorSecondary, colorBackground, loot, bags);
    }

    private static <S extends ShaderCase> ShaderRegistry.ShaderRegistryEntry registerCase(ResourceLocation name, S shader, Rarity rarity, int colorPrimary, int colorSecondary, int colorBackground, boolean loot, boolean bags) {
        ShaderRegistry.registerShaderCase((ResourceLocation)name, shader, (Rarity)rarity);
        for (ShaderRegistry.IShaderRegistryMethod method : ShaderRegistry.shaderRegistrationMethods) {
            method.apply(name, "0", rarity, colorBackground, colorPrimary, colorSecondary, -1, null, -1);
        }
        return ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(name)).setCrateLoot(loot).setBagLoot(bags).setReplicationCost(() -> new IngredientWithSize(Ingredient.m_204132_((TagKey)ShaderRegistry.defaultReplicationCost), 10 - (Integer)ShaderRegistry.rarityWeightMap.get(rarity)));
    }

    @FunctionalInterface
    private static interface LayerAdder<P, S, B, L> {
        public void accept(P var1, S var2, B var3, L var4);
    }
}

