/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistrationBuilder;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockItem;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.component.MultiblockGui;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPMultiblockBase;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class IPRegisters {
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersivepetroleum");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immersivepetroleum");
    private static final DeferredRegister<Fluid> FLUID_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersivepetroleum");
    private static final DeferredRegister<BlockEntityType<?>> TE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"immersivepetroleum");
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"immersivepetroleum");
    public static final DeferredRegister<MenuType<?>> MENU_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"immersivepetroleum");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"immersivepetroleum");
    private static final DeferredRegister<MobEffect> MOB_EFFECT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"immersivepetroleum");
    private static final DeferredRegister<SoundEvent> SOUND_EVENT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"immersivepetroleum");
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"immersivepetroleum");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"immersivepetroleum");
    public static final DeferredRegister<FluidType> FLUID_TYPE = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"immersivepetroleum");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"immersivepetroleum");
    public static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"immersivepetroleum");
    private static final List<Consumer<IEventBus>> MOD_BUS_CALLBACKS = new ArrayList<Consumer<IEventBus>>();

    public static void addRegistersToEventBus(IEventBus eventBus) {
        FLUID_REGISTER.register(eventBus);
        BLOCK_REGISTER.register(eventBus);
        ITEM_REGISTER.register(eventBus);
        TE_REGISTER.register(eventBus);
        ENTITY_REGISTER.register(eventBus);
        MENU_REGISTER.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
        MOB_EFFECT.register(eventBus);
        SOUND_EVENT.register(eventBus);
        PARTICLE_TYPE.register(eventBus);
        ENTITY_TYPE.register(eventBus);
        FLUID_TYPE.register(eventBus);
        CREATIVE_TABS.register(eventBus);
        FEATURE_REGISTER.register(eventBus);
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMetalMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure) {
        return IPRegisters.registerMetalMultiblock(name, logic, structure, null);
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMetalMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure, @Nullable Consumer<MultiblockBuilder<S>> extras) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60999_().m_60971_((state, blockReader, pos) -> false).m_60955_().m_60988_().m_278166_(PushReaction.BLOCK);
        return IPRegisters.registerMultiblock(name, logic, structure, extras, prop);
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure, @Nullable Consumer<MultiblockBuilder<S>> extras, BlockBehaviour.Properties prop) {
        MultiblockBuilder builder = (MultiblockBuilder)((MultiblockBuilder)((MultiblockBuilder)new MultiblockBuilder<S>(logic, name).structure(structure)).defaultBEs(TE_REGISTER)).customBlock(BLOCK_REGISTER, ITEM_REGISTER, mb -> new IPMultiblockBase(prop, mb), MultiblockItem::new);
        if (extras != null) {
            extras.accept(builder);
        }
        return builder.build();
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockConstructor) {
        return IPRegisters.registerBlock(name, blockConstructor, null);
    }

    public static <T extends Block> RegistryObject<T> registerMultiblockBlock(String name, Supplier<T> blockConstructor) {
        return IPRegisters.registerBlock(name, blockConstructor, block -> new BlockItem(block, new Item.Properties()));
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockConstructor, @Nullable Function<T, ? extends BlockItem> blockItem) {
        RegistryObject block = BLOCK_REGISTER.register(name, blockConstructor);
        if (blockItem != null) {
            IPRegisters.registerItem(name, () -> (BlockItem)blockItem.apply((Block)block.get()));
        }
        return block;
    }

    public static <T extends IPBlockBase> RegistryObject<T> registerIPBlock(String name, Supplier<T> blockConstructor) {
        RegistryObject block = BLOCK_REGISTER.register(name, blockConstructor);
        IPRegisters.registerItem(name, () -> ((IPBlockBase)block.get()).blockItemSupplier().get());
        return block;
    }

    public static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> itemConstructor) {
        return ITEM_REGISTER.register(name, itemConstructor);
    }

    public static <T extends Fluid> RegistryObject<T> registerFluid(String name, Supplier<T> fluidConstructor) {
        return FLUID_REGISTER.register(name, fluidConstructor);
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerTE(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> valid) {
        return TE_REGISTER.register(name, () -> new BlockEntityType(factory, (Set)ImmutableSet.of((Object)((Block)valid.get())), null));
    }

    public static <T extends BlockEntity> MultiblockBEType<T> registerMultiblockTE(String name, MultiblockBEType.BEWithTypeConstructor<T> factory, Supplier<? extends Block> valid) {
        return new MultiblockBEType(name, TE_REGISTER, factory, valid, state -> state.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE) && (Boolean)state.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE) == false);
    }

    public static <T extends EntityType<?>> RegistryObject<T> registerEntity(String name, Supplier<T> entityConstructor) {
        return ENTITY_REGISTER.register(name, entityConstructor);
    }

    public static <T extends RecipeSerializer<?>> RegistryObject<T> registerSerializer(String name, Supplier<T> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }

    public static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenu(String name, Supplier<MenuType<T>> factory) {
        return MENU_REGISTER.register(name, factory);
    }

    public static <T extends IPEffects.IPEffect> RegistryObject<T> registerMobEffect(String name, Supplier<T> constructor) {
        return MOB_EFFECT.register(name, constructor);
    }

    public static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENT.register(name, () -> SoundEvent.m_262824_((ResourceLocation)ResourceUtils.ip(name)));
    }

    public static <PType extends ParticleType<?>> RegistryObject<PType> registerParticleType(String name, Supplier<PType> particleType) {
        return PARTICLE_TYPE.register(name, particleType);
    }

    public static <EType extends EntityType<?>> RegistryObject<EType> registerEntityType(String name, Function<ResourceLocation, EType> entityType) {
        return ENTITY_TYPE.register(name, () -> (EntityType)entityType.apply(ResourceUtils.ip(name)));
    }

    public static RegistryObject<CreativeModeTab> registerCreativeTab(String name, Supplier<CreativeModeTab> tab) {
        return CREATIVE_TABS.register(name, tab);
    }

    private IPRegisters() {
    }

    protected static class MultiblockBuilder<S extends IMultiblockState>
    extends MultiblockRegistrationBuilder<S, MultiblockBuilder<S>> {
        public MultiblockBuilder(IMultiblockLogic<S> logic, String name) {
            super(logic, ResourceUtils.ip(name));
        }

        public MultiblockBuilder<S> redstone(IMultiblockComponent.StateWrapper<S, RedstoneControl.RSState> getState, BlockPos ... positions) {
            this.redstoneAware();
            return (MultiblockBuilder)this.selfWrappingComponent((IMultiblockComponent)new RedstoneControl(getState, positions));
        }

        public MultiblockBuilder<S> comparator(ComparatorManager<S> comparator) {
            this.withComparator();
            return (MultiblockBuilder)super.selfWrappingComponent(comparator);
        }

        public MultiblockBuilder<S> gui(IEMenuTypes.MultiblockContainer<S, ?> menu) {
            return (MultiblockBuilder)this.component((IMultiblockComponent)new MultiblockGui(menu));
        }

        protected MultiblockBuilder<S> self() {
            return this;
        }
    }
}

