/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.model.ModelMotorboat;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MotorboatRenderer
extends EntityRenderer<MotorboatEntity> {
    private static final ResourceLocation texture = ResourceUtils.ip("textures/models/boat_motor.png");
    private static final ResourceLocation textureArmor = ResourceUtils.ip("textures/models/boat_motor_armor.png");
    protected final ModelMotorboat modelBoat = new ModelMotorboat();

    public MotorboatRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.f_114477_ = 0.8f;
    }

    public void render(@Nonnull MotorboatEntity entity, float entityYaw, float partialTicks, PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int packedLight) {
        float pr;
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.375, 0.0);
        this.setupRotation(entity, entityYaw, partialTicks, matrix);
        this.modelBoat.setupAnim(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (entity.m_20077_()) {
            matrix.m_252880_(0.0f, -0.24375f, 0.0f);
        }
        if (!entity.isEmergency()) {
            if (entity.isForwardDown()) {
                entity.propellerXRotSpeed = entity.propellerXRotSpeed + (entity.isBoosting ? 0.2f : 0.1f);
            }
            if (entity.isBackDown()) {
                entity.propellerXRotSpeed -= 0.2f;
            }
            entity.propellerXRot += entity.propellerXRotSpeed;
            entity.propellerXRot %= 360.0f;
        }
        entity.propellerXRotSpeed *= 0.985f;
        if (entity.propellerXRotSpeed != 0.0f && entity.propellerXRotSpeed >= -0.001f && entity.propellerXRotSpeed <= 0.001f) {
            entity.propellerXRotSpeed = 0.0f;
        }
        this.modelBoat.propeller.f_104203_ = entity.propellerXRot * ((float)Math.PI / 180);
        float f = pr = entity.isEmergency() ? 0.0f : entity.propellerYRotation;
        if (entity.isLeftInDown() && !entity.isRightInDown() && pr > -1.0f) {
            pr -= 0.1f * partialTicks;
        }
        if (entity.isRightInDown() && !entity.isLeftInDown() && pr < 1.0f) {
            pr += 0.1f * partialTicks;
        }
        if (!entity.isLeftInDown() && !entity.isRightInDown()) {
            pr = (float)((double)pr * Math.pow(0.7, partialTicks));
        }
        this.modelBoat.propellerAssembly.f_104204_ = (float)Math.toRadians(pr * 15.0f);
        this.modelBoat.m_7695_(matrix, bufferIn.m_6299_(this.modelBoat.m_103119_(this.getEntityTexture(entity.isFireproof))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.hasPaddles) {
            VertexConsumer vbuilder_normal = bufferIn.m_6299_(this.modelBoat.m_103119_(texture));
            this.modelBoat.paddles[0].m_104301_(matrix, vbuilder_normal, packedLight, OverlayTexture.f_118083_);
            this.modelBoat.paddles[1].m_104301_(matrix, vbuilder_normal, packedLight, OverlayTexture.f_118083_);
        }
        VertexConsumer vbuilder_armored = bufferIn.m_6299_(this.modelBoat.m_103119_(textureArmor));
        if (entity.hasIcebreaker) {
            this.modelBoat.icebreak.m_104301_(matrix, vbuilder_armored, packedLight, OverlayTexture.f_118083_);
        }
        if (entity.hasRudders) {
            this.modelBoat.ruddersBase.m_104301_(matrix, vbuilder_armored, packedLight, OverlayTexture.f_118083_);
            float pr2 = entity.propellerYRotation;
            if (entity.isLeftInDown() && !entity.isRightInDown() && pr2 > -1.0f) {
                pr2 -= 0.1f * partialTicks;
            }
            if (entity.isRightInDown() && !entity.isLeftInDown() && pr2 < 1.0f) {
                pr2 += 0.1f * partialTicks;
            }
            if (!entity.isLeftInDown() && !entity.isRightInDown()) {
                pr2 = (float)((double)pr2 * Math.pow(0.7f, partialTicks));
            }
            this.modelBoat.rudder1.f_104204_ = (float)Math.toRadians(pr2 * 20.0f);
            this.modelBoat.rudder2.f_104204_ = (float)Math.toRadians(pr2 * 20.0f);
            this.modelBoat.rudder1.m_104301_(matrix, vbuilder_armored, packedLight, OverlayTexture.f_118083_);
            this.modelBoat.rudder2.m_104301_(matrix, vbuilder_armored, packedLight, OverlayTexture.f_118083_);
        }
        if (entity.hasTank) {
            this.modelBoat.tank.m_104301_(matrix, vbuilder_armored, packedLight, OverlayTexture.f_118083_);
        }
        if (!entity.m_5842_()) {
            VertexConsumer vbuilder_mask = bufferIn.m_6299_(RenderType.m_110478_());
            this.modelBoat.noWaterRenderer().m_104301_(matrix, vbuilder_mask, packedLight, OverlayTexture.f_118083_);
        }
        matrix.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrix, bufferIn, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull MotorboatEntity entity) {
        return texture;
    }

    public ResourceLocation getEntityTexture(boolean armored) {
        return armored ? textureArmor : texture;
    }

    public void setupRotation(MotorboatEntity boat, float entityYaw, float partialTicks, PoseStack matrix) {
        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float f1 = boat.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrix.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
        }
        if (boat.isBoosting) {
            matrix.m_252781_(Axis.f_252529_.m_252977_(3.0f));
        }
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_252781_(Axis.f_252436_.m_252977_(90.0f));
    }
}

