/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelData;

public class DerrickRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<DerrickLogic.State>> {
    public static final ResourceLocation DRILL = ResourceUtils.ip("multiblock/dyn/derrick_drill");
    public static final ResourceLocation PIPE_SEGMENT = ResourceUtils.ip("multiblock/dyn/derrick_pipe_segment");
    public static final ResourceLocation PIPE_TOP = ResourceUtils.ip("multiblock/dyn/derrick_pipe_top");

    public boolean shouldRenderOffScreen(@Nonnull MultiblockBlockEntityMaster<DerrickLogic.State> te) {
        return true;
    }

    public void render(MultiblockBlockEntityMaster<DerrickLogic.State> te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.m_58901_() || !te.m_58904_().m_46805_(te.m_58899_())) {
            return;
        }
        matrix.m_85836_();
        float rot = (float)((DerrickLogic.State)te.getHelper().getState()).rotation + (((DerrickLogic.State)te.getHelper().getState()).drilling ? 10.0f * partialTicks : 0.0f);
        matrix.m_85837_(0.5, 1.0, 0.5);
        matrix.m_252781_(Axis.f_252436_.m_252977_(rot));
        this.renderObj(DRILL, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
        float pipeHeight = -(rot / 360.0f);
        for (int i = 0; i < 6; ++i) {
            float y = pipeHeight + (float)i;
            if (!((double)y > -1.0)) continue;
            matrix.m_85836_();
            matrix.m_85837_(0.0, (double)y + 0.75, 0.0);
            this.renderObj(i < 5 ? PIPE_SEGMENT : PIPE_TOP, bufferIn, matrix, combinedLightIn, combinedOverlayIn);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    private void renderObj(ResourceLocation modelRL, @Nonnull MultiBufferSource bufferIn, @Nonnull PoseStack matrix, int light, int overlay) {
        List quads = MCUtil.getModel(modelRL).getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        PoseStack.Pose last = matrix.m_85850_();
        VertexConsumer solid = bufferIn.m_6299_(RenderType.m_110451_());
        for (BakedQuad quad : quads) {
            solid.m_85987_(last, quad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

