/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import flaxbeard.immersivepetroleum.common.network.MessageSurveyResultDetails;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class SeismicSurveyScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/seismicsurvey_gui.png");
    private static final ResourceLocation OVERLAY_TEXTURE = ResourceUtils.ip("textures/gui/seismicsurvey_overlay.png");
    private static final int X_SIZE = 154;
    private static final int Y_SIZE = 154;
    private int guiLeft;
    private int guiTop;
    private int surveyLeft;
    private int surveyTop;
    private int surveyRight;
    private int surveyBottom;
    private final int gridScale = 2;
    private float hoverSquareScale;
    boolean requestSent = false;
    private BitSet bitSet;
    @Nonnull
    public final SurveyScan scan;

    public SeismicSurveyScreen(Level level, @Nonnull SurveyScan scan) {
        super((Component)Component.m_237113_((String)"seismicsurveyscreen"));
        this.scan = Objects.requireNonNull(scan);
    }

    protected void m_7856_() {
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.hoverSquareScale = 0.5f - (float)(this.f_96541_.m_91268_().m_85449_() / 10.0);
        this.guiLeft = (this.f_96543_ - 154) / this.gridScale;
        this.guiTop = (this.f_96544_ - 154) / this.gridScale;
        this.surveyLeft = this.guiLeft + 12;
        this.surveyTop = this.guiTop + 12;
        this.surveyRight = this.surveyLeft + 65 * this.gridScale;
        this.surveyBottom = this.surveyTop + 65 * this.gridScale;
        this.requestSent = true;
        MessageSurveyResultDetails.sendRequestToServer(this.scan);
    }

    public void setBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    private int getScanData(int x, int y) {
        if (x < 0 || x >= 65 || y < 0 || y >= 65) {
            return -1;
        }
        int index = y * 65 + x;
        return this.scan.getData()[index] & 0xFF;
    }

    private boolean hasReservoirAt(int x, int y) {
        if (this.bitSet == null) {
            return false;
        }
        if (x < 0 || x >= 65 || y < 0 || y >= 65) {
            return false;
        }
        int index = Mth.m_14045_((int)(y * 65 + x), (int)0, (int)4225);
        return this.bitSet.get(index);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.background(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        DynamicTextureWrapper wrapper = DynamicTextureWrapper.getOrCreate(65, 65, this.scan);
        if (wrapper == null) {
            return;
        }
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        int scanX = 64 - (mouseX - this.surveyLeft) / this.gridScale;
        int scanY = 64 - (mouseY - this.surveyTop) / this.gridScale;
        int scanXCentered = scanX - 32;
        int scanYCentered = scanY - 32;
        if (mouseX >= this.guiLeft + 70 && mouseX <= this.guiLeft + 83 && mouseY >= this.guiTop + 4 && mouseY <= this.guiTop + 10) {
            tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.dirs.north").m_130940_(ChatFormatting.AQUA));
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.surveyLeft, (float)this.surveyTop, 0.0f);
        this.renderScanTexture(guiGraphics, wrapper);
        if (mouseX >= this.surveyLeft && mouseX < this.surveyRight && mouseY >= this.surveyTop && mouseY < this.surveyBottom) {
            int data = this.getScanData(scanX, scanY);
            if (data != -1) {
                this.renderCursorBox(guiGraphics, mouseX, mouseY, 0xFF000000 | (data < 127 ? 0xFFFFFF : 0));
            }
            int worldX = this.scan.getX() - scanXCentered;
            int worldZ = this.scan.getZ() - scanYCentered;
            tooltip.add(Component.m_237110_((String)"gui.immersivepetroleum.seismicsurvey.worldcoords", (Object[])new Object[]{worldX, worldZ}));
            if (scanXCentered == 0 && scanYCentered == 0) {
                tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.seismicsurvey.takenhere").m_130940_(ChatFormatting.GRAY));
            }
            if (this.bitSet != null) {
                if (this.hasReservoirAt(scanX, scanY)) {
                    tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.seismicsurvey.possibility").m_130940_(ChatFormatting.DARK_GRAY));
                }
            } else if (this.requestSent) {
                tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.seismicsurvey.awaitingresponse").m_130940_(ChatFormatting.GRAY));
            }
        }
        guiGraphics.m_280168_().m_85849_();
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    private void renderCursorBox(GuiGraphics guiGraphics, int mouseX, int mouseY, int color) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        guiGraphics.m_280168_().m_85836_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        PoseStack poseStack2 = guiGraphics.m_280168_();
        float f = mouseX - this.surveyLeft;
        Objects.requireNonNull(this);
        float f2 = f / (2.0f * 1.0f);
        float f3 = mouseY - this.surveyTop;
        Objects.requireNonNull(this);
        poseStack2.m_252880_(f2, f3 / (2.0f * 1.0f), 0.0f);
        VertexConsumer builder = buffer.m_6299_(IPRenderTypes.TRANSLUCENT_POSITION_COLOR);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        float s = this.hoverSquareScale;
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 0.0f, s, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, s, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, 0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 0.0f, 1.0f - s, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 0.0f, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, 1.0f - s, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 0.0f, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, s, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, s, 0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f - s, 0.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f - s, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, 1.0f, 0.0f).m_193479_(color).m_5752_();
        builder.m_252986_(mat, 1.0f, 0.0f, 0.0f).m_193479_(color).m_5752_();
        guiGraphics.m_280168_().m_85849_();
        buffer.m_109911_();
    }

    private void renderScanTexture(GuiGraphics guiGraphics, DynamicTextureWrapper wrapper) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        guiGraphics.m_280168_().m_85836_();
        PoseStack poseStack = guiGraphics.m_280168_();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        VertexConsumer builder = buffer.m_6299_(wrapper.renderType);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        int a = wrapper.width;
        int b = wrapper.height;
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_193479_(-1).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, 0.0f, (float)b, 0.0f).m_193479_(-1).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, (float)a, (float)b, 0.0f).m_193479_(-1).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, (float)a, 0.0f, 0.0f).m_193479_(-1).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)OVERLAY_TEXTURE));
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_193479_(-1).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, 0.0f, (float)b, 0.0f).m_193479_(-1).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, (float)a, (float)b, 0.0f).m_193479_(-1).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(mat, (float)a, 0.0f, 0.0f).m_193479_(-1).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        guiGraphics.m_280168_().m_85849_();
        buffer.m_109911_();
    }

    private void background(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280218_(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, 154, 154);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

