/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.client.gui.elements.GuiReactiveList;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.Lazy;

public class ProjectorScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/projector.png");
    static final Component GUI_CONFIRM = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.confirm");
    static final Component GUI_CANCEL = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.cancel");
    static final Component GUI_MIRROR = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.mirror");
    static final Component GUI_ROTATE_CW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rcw");
    static final Component GUI_ROTATE_CCW = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.rccw");
    static final Component GUI_UP = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.up");
    static final Component GUI_DOWN = ProjectorScreen.translation("gui.immersivepetroleum.projector.button.down");
    static final Component GUI_SEARCH = ProjectorScreen.translation("gui.immersivepetroleum.projector.search");
    private final int xSize = 256;
    private final int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private Lazy<List<MultiblockHandler.IMultiblock>> multiblocks;
    private Level templateWorld;
    private MultiblockHandler.IMultiblock multiblock;
    private GuiReactiveList list;
    private String[] listEntries;
    private SearchField searchField;
    Settings settings;
    InteractionHand hand;
    float rotation = 0.0f;
    float move = 0.0f;

    public ProjectorScreen(InteractionHand hand, ItemStack projector) {
        super((Component)Component.m_237113_((String)"projector"));
        this.settings = new Settings(projector);
        this.hand = hand;
        this.multiblocks = Lazy.of(MultiblockHandler::getMultiblocks);
        if (this.settings.getMultiblock() != null) {
            this.move = 20.0f;
        }
    }

    protected void m_7856_() {
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.searchField = (SearchField)this.m_142416_((GuiEventListener)new SearchField(this.f_96547_, this.guiLeft + 25, this.guiTop + 13));
        this.m_142416_((GuiEventListener)new ConfirmButton(this.guiLeft + 115, this.guiTop + 10, but -> {
            this.settings.setMode(Settings.Mode.PROJECTION);
            ItemStack held = MCUtil.getPlayer().m_21120_(this.hand);
            this.settings.applyTo(held);
            this.settings.sendPacketToServer(this.hand);
            MCUtil.getScreen().m_7379_();
            MCUtil.getPlayer().m_5661_(this.settings.getMode().getTranslated(), true);
        }));
        this.m_142416_((GuiEventListener)new CancelButton(this.guiLeft + 115, this.guiTop + 34, but -> MCUtil.getScreen().m_7379_()));
        this.m_142416_((GuiEventListener)new MirrorButton(this.guiLeft + 115, this.guiTop + 58, this.settings, but -> this.settings.flip()));
        this.m_142416_((GuiEventListener)new RotateLeftButton(this.guiLeft + 115, this.guiTop + 106, but -> this.settings.rotateCCW()));
        this.m_142416_((GuiEventListener)new RotateRightButton(this.guiLeft + 115, this.guiTop + 130, but -> this.settings.rotateCW()));
        this.updatelist();
    }

    private void listaction(Button button) {
        GuiReactiveList l = (GuiReactiveList)button;
        if (l.selectedOption >= 0 && l.selectedOption < this.listEntries.length) {
            String str = this.listEntries[l.selectedOption];
            MultiblockHandler.IMultiblock mb = (MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(Integer.parseInt(str));
            this.settings.setMultiblock(mb);
        }
    }

    private void updatelist() {
        boolean exists = this.f_169369_.contains((Object)this.list);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ((List)this.multiblocks.get()).size(); ++i) {
            MultiblockHandler.IMultiblock mb = (MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(i);
            if (mb.getUniqueName().toString().equals("immersiveengineering:feedthrough")) continue;
            list.add(Integer.toString(i));
        }
        list.sort((a, b) -> {
            String nameA = this.getMBName((String)a);
            String nameB = this.getMBName((String)b);
            return nameA.compareToIgnoreCase(nameB);
        });
        list.removeIf(str -> {
            String name = this.getMBName((String)str);
            return !name.toLowerCase().contains(this.searchField.m_94155_().toLowerCase());
        });
        this.listEntries = list.toArray(new String[0]);
        GuiReactiveList guilist = new GuiReactiveList(this, this.guiLeft + 15, this.guiTop + 29, 89, 127, this::listaction, this.listEntries);
        guilist.setPadding(1, 1, 1, 1);
        guilist.setTextColor(0);
        guilist.setTextHoverColor(0x7F7FFF);
        guilist.setTranslationFunc(this::getMBName);
        if (!exists) {
            this.list = (GuiReactiveList)this.m_142416_((GuiEventListener)guilist);
            return;
        }
        this.m_169411_((GuiEventListener)this.list);
        this.list = guilist;
        this.m_142416_((GuiEventListener)this.list);
    }

    private String getMBName(String str) {
        return this.getMBName(Integer.parseInt(str));
    }

    private String getMBName(int index) {
        MultiblockHandler.IMultiblock mb = (MultiblockHandler.IMultiblock)((List)this.multiblocks.get()).get(index);
        return mb.getDisplayName().getString();
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MultiblockHandler.IMultiblock mb;
        if (this.settings.getMultiblock() != null) {
            mb = this.settings.getMultiblock();
            int x = this.guiLeft + 28;
            int y = this.guiTop - (int)(15.0f * (this.move / 20.0f));
            if (this.move < 20.0f) {
                this.move = (float)((double)this.move + 1.5 * (double)partialTicks);
            }
            guiGraphics.m_280218_(GUI_TEXTURE, x, y, 0, 166, 200, 13);
            Component text = mb.getDisplayName();
            FormattedCharSequence re = text.m_7532_();
            guiGraphics.m_280649_(this.f_96547_, re, (x += 100) - this.f_96547_.m_92724_(re) / 2, y += 3, 0x3F3F3F, false);
        }
        this.background(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderDirectionDisplay(guiGraphics, mouseX, mouseY);
        if (this.settings.getMultiblock() != null) {
            mb = this.settings.getMultiblock();
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            try {
                this.rotation += 1.5f * partialTicks;
                Vec3i size = mb.getSize(null);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(this.guiLeft + 190), (float)(this.guiTop + 80), 64.0f);
                guiGraphics.m_280168_().m_85841_(mb.getManualScale(), -mb.getManualScale(), 1.0f);
                guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(25.0f));
                guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(45.0f - this.rotation));
                guiGraphics.m_280168_().m_252880_((float)size.m_123341_() / -2.0f, (float)size.m_123342_() / -2.0f, (float)size.m_123343_() / -2.0f);
                ClientMultiblocks.MultiblockManualData mbClientData = ClientMultiblocks.get((MultiblockHandler.IMultiblock)mb);
                boolean tempDisable = true;
                if (tempDisable && mbClientData.canRenderFormedStructure()) {
                    guiGraphics.m_280168_().m_85836_();
                    mbClientData.renderFormedStructure(guiGraphics.m_280168_(), IPRenderTypes.disableLighting((MultiBufferSource)buffer));
                    guiGraphics.m_280168_().m_85849_();
                } else {
                    if (this.templateWorld == null || !this.multiblock.getUniqueName().equals((Object)mb.getUniqueName())) {
                        this.templateWorld = ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.getValue()).makeWorld(mb.getStructure((Level)this.getMinecraft().f_91073_), pos -> true, this.getMinecraft().f_91073_.m_9598_());
                        this.multiblock = mb;
                    }
                    BlockRenderDispatcher blockRender = Minecraft.m_91087_().m_91289_();
                    List infos = mb.getStructure((Level)this.getMinecraft().f_91073_);
                    for (StructureTemplate.StructureBlockInfo info : infos) {
                        if (info.f_74676_().m_60713_(Blocks.f_50016_)) continue;
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_252880_((float)info.f_74675_().m_123341_(), (float)info.f_74675_().m_123342_(), (float)info.f_74675_().m_123343_());
                        ModelData modelData = ModelData.EMPTY;
                        BlockEntity te = this.templateWorld.m_7702_(info.f_74675_());
                        if (te != null) {
                            modelData = te.getModelData();
                        }
                        blockRender.renderSingleBlock(info.f_74676_(), guiGraphics.m_280168_(), IPRenderTypes.disableLighting((MultiBufferSource)buffer), 0xF000F0, OverlayTexture.f_118083_, modelData, null);
                        guiGraphics.m_280168_().m_85849_();
                    }
                }
                guiGraphics.m_280168_().m_85849_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            buffer.m_109911_();
        }
    }

    private void renderDirectionDisplay(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = this.guiLeft + 115;
        int y = this.guiTop + 82;
        Direction dir = Direction.m_122407_((int)this.settings.getRotation().ordinal());
        MutableComponent dirText = Component.m_237113_((String)dir.toString().toUpperCase().substring(0, 1));
        guiGraphics.m_280653_(this.f_96547_, (Component)dirText, x + 5, y + 1, -1);
        if (mouseX > x && mouseX < x + 10 && mouseY > y && mouseY < y + 10) {
            MutableComponent rotText = Component.m_237115_((String)("desc.immersivepetroleum.info.projector.rotated." + dir));
            guiGraphics.m_280557_(this.f_96547_, (Component)rotText, mouseX, mouseY);
        }
    }

    private void background(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280218_(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers) || this.searchField.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers) || this.searchField.m_5534_(codePoint, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    static Component translation(String key) {
        return Component.m_237115_((String)key);
    }

    class SearchField
    extends EditBox {
        public SearchField(Font font, int x, int y) {
            super(font, x, y, 60, 14, GUI_SEARCH);
            this.m_94199_(50);
            this.m_94182_(false);
            this.m_94194_(true);
            this.m_94202_(0xFFFFFF);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            String s = this.m_94155_();
            if (super.m_7933_(keyCode, scanCode, modifiers)) {
                if (!Objects.equals(s, this.m_94155_())) {
                    ProjectorScreen.this.updatelist();
                }
                return true;
            }
            return this.m_93696_() && this.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char codePoint, int modifiers) {
            if (!this.m_93696_()) {
                this.m_93692_(true);
            }
            String s = this.m_94155_();
            if (super.m_5534_(codePoint, modifiers)) {
                if (!Objects.equals(s, this.m_94155_())) {
                    ProjectorScreen.this.updatelist();
                }
                return true;
            }
            return false;
        }
    }

    class ConfirmButton
    extends ControlButton {
        public ConfirmButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 0, 179, action, GUI_CONFIRM);
        }
    }

    class CancelButton
    extends ControlButton {
        public CancelButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 10, 179, action, GUI_CANCEL);
        }
    }

    class MirrorButton
    extends ControlButton {
        Settings settings;

        public MirrorButton(int x, int y, Settings settings, Consumer<PButton> action) {
            super(x, y, 10, 10, 20, 179, action, GUI_MIRROR);
            this.settings = settings;
        }

        @Override
        public void m_87963_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93622_) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + 1, this.m_252754_() + this.iconSize, this.m_252907_() + this.iconSize - 1, -1350598657);
            }
            if (this.settings.isMirrored()) {
                guiGraphics.m_280218_(GUI_TEXTURE, this.m_252754_(), this.m_252907_(), this.xOverlay, this.yOverlay + this.iconSize, this.iconSize, this.iconSize);
            } else {
                guiGraphics.m_280218_(GUI_TEXTURE, this.m_252754_(), this.m_252907_(), this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
            }
        }
    }

    class RotateLeftButton
    extends ControlButton {
        public RotateLeftButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 30, 179, action, GUI_ROTATE_CCW);
        }
    }

    class RotateRightButton
    extends ControlButton {
        public RotateRightButton(int x, int y, Consumer<PButton> action) {
            super(x, y, 10, 10, 40, 179, action, GUI_ROTATE_CW);
        }
    }

    static class PButton
    extends AbstractButton {
        protected boolean selected;
        protected final int xOverlay;
        protected final int yOverlay;
        protected int iconSize = 10;
        protected int bgStartX = 0;
        protected int bgStartY = 166;
        protected Consumer<PButton> action;

        public PButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.action = action;
            this.xOverlay = overlayX;
            this.yOverlay = overlayY;
        }

        public void m_87963_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93622_) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + 1, this.m_252754_() + this.iconSize, this.m_252907_() + this.iconSize - 1, -1350598657);
            }
            guiGraphics.m_280218_(GUI_TEXTURE, this.m_252754_(), this.m_252907_(), this.xOverlay, this.yOverlay, this.iconSize, this.iconSize);
        }

        public void m_5691_() {
            this.action.accept(this);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean isSelected) {
            this.selected = isSelected;
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    class ControlButton
    extends PButton {
        Component hoverText;

        public ControlButton(int x, int y, int width, int height, int overlayX, int overlayY, Consumer<PButton> action, Component hoverText) {
            super(x, y, width, height, overlayX, overlayY, action);
            this.hoverText = hoverText;
        }
    }
}

