/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import flaxbeard.immersivepetroleum.client.gui.DerrickScreen;
import flaxbeard.immersivepetroleum.client.gui.elements.PipeConfig;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.gui.DerrickContainer;
import flaxbeard.immersivepetroleum.common.network.MessageDerrick;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DerrickSettingsScreen
extends Screen {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick_settings.png");
    private final int xSize = 158;
    private final int ySize = 176;
    private int guiLeft;
    private int guiTop;
    private PipeConfig pipeConfig;
    final DerrickScreen derrickScreen;

    public DerrickSettingsScreen(DerrickScreen derrickScreen) {
        super((Component)Component.m_237113_((String)"DerrickSettings"));
        this.derrickScreen = derrickScreen;
    }

    protected void m_7856_() {
        IMultiblockBE be;
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        BlockEntity tile = ((DerrickContainer)this.derrickScreen.m_6262_()).level.m_7702_(DerrickContainer.getPos((List)((DerrickContainer)this.derrickScreen.m_6262_()).pos.get()));
        if (tile instanceof IMultiblockBE && (be = (IMultiblockBE)tile).getHelper().getState() instanceof DerrickLogic.State) {
            this.pipeConfig = new PipeConfig((IMultiblockBEHelper<DerrickLogic.State>)be.getHelper().asType(IPContent.Multiblock.DERRICK), this.guiLeft + 10, this.guiTop + 10, 138, 138, 69, 69, 2);
            this.m_142416_((GuiEventListener)this.pipeConfig);
            MutableComponent set = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.set");
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)set, b -> MessageDerrick.sendToServer(be.getHelper().getContext().getLevel().getAbsoluteOrigin(), this.pipeConfig.getGrid())).m_252987_(this.guiLeft + this.xSize / 2 - 65, this.guiTop + this.ySize - 25, 40, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.set.desc"))).m_253136_());
            MutableComponent reset = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.reset");
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)reset, b -> this.pipeConfig.reset((IMultiblockBEHelper<DerrickLogic.State>)be.getHelper().asType(IPContent.Multiblock.DERRICK))).m_252987_(this.guiLeft + this.xSize / 2 - 20, this.guiTop + this.ySize - 25, 40, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.reset.desc"))).m_253136_());
            MutableComponent close = Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.close");
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)close, b -> this.m_7379_()).m_252987_(this.guiLeft + this.xSize / 2 + 25, this.guiTop + this.ySize - 25, 40, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.button.close.desc"))).m_253136_());
        }
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.background(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (mouseX >= this.pipeConfig.m_252754_() && mouseX < this.pipeConfig.m_252754_() + this.pipeConfig.m_5711_() && mouseY >= this.pipeConfig.m_252907_() && mouseY < this.pipeConfig.m_252907_() + this.pipeConfig.m_93694_()) {
            int i;
            IMultiblockBE be;
            int x = (mouseX - this.pipeConfig.m_252754_()) / this.pipeConfig.getGridScale();
            int y = (mouseY - this.pipeConfig.m_252907_()) / this.pipeConfig.getGridScale();
            int px = x - this.pipeConfig.getGrid().getWidth() / 2;
            int py = y - this.pipeConfig.getGrid().getHeight() / 2;
            if (px >= -2 && px <= 2 && py >= -2 && py <= 2) {
                tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.derrickishere"));
            } else {
                MutableComponent d = Component.m_237119_();
                if (py < 0) {
                    d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.north"));
                } else if (py > 0) {
                    d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.south"));
                }
                if (px != 0) {
                    if (py != 0) {
                        d.m_7220_((Component)Component.m_237113_((String)"-"));
                    }
                    if (px < 0) {
                        d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.west"));
                    } else if (px > 0) {
                        d.m_7220_((Component)Component.m_237115_((String)"gui.immersivepetroleum.dirs.east"));
                    }
                }
                tooltip.add(d.m_130940_(ChatFormatting.UNDERLINE));
            }
            BlockEntity tile = ((DerrickContainer)this.derrickScreen.m_6262_()).level.m_7702_(DerrickContainer.getPos((List)((DerrickContainer)this.derrickScreen.m_6262_()).pos.get()));
            if (tile instanceof IMultiblockBE && (be = (IMultiblockBE)tile).getHelper().getState() instanceof DerrickLogic.State) {
                ColumnPos tilePos = Utils.toColumnPos(be.getHelper().getPositionInMB());
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "X: %d \u00c2\u00a77(%d)", tilePos.f_140723_() + px, px)));
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "Z: %d \u00c2\u00a77(%d)", tilePos.f_140724_() + py, py)));
            }
            if ((i = this.pipeConfig.getGrid().get(x, y)) > 0) {
                switch (i) {
                    case 1: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.normal"));
                        break;
                    }
                    case 2: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated"));
                        break;
                    }
                    case 3: {
                        tooltip.add(Component.m_237115_((String)"gui.immersivepetroleum.derrick.settings.pipe.perforated_fixed"));
                    }
                }
            }
            int xa = this.pipeConfig.m_252754_() + x * this.pipeConfig.getGridScale();
            int ya = this.pipeConfig.m_252907_() + y * this.pipeConfig.getGridScale();
            guiGraphics.m_280509_(xa, ya, xa + this.pipeConfig.getGridScale(), ya + this.pipeConfig.getGridScale(), Integer.MAX_VALUE);
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280666_(this.f_96541_.f_91062_, tooltip, mouseX, mouseY);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.derrickScreen);
        this.pipeConfig.dispose();
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int width, int height) {
        PipeConfig oldGrid = this.pipeConfig;
        super.m_6574_(minecraft, width, height);
        this.pipeConfig.copyDataFrom(oldGrid);
        oldGrid.dispose();
    }

    private void background(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280218_(GUI_TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }
}

