/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import flaxbeard.immersivepetroleum.client.gui.DerrickSettingsScreen;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.DerrickLogic;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.gui.DerrickContainer;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class DerrickScreen
extends AbstractContainerScreen<DerrickContainer> {
    static final ResourceLocation GUI_TEXTURE = ResourceUtils.ip("textures/gui/derrick.png");
    static final int TEXT_COLOUR_NIXIETUBE = 0xFF9900;
    static final int TEXT_COLOUR_ERROR = 0xEF0000;
    Button cfgButton;
    private List<InfoArea> areas;

    public DerrickScreen(DerrickContainer inventorySlotsIn, Inventory inv, Component title) {
        super((AbstractContainerMenu)inventorySlotsIn, inv, title);
        this.f_97726_ = 200;
        this.f_97727_ = 164;
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.cfgButton = new Button.Builder((Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.msg.config"), button -> this.f_96541_.m_91152_((Screen)new DerrickSettingsScreen(this))).m_252987_(this.f_97735_ + 125, this.f_97736_ + 52, 50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cfgButton);
        this.areas = List.of(new FluidInfoArea((IFluidTank)((DerrickContainer)this.m_6262_()).tank, new Rect2i(this.f_97735_ + 11, this.f_97736_ + 16, 16, 47), 200, 0, 20, 51, GUI_TEXTURE), new EnergyInfoArea(this.f_97735_ + 185, this.f_97736_ + 19, ((DerrickContainer)this.m_6262_()).energy));
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        this.f_97731_ = this.f_97727_ - 40;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mx, my, partialTicks);
        this.m_280072_(guiGraphics, mx, my);
        ArrayList tooltip = new ArrayList();
        for (InfoArea area : this.areas) {
            area.fillTooltip(mx, my, tooltip);
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280677_(this.f_96541_.f_91062_, tooltip, Optional.empty(), mx, my);
        }
    }

    protected void m_280003_(@Nonnull GuiGraphics guiGraphics, int x, int y) {
        IMultiblockBE multiblockBE;
        Object object;
        if (DerrickContainer.getPos((List)((DerrickContainer)this.m_6262_()).pos.get()).m_123342_() <= 62) {
            this.drawInfoTextCenteredMultiLine(guiGraphics, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.water_table", (Object[])new Object[0]), 0xEF0000);
            return;
        }
        BlockEntity tile = ((DerrickContainer)this.m_6262_()).level.m_7702_(DerrickContainer.getPos((List)((DerrickContainer)this.m_6262_()).pos.get()));
        if (tile instanceof IMultiblockBE && (object = (multiblockBE = (IMultiblockBE)tile).getHelper().getContext().getState()) instanceof DerrickLogic.State) {
            DerrickLogic.State state = (DerrickLogic.State)object;
            IMultiblockLevel level = multiblockBE.getHelper().getContext().getLevel();
            IMultiblockContext ctx = multiblockBE.getHelper().asType(IPContent.Multiblock.DERRICK).getContext();
            WellTileEntity well = state.getWell(level, level.toAbsolute(IPContent.Multiblock.DERRICK.masterPosInMB()));
            if (well != null) {
                if (this.cfgButton.f_93623_ && well.wellPipeLength > 0) {
                    this.cfgButton.f_93623_ = false;
                    this.cfgButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.msg.set_in_stone")));
                }
                if (well.wellPipeLength < well.getMaxPipeLength()) {
                    if (!state.rsState.isEnabled(ctx)) {
                        this.drawInfoTextCentered(guiGraphics, (Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.msg.disabled"), 0, 0xEF0000);
                        return;
                    }
                    if (state.drilling) {
                        String str = String.format(Locale.ROOT, "(%d%%)", (int)((float)(100 * well.wellPipeLength) / (float)well.getMaxPipeLength()));
                        this.drawInfoTextCentered(guiGraphics, (Component)Component.m_237110_((String)"gui.immersivepetroleum.derrick.msg.drilling", (Object[])new Object[]{str}), 1);
                    } else if (well.pipes <= 0 && !((DerrickContainer)this.f_97732_).m_38853_(0).m_6657_()) {
                        this.drawInfoTextCentered(guiGraphics, (Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.msg.out_of_pipes"), 1, 0xEF0000);
                        return;
                    }
                    if (((DerrickContainer)this.m_6262_()).tank.isEmpty()) {
                        int realPipeLength = level.getAbsoluteOrigin().m_123342_() - 1 - well.m_58899_().m_123342_();
                        int concreteNeeded = 125 * (realPipeLength - well.wellPipeLength);
                        if (concreteNeeded > 0) {
                            this.drawInfoText(guiGraphics, (Component)Component.m_237110_((String)"gui.immersivepetroleum.derrick.msg.missing", (Object[])new Object[]{Utils.fDecimal(concreteNeeded) + "mB"}), 0, 0xEF0000);
                            this.drawInfoText(guiGraphics, ExternalModContent.IE.fluidConcrete(1).getDisplayName(), 1, 0xEF0000);
                            return;
                        }
                        int waterNeeded = 125 * (well.getMaxPipeLength() - well.wellPipeLength);
                        if (waterNeeded > 0) {
                            this.drawInfoText(guiGraphics, (Component)Component.m_237110_((String)"gui.immersivepetroleum.derrick.msg.missing", (Object[])new Object[]{Utils.fDecimal(waterNeeded) + "mB"}), 0, 0xEF0000);
                            this.drawInfoText(guiGraphics, new FluidStack((Fluid)Fluids.f_76193_, 1).getDisplayName(), 1, 0xEF0000);
                            return;
                        }
                    }
                    if (((DerrickContainer)this.m_6262_()).energy.getEnergyStored() < (Integer)IPServerConfig.EXTRACTION.derrick_consumption.get()) {
                        this.drawInfoTextCentered(guiGraphics, (Component)Component.m_237115_((String)"gui.immersivepetroleum.derrick.msg.not_enough_power"), 3, 0xEF0000);
                        return;
                    }
                } else if (state.spilling) {
                    this.drawInfoTextCenteredMultiLine(guiGraphics, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.safety_valve", (Object[])new Object[0]), 0xEF0000);
                } else {
                    this.drawInfoTextCenteredMultiLine(guiGraphics, I18n.m_118938_((String)"gui.immersivepetroleum.derrick.msg.completed", (Object[])new Object[0]), 0xFF9900);
                }
            }
        }
    }

    private void drawInfoText(GuiGraphics guiGraphics, Component text, int line) {
        this.drawInfoText(guiGraphics, text, line, 0xFF9900);
    }

    private void drawInfoText(GuiGraphics guiGraphics, Component text, int line, int color) {
        guiGraphics.m_280430_(this.f_96547_, text, 60, 10 + 9 * line, color);
    }

    private void drawInfoTextCentered(GuiGraphics guiGraphics, Component text, int line) {
        this.drawInfoTextCentered(guiGraphics, text, line, 0xFF9900);
    }

    private void drawInfoTextCentered(GuiGraphics guiGraphics, Component text, int line, int color) {
        int strWidth = this.f_96547_.m_92895_(text.getString());
        guiGraphics.m_280430_(this.f_96547_, text, (int)(118.5f - (float)strWidth / 2.0f), 10 + 9 * line, color);
    }

    private void drawInfoTextCenteredMultiLine(GuiGraphics guiGraphics, String text, int color) {
        String[] lines = text.split("<br>");
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            this.drawInfoTextCentered(guiGraphics, (Component)Component.m_237113_((String)(lines[i].length() > 25 ? lines[i].substring(0, 25) : lines[i])), i, color);
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mx, int my) {
        guiGraphics.m_280218_(GUI_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (InfoArea area : this.areas) {
            area.draw(guiGraphics);
        }
    }
}

