/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ItemOverlayUtils;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.client.LubricatorGhostRenderer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

public class ClientEventHandler {
    private static LubricatorGhostRenderer lubricatorGhostRenderer;

    @SubscribeEvent
    public void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            if (lubricatorGhostRenderer == null) {
                lubricatorGhostRenderer = new LubricatorGhostRenderer(Minecraft.m_91087_());
            }
            lubricatorGhostRenderer.render(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void reservoirDebuggingOverlayText(RenderGuiOverlayEvent.Post event) {
        if (ReservoirHandler.getGenerator() == null) {
            return;
        }
        LocalPlayer player = MCUtil.getPlayer();
        ItemStack main = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack off = player.m_21120_(InteractionHand.OFF_HAND);
        if (main != ItemStack.f_41583_ && main.m_41720_() == IPContent.DEBUGITEM.get() || off != ItemStack.f_41583_ && off.m_41720_() == IPContent.DEBUGITEM.get()) {
            if (DebugItem.getMode(main) != DebugItem.Modes.SEEDBASED_RESERVOIR && DebugItem.getMode(off) != DebugItem.Modes.SEEDBASED_RESERVOIR) {
                return;
            }
            ArrayList debugOut = new ArrayList();
            if (!debugOut.isEmpty()) {
                PoseStack matrix = event.getGuiGraphics().m_280168_();
                matrix.m_85836_();
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                for (int i = 0; i < debugOut.size(); ++i) {
                    int w = ClientUtils.font().m_92895_(((Component)debugOut.get(i)).getString());
                    Objects.requireNonNull(ClientUtils.font());
                    int yOff = i * (9 + 2);
                    matrix.m_85836_();
                    matrix.m_252880_(0.0f, 0.0f, 1.0f);
                    GuiHelper.drawColouredRect((int)1, (int)(1 + yOff), (int)(w + 1), (int)10, (int)-1358954496, (MultiBufferSource)buffer, (PoseStack)matrix);
                    buffer.m_109911_();
                    event.getGuiGraphics().m_280614_(ClientUtils.font(), (Component)debugOut.get(i), 2, 2 + yOff, -1, false);
                    matrix.m_85849_();
                }
                matrix.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public void renderInfoOverlays(RenderGuiOverlayEvent.Post event) {
        if (MCUtil.getPlayer() != null && event.getOverlay().id() == VanillaGuiOverlay.HOTBAR.id()) {
            MotorboatEntity motorboat;
            String[] text;
            EntityHitResult eHit;
            Entity entity;
            LocalPlayer player = MCUtil.getPlayer();
            HitResult result = MCUtil.getHitResult();
            if (result == null || result.m_6662_() != HitResult.Type.ENTITY) {
                return;
            }
            if (result instanceof EntityHitResult && (entity = (eHit = (EntityHitResult)result).m_82443_()) instanceof MotorboatEntity && (text = (motorboat = (MotorboatEntity)entity).getOverlayText((Player)player, result)) != null && text.length > 0) {
                Font font = ClientUtils.font();
                int col = 0xFFFFFF;
                for (int i = 0; i < text.length; ++i) {
                    if (text[i] == null) continue;
                    int fx = event.getWindow().m_85445_() / 2 + 8;
                    int n = event.getWindow().m_85446_() / 2 + 8;
                    Objects.requireNonNull(font);
                    int fy = n + i * 9;
                    event.getGuiGraphics().m_280488_(font, text[i], fx, fy, col);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (MCUtil.getPlayer() != null && event.getOverlay().id() == VanillaGuiOverlay.HOTBAR.id()) {
            LocalPlayer player = MCUtil.getPlayer();
            PoseStack matrix = event.getGuiGraphics().m_280168_();
            Entity entity = player.m_20202_();
            if (entity instanceof MotorboatEntity) {
                MotorboatEntity motorboat = (MotorboatEntity)entity;
                int offset = 0;
                boolean holdingDebugItem = false;
                for (InteractionHand hand : InteractionHand.values()) {
                    if (player.m_21120_(hand).m_41619_()) continue;
                    ItemStack equipped = player.m_21120_(hand);
                    if (equipped.m_41720_() instanceof DrillItem || equipped.m_41720_() instanceof ChemthrowerItem || equipped.m_41720_() instanceof BuzzsawItem) {
                        offset -= 85;
                    } else if (equipped.m_41720_() instanceof RevolverItem || equipped.m_41720_() instanceof SpeedloaderItem) {
                        offset -= 65;
                    } else if (equipped.m_41720_() instanceof RailgunItem) {
                        offset -= 50;
                    } else if (equipped.m_41720_() instanceof IEShieldItem) {
                        offset -= 40;
                    }
                    if (!(equipped.m_41720_() instanceof DebugItem)) continue;
                    holdingDebugItem = true;
                }
                matrix.m_85836_();
                int scaledWidth = MCUtil.getWindow().m_85445_();
                int scaledHeight = MCUtil.getWindow().m_85446_();
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                VertexConsumer builder = ItemOverlayUtils.getHudElementsBuilder((MultiBufferSource.BufferSource)buffer);
                int rightOffset = 0;
                if (((Boolean)MCUtil.getOptions().m_231825_().m_231551_()).booleanValue()) {
                    rightOffset += 100;
                }
                float dx = scaledWidth - rightOffset - 16;
                float dy = scaledHeight + offset;
                matrix.m_85836_();
                matrix.m_252880_(dx, dy, 0.0f);
                GuiHelper.drawTexturedRect((VertexConsumer)builder, (PoseStack)matrix, (int)-24, (int)-68, (int)31, (int)62, (float)256.0f, (int)179, (int)210, (int)9, (int)71);
                matrix.m_252880_(-23.0f, -37.0f, 0.0f);
                float capacity = motorboat.getMaxFuel();
                if (capacity > 0.0f) {
                    FluidStack fuel = motorboat.getContainedFluid();
                    int amount = fuel.getAmount();
                    float angle = 83.0f - (float)(166 * amount) / capacity;
                    matrix.m_85836_();
                    matrix.m_252781_(Axis.f_252403_.m_252977_(angle));
                    GuiHelper.drawTexturedRect((VertexConsumer)builder, (PoseStack)matrix, (int)6, (int)-2, (int)24, (int)4, (float)256.0f, (int)91, (int)123, (int)80, (int)87);
                    matrix.m_85849_();
                    matrix.m_252880_(23.0f, 37.0f, 0.0f);
                    GuiHelper.drawTexturedRect((VertexConsumer)builder, (PoseStack)matrix, (int)-41, (int)-73, (int)53, (int)72, (float)256.0f, (int)8, (int)61, (int)4, (int)76);
                }
                matrix.m_85849_();
                buffer.m_109911_();
                if (holdingDebugItem && MCUtil.getFont() != null) {
                    matrix.m_85836_();
                    Font font = MCUtil.getFont();
                    int capacity2 = motorboat.getMaxFuel();
                    FluidStack fs = motorboat.getContainedFluid();
                    int amount = fs == FluidStack.EMPTY || fs.getFluid() == null ? 0 : fs.getAmount();
                    Vec3 vec = motorboat.m_20184_();
                    float speed = (float)Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
                    String[] array = new String[]{String.format(Locale.US, "Fuel: %05d/%d mB (%s)", amount, capacity2, fs.getDisplayName().getString()), String.format(Locale.US, "Speed: %.3f", Float.valueOf(speed)), String.format(Locale.US, "PropXRot: %07.3f\u00c2\u00b0 (%.3frad)", Float.valueOf(motorboat.propellerXRot), Float.valueOf(motorboat.propellerXRot * ((float)Math.PI / 180))), String.format(Locale.US, "PropSpeed: %06.3f\u00c2\u00b0", Float.valueOf(motorboat.propellerXRotSpeed))};
                    int w = 3;
                    int h = 3;
                    for (int i = 0; i < array.length; ++i) {
                        event.getGuiGraphics().m_280488_(font, array[i], w, h + 9 * i, -1);
                    }
                    matrix.m_85849_();
                }
                matrix.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(RenderBlockScreenEffectEvent event) {
        Entity entity;
        Player entity2 = event.getPlayer();
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && entity2.m_6060_() && (entity = entity2.m_20202_()) instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity;
            if (boat.isFireproof) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleFireRender(RenderPlayerEvent.Pre event) {
        Entity entity;
        Player entity2 = event.getEntity();
        if (entity2.m_6060_() && (entity = entity2.m_20202_()) instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity;
            if (boat.isFireproof) {
                entity2.m_20095_();
            }
        }
    }

    @SubscribeEvent
    public void handleLubricatingMachinesClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && MCUtil.getLevel() != null) {
            CommonEventHandler.handleLubricatingMachines((Level)MCUtil.getLevel());
        }
    }
}

