/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class ReservoirType
extends IESerializableRecipe {
    static final Lazy<ItemStack> EMPTY_LAZY = Lazy.of(() -> ItemStack.f_41583_);
    public static Map<ResourceLocation, ReservoirType> map = new HashMap<ResourceLocation, ReservoirType>();
    public final String name;
    public final ResourceLocation fluidLocation;
    public final int weight;
    public final int minSize;
    public final int maxSize;
    public final int residual;
    public final int equilibrium;
    private final Fluid fluid;
    private BWList biomes = new BWList(false);
    private BWList dimensions = new BWList(false);

    public ReservoirType(String name, ResourceLocation id, ResourceLocation fluidLocation, int minSize, int maxSize, int residual, int equilibrium, int weight) {
        this(name, id, (Fluid)ForgeRegistries.FLUIDS.getValue(fluidLocation), minSize, maxSize, residual, equilibrium, weight);
    }

    public ReservoirType(String name, ResourceLocation id, Fluid fluid, int minSize, int maxSize, int residual, int equilibrium, int weight) {
        super(EMPTY_LAZY, IPRecipeTypes.RESERVOIR, id);
        this.name = name;
        this.fluidLocation = RegistryUtils.getRegistryNameOf(fluid);
        this.fluid = fluid;
        this.residual = residual;
        this.equilibrium = equilibrium;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.weight = weight;
    }

    public ReservoirType(CompoundTag nbt) {
        super(EMPTY_LAZY, IPRecipeTypes.RESERVOIR, ResourceLocation.parse((String)nbt.m_128461_("id")));
        this.name = nbt.m_128461_("name");
        this.fluidLocation = ResourceLocation.parse((String)nbt.m_128461_("fluid"));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidLocation);
        this.minSize = nbt.m_128451_("minSize");
        this.maxSize = nbt.m_128451_("maxSize");
        this.residual = nbt.m_128451_("residual");
        this.equilibrium = nbt.m_128451_("equilibrium");
        this.biomes = new BWList(nbt.m_128469_("biomes"));
        this.dimensions = new BWList(nbt.m_128469_("dimensions"));
        this.weight = nbt.m_128451_("weight");
    }

    protected IERecipeSerializer<ReservoirType> getIESerializer() {
        return (IERecipeSerializer)Serializers.RESERVOIR_SERIALIZER.get();
    }

    public CompoundTag writeToNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("id", this.id.toString());
        nbt.m_128359_("fluid", this.fluidLocation.toString());
        nbt.m_128405_("minSize", this.minSize);
        nbt.m_128405_("maxSize", this.maxSize);
        nbt.m_128405_("residual", this.residual);
        nbt.m_128405_("equilibrium", this.equilibrium);
        nbt.m_128365_("biomes", (Tag)this.biomes.toNbt());
        nbt.m_128365_("dimensions", (Tag)this.dimensions.toNbt());
        nbt.m_128405_("weight", this.weight);
        return nbt;
    }

    public void setBiomes(boolean blacklist, ResourceLocation ... names) {
        this.setBiomes(blacklist, Arrays.asList(names));
    }

    public void setBiomes(boolean blacklist, List<ResourceLocation> names) {
        this.biomes = new BWList(new HashSet<ResourceLocation>(names), blacklist);
    }

    public void setDimensions(boolean blacklist, ResourceLocation ... names) {
        this.setDimensions(blacklist, Arrays.asList(names));
    }

    public void setDimensions(boolean blacklist, List<ResourceLocation> names) {
        this.dimensions = new BWList(new HashSet<ResourceLocation>(names), blacklist);
    }

    public Set<ResourceLocation> getBiomeList() {
        return this.biomes.getSet();
    }

    public Set<ResourceLocation> getDimensionList() {
        return this.dimensions.getSet();
    }

    public BWList getDimensions() {
        return this.dimensions;
    }

    public BWList getBiomes() {
        return this.biomes;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public String toString() {
        return this.writeToNBT().toString();
    }

    static Set<ResourceLocation> toSet(ListTag nbtList) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        if (!nbtList.isEmpty()) {
            nbtList.forEach(tag -> {
                if (tag instanceof StringTag) {
                    set.add(ResourceLocation.parse((String)tag.m_7916_()));
                }
            });
        }
        return set;
    }

    static ListTag toNbt(Set<ResourceLocation> set) {
        ListTag nbtList = new ListTag();
        if (!set.isEmpty()) {
            set.forEach(rl -> nbtList.add((Object)StringTag.m_129297_((String)rl.toString())));
        }
        return nbtList;
    }

    public static class BWList {
        private Set<ResourceLocation> set;
        private boolean isBlacklist;

        public BWList(boolean isBlacklist) {
            this(new HashSet<ResourceLocation>(), isBlacklist);
        }

        public BWList(Set<ResourceLocation> set, boolean isBlacklist) {
            this.set = set;
            this.isBlacklist = isBlacklist;
        }

        public BWList(CompoundTag tag) {
            this.isBlacklist = tag.m_128471_("isBlacklist");
            if (tag.m_128425_("list", 9)) {
                ListTag list = tag.m_128437_("list", 8);
                HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
                if (list.size() > 0) {
                    list.forEach(t -> {
                        if (t instanceof StringTag) {
                            set.add(ResourceLocation.parse((String)t.m_7916_()));
                        }
                    });
                }
                this.set = set;
            } else {
                this.set = new HashSet<ResourceLocation>();
            }
        }

        public boolean isBlacklist() {
            return this.isBlacklist;
        }

        public boolean add(ResourceLocation rl) {
            return this.set.add(rl);
        }

        public boolean addAll(Collection<? extends ResourceLocation> c) {
            return this.set.addAll(c);
        }

        public boolean hasEntries() {
            return this.set.size() > 0;
        }

        public boolean valid(ResourceLocation rl) {
            if (this.set.isEmpty()) {
                return true;
            }
            boolean contains = this.set.contains(rl);
            return this.isBlacklist ? !contains : contains;
        }

        public Set<ResourceLocation> getSet() {
            return Collections.unmodifiableSet(this.set);
        }

        public void forEach(Consumer<ResourceLocation> action) {
            this.set.forEach(action);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isBlacklist", this.isBlacklist);
            tag.m_128365_("list", (Tag)this.toNbtList());
            return tag;
        }

        private ListTag toNbtList() {
            ListTag nbtList = new ListTag();
            if (this.hasEntries()) {
                this.set.forEach((? super T rl) -> nbtList.add((Object)StringTag.m_129297_((String)rl.toString())));
            }
            return nbtList;
        }
    }
}

