/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import flaxbeard.immersivepetroleum.api.reservoir.AxisAlignedIslandBB;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ReservoirIsland {
    public static final int MIN_MBPT = 15;
    public static final int MAX_MBPT = 2500;
    public static final long MAX_AMOUNT = 0xFFFFFFFFL;
    private ReservoirRegionDataStorage.RegionData regionData;
    @Nonnull
    private ReservoirType reservoir;
    @Nonnull
    private List<ColumnPos> poly;
    private AxisAlignedIslandBB islandAABB;
    private long amount;
    private long capacity;
    private long lastEquilibriumTick = -1L;

    private ReservoirIsland() {
    }

    public ReservoirIsland(@Nonnull List<ColumnPos> poly, @Nonnull ReservoirType reservoir, long amount) {
        Objects.requireNonNull(poly);
        Objects.requireNonNull(reservoir);
        this.poly = poly;
        this.reservoir = reservoir;
        this.setAmountAndCapacity(amount, amount);
        this.createBoundingBox();
    }

    void createBoundingBox() {
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ColumnPos p : this.poly) {
            if (p.f_140723_() < minX) {
                minX = p.f_140723_();
            }
            if (p.f_140724_() < minZ) {
                minZ = p.f_140724_();
            }
            if (p.f_140723_() > maxX) {
                maxX = p.f_140723_();
            }
            if (p.f_140724_() <= maxZ) continue;
            maxZ = p.f_140724_();
        }
        this.islandAABB = new AxisAlignedIslandBB(minX, minZ, maxX, maxZ);
    }

    public void setRegion(ReservoirRegionDataStorage.RegionData data) {
        if (this.regionData == null) {
            this.regionData = data;
        }
    }

    public ReservoirIsland setAmountAndCapacity(long amount, long capacity) {
        this.setCapacity(capacity);
        this.setAmount(amount);
        return this;
    }

    public ReservoirIsland setAmount(long amount) {
        this.amount = ReservoirIsland.clamp(amount, 0L, this.capacity);
        return this;
    }

    public ReservoirIsland setCapacity(long capacity) {
        this.capacity = ReservoirIsland.clamp(capacity, 0L, 0xFFFFFFFFL);
        return this;
    }

    public static long clamp(long num, long min, long max) {
        return Math.max(min, Math.min(max, num));
    }

    public ReservoirIsland setReservoirType(@Nonnull ReservoirType reservoir) {
        this.reservoir = Objects.requireNonNull(reservoir);
        return this;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.amount <= 0L;
    }

    public void setDirty() {
        if (this.regionData != null) {
            this.regionData.m_77762_();
        }
    }

    @Nonnull
    public ReservoirType getType() {
        return this.reservoir;
    }

    public Fluid getFluid() {
        return this.reservoir.getFluid();
    }

    public AxisAlignedIslandBB getBoundingBox() {
        return this.islandAABB;
    }

    public List<ColumnPos> getPolygon() {
        return Collections.unmodifiableList(this.poly);
    }

    public boolean belowHydrostaticEquilibrium(@Nonnull Level level) {
        return this.reservoir.residual > 0 && this.amount <= (long)this.reservoir.equilibrium && this.lastEquilibriumTick != level.m_46467_();
    }

    public void equalizeHydrostaticPressure(@Nonnull Level level) {
        if (this.amount <= (long)this.reservoir.equilibrium && this.lastEquilibriumTick != level.m_46467_()) {
            this.lastEquilibriumTick = level.m_46467_();
            this.amount += (long)this.reservoir.residual;
        }
    }

    public int extract(int amount, IFluidHandler.FluidAction fluidAction) {
        if (this.isEmpty()) {
            return 0;
        }
        int extracted = (int)Math.min((long)amount, this.amount);
        if (fluidAction == IFluidHandler.FluidAction.EXECUTE) {
            this.amount -= (long)extracted;
            this.setDirty();
        }
        return extracted;
    }

    public int extractWithPressure(@Nonnull Level world, int x, int z) {
        float pressure = this.getPressure(world, x, z);
        if ((double)pressure > 0.0 && this.amount > 0L) {
            int flow = (int)Math.min((long)ReservoirIsland.getFlow(pressure), this.amount);
            this.amount -= (long)flow;
            this.setDirty();
            return flow;
        }
        return 0;
    }

    public int getFlowFromPressure(@Nonnull Level level, BlockPos pos) {
        float pressure = this.getPressure(level, pos.m_123341_(), pos.m_123343_());
        return ReservoirIsland.getFlow(pressure);
    }

    public static int getFlow(float pressure) {
        return 15 + (int)Math.floor(2485.0f * Mth.m_14036_((float)pressure, (float)0.0f, (float)1.0f));
    }

    public float getPressure(@Nonnull Level level, int x, int z) {
        double half;
        double alt;
        double noise = ReservoirHandler.getValueOf(level, x, z);
        if (noise > 0.0 && (alt = (double)this.amount - (half = (double)this.capacity * 0.5)) > 0.0) {
            double pre = alt / half;
            return (float)(pre * noise);
        }
        return 0.0f;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("reservoir", this.reservoir.m_6423_().toString());
        nbt.m_128405_("amount", (int)(this.getAmount() & 0xFFFFFFFFL));
        nbt.m_128405_("capacity", (int)(this.getCapacity() & 0xFFFFFFFFL));
        nbt.m_128365_("bounds", (Tag)this.getBoundingBox().writeToNBT());
        AxisAlignedIslandBB bounds = this.getBoundingBox();
        ListTag points = new ListTag();
        this.poly.forEach(pos -> {
            byte x = (byte)(pos.f_140723_() - bounds.minX & 0xFF);
            byte z = (byte)(pos.f_140724_() - bounds.minZ & 0xFF);
            CompoundTag point = new CompoundTag();
            point.m_128344_("x", x);
            point.m_128344_("z", z);
            points.add((Object)point);
        });
        nbt.m_128365_("points", (Tag)points);
        return nbt;
    }

    public static ReservoirIsland readFromNBT(CompoundTag nbt) {
        try {
            ReservoirType reservoir = ReservoirType.map.get(ResourceLocation.parse((String)nbt.m_128461_("reservoir")));
            if (reservoir != null) {
                long amount = (long)nbt.m_128451_("amount") & 0xFFFFFFFFL;
                long capacity = (long)nbt.m_128451_("capacity") & 0xFFFFFFFFL;
                AxisAlignedIslandBB bounds = new AxisAlignedIslandBB(nbt.m_128469_("bounds"));
                ArrayList<ColumnPos> points = new ArrayList<ColumnPos>();
                ListTag list = nbt.m_128437_("points", 10);
                list.forEach(tag -> {
                    CompoundTag point = (CompoundTag)tag;
                    int x = bounds.minX + (point.m_128445_("x") & 0xFF);
                    int z = bounds.minZ + (point.m_128445_("z") & 0xFF);
                    points.add(new ColumnPos(x, z));
                });
                ReservoirIsland island = new ReservoirIsland();
                island.reservoir = reservoir;
                island.amount = amount;
                island.capacity = capacity;
                island.poly = points;
                island.islandAABB = bounds;
                return island;
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean contains(ColumnPos pos) {
        return this.contains(pos.f_140723_(), pos.f_140724_());
    }

    public boolean contains(int x, int z) {
        if (!this.islandAABB.contains(x, z)) {
            return false;
        }
        return this.polygonContains(x, z);
    }

    public boolean polygonContains(ColumnPos pos) {
        return this.polygonContains(pos.f_140723_(), pos.f_140724_());
    }

    public boolean polygonContains(int x, int z) {
        boolean ret = false;
        int j = this.poly.size() - 1;
        int i = 0;
        while (i < this.poly.size()) {
            ColumnPos a = this.poly.get(i);
            ColumnPos b = this.poly.get(j);
            float ax = a.f_140723_();
            float az = a.f_140724_();
            float bx = b.f_140723_();
            float bz = b.f_140724_();
            if (ax == (float)x && az == (float)z) {
                return false;
            }
            if (ax == (float)x && bx == (float)x && ((float)z > bz && (float)z < az || (float)z > az && (float)z < bz)) {
                return false;
            }
            if (az == (float)z && bz == (float)z && ((float)x > ax && (float)x < bx || (float)x > bx && (float)x < ax)) {
                return false;
            }
            if ((az < (float)z && bz >= (float)z || bz < (float)z && az >= (float)z) && (ax <= (float)x || bx <= (float)x)) {
                float f0 = ax + ((float)z - az) / (bz - az) * (bx - ax);
                ret ^= f0 < (float)x;
            }
            j = i++;
        }
        return ret;
    }
}

