/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class AxisAlignedIslandBB {
    final int minX;
    final int minZ;
    final int maxX;
    final int maxZ;
    final BlockPos center;

    public AxisAlignedIslandBB(int minX, int minZ, int maxX, int maxZ) {
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.center = new BlockPos((this.minX + this.maxX) / 2, 0, (this.minZ + this.maxZ) / 2);
    }

    public AxisAlignedIslandBB(CompoundTag nbt) {
        this(nbt.m_128451_("minX"), nbt.m_128451_("minZ"), nbt.m_128451_("maxX"), nbt.m_128451_("maxZ"));
    }

    public int minX() {
        return this.minX;
    }

    public int maxX() {
        return this.maxX;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.m_123341_(), pos.m_123343_());
    }

    public boolean contains(int x, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
    }

    public CompoundTag writeToNBT() {
        CompoundTag bounds = new CompoundTag();
        bounds.m_128405_("minX", this.minX);
        bounds.m_128405_("minZ", this.minZ);
        bounds.m_128405_("maxX", this.maxX);
        bounds.m_128405_("maxZ", this.maxZ);
        return bounds;
    }

    public int hashCode() {
        return Objects.hash(this.maxX, this.maxZ, this.minX, this.minZ);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AxisAlignedIslandBB)) {
            return false;
        }
        AxisAlignedIslandBB other = (AxisAlignedIslandBB)obj;
        return this.maxX == other.maxX && this.maxZ == other.maxZ && this.minX == other.minX && this.minZ == other.minZ;
    }

    public String toString() {
        return String.format("IslandAxisAlignedBB [minX = %d, minZ = %d, maxX = %d, maxZ = %d]", this.minX, this.minZ, this.maxX, this.maxZ);
    }

    @Deprecated(forRemoval=true)
    public static AxisAlignedIslandBB readFromNBT(CompoundTag nbt) {
        return new AxisAlignedIslandBB(nbt);
    }
}

