/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class LubricatedHandler {
    static final Map<Class<? extends IMultiblockLogic<? extends IMultiblockState>>, ILubricationHandler<? extends IMultiblockBEHelper<?>, ? extends IMultiblockState>> lubricationHandlers = new HashMap();
    public static List<LubricatedTileInfo> lubricatedTiles = new ArrayList<LubricatedTileInfo>();

    public static <S extends IMultiblockState, L extends IMultiblockLogic<S>> void register(MultiblockRegistration<S> mbReg, Supplier<ILubricationHandler<?, S>> handler) {
        lubricationHandlers.put(mbReg.logic().getClass(), handler.get());
    }

    public static <T extends IMultiblockBEHelper<?>> ILubricationHandler<?, ?> getHandlerForTile(T te) {
        if (te != null) {
            IMultiblockLogic logic = te.getMultiblock().logic();
            return lubricationHandlers.get(logic.getClass());
        }
        return null;
    }

    public static boolean lubricateTile(Level level, BlockPos pos, Fluid lubricant, int ticks) {
        return LubricatedHandler.lubricateTile(level, pos, lubricant, ticks, false, -1);
    }

    public static boolean lubricateTile(Level level, BlockPos pos, Fluid lubricant, int ticks, boolean additive, int cap) {
        MultiblockBlockEntityMaster<?> mbMasterBE = Utils.getMultiblockMasterBE(level, pos);
        if (mbMasterBE == null) {
            return false;
        }
        if (LubricatedHandler.getHandlerForTile(mbMasterBE.getHelper()) == null) {
            return false;
        }
        pos = mbMasterBE.m_58899_();
        ResourceKey key = level.m_46472_();
        for (LubricatedTileInfo info : lubricatedTiles) {
            if (!info.pos.equals((Object)pos) || info.world != key) continue;
            if (info.ticks >= ticks) {
                if (additive) {
                    info.ticks = cap == -1 ? (info.ticks += ticks) : Math.min(cap, info.ticks + ticks);
                    return true;
                }
                return false;
            }
            info.ticks = ticks;
            return true;
        }
        LubricatedTileInfo lti = new LubricatedTileInfo((ResourceKey<Level>)level.m_46472_(), pos, lubricant, ticks);
        lubricatedTiles.add(lti);
        return true;
    }

    public static interface ILubricationHandler<E extends IMultiblockBEHelperMaster<B>, B extends IMultiblockState> {
        public boolean isPlacedCorrectly(Level var1, BlockPos var2, Direction var3);

        public GhostInfo getGhostBlockPosition(Level var1, E var2);

        public boolean isMachineEnabled(Level var1, E var2);

        @OnlyIn(value=Dist.CLIENT)
        public void lubricateClient(ClientLevel var1, Fluid var2, int var3, E var4);

        public void lubricateServer(ServerLevel var1, Fluid var2, int var3, E var4);

        public void spawnLubricantParticles(ClientLevel var1, BlockPos var2, Direction var3, E var4);

        @OnlyIn(value=Dist.CLIENT)
        public void renderPipes(AutoLubricatorTileEntity var1, E var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

        public record GhostInfo(BlockPos position, Direction facing) {
        }
    }

    public static class LubricatedTileInfo {
        public BlockPos pos;
        public ResourceKey<Level> world;
        public Fluid lubricant = Fluids.f_76191_;
        public int ticks;

        public LubricatedTileInfo(ResourceKey<Level> registryKey, BlockPos pos, Fluid lubricant, int ticks) {
            this.world = registryKey;
            this.pos = pos;
            this.ticks = ticks;
            if (lubricant != null && lubricant != Fluids.f_76191_) {
                this.lubricant = lubricant;
            }
        }

        public LubricatedTileInfo(CompoundTag tag) {
            int ticks = tag.m_128451_("ticks");
            int x = tag.m_128451_("x");
            int y = tag.m_128451_("y");
            int z = tag.m_128451_("z");
            String name = tag.m_128461_("world");
            String lubricantName = tag.m_128461_("lubricant");
            this.world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)name));
            this.pos = new BlockPos(x, y, z);
            this.ticks = ticks;
            this.lubricant = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.parse((String)lubricantName));
            if (this.lubricant == null) {
                this.lubricant = Fluids.f_76191_;
            }
        }

        public CompoundTag writeToNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("ticks", this.ticks);
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            tag.m_128359_("world", this.world.m_135782_().toString());
            tag.m_128359_("lubricant", ForgeRegistries.FLUIDS.getKey((Object)this.lubricant).toString());
            return tag;
        }
    }

    public static class LubricantEffect
    extends ChemthrowerHandler.ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, Player shooter, ItemStack thrower, Fluid fluid) {
            if (!(target instanceof IronGolem) && !LubricantHandler.isValidLube(fluid)) {
                return;
            }
            int ticks = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 4 / 3;
            MobEffectInstance activeSpeed = target.m_21124_(MobEffects.f_19596_);
            int ticksSpeed = ticks;
            if (activeSpeed != null && activeSpeed.m_19564_() <= 1) {
                ticksSpeed = Math.min(activeSpeed.m_19557_() + ticks, 1200);
            }
            MobEffectInstance activeStrength = target.m_21124_(MobEffects.f_19600_);
            int ticksStrength = ticks;
            if (activeStrength != null && activeStrength.m_19564_() <= 1) {
                ticksStrength = Math.min(activeStrength.m_19557_() + ticks, 1200);
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, ticksSpeed, 1));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, ticksStrength, 1));
        }

        public void applyToBlock(Level level, HitResult hit, Player shooter, ItemStack thrower, Fluid fluid) {
            if (!LubricantHandler.isValidLube(fluid)) {
                return;
            }
            int amount = Math.max(1, (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() / LubricantHandler.getLubeAmount(fluid)) * 2 / 3;
            LubricatedHandler.lubricateTile(level, BlockPos.m_274446_((Position)hit.m_82450_()), fluid, amount, true, 1200);
        }
    }
}

