/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class HighPressureRefineryRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, HighPressureRefineryRecipe> recipes = new HashMap<ResourceLocation, HighPressureRefineryRecipe>();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final ItemStack outputItem;
    private final double chance;
    private final FluidStack output;
    private final FluidTagInput inputFluid;
    @Nullable
    private final FluidTagInput inputFluidSecondary;

    public static HighPressureRefineryRecipe findRecipe(@Nonnull FluidStack input, @Nonnull FluidStack secondary) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(secondary);
        for (HighPressureRefineryRecipe recipe : recipes.values()) {
            if (!(secondary.isEmpty() ? recipe.inputFluidSecondary == null && recipe.inputFluid != null && recipe.inputFluid.test(input) : recipe.inputFluid != null && recipe.inputFluid.test(input) && recipe.inputFluidSecondary != null && recipe.inputFluidSecondary.test(secondary))) continue;
            return recipe;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (HighPressureRefineryRecipe recipe : recipes.values()) {
                if (recipe.inputFluid == null || (ignoreAmount || !recipe.inputFluid.test(fluid)) && (!ignoreAmount || !recipe.inputFluid.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithSecondaryInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (HighPressureRefineryRecipe recipe : recipes.values()) {
                if (recipe.inputFluidSecondary == null || (ignoreAmount || !recipe.inputFluidSecondary.test(fluid)) && (!ignoreAmount || !recipe.inputFluidSecondary.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public HighPressureRefineryRecipe(ResourceLocation id, FluidStack output, ItemStack outputItem, FluidTagInput inputFluid, @Nullable FluidTagInput inputFluidSecondary, double chance, int energy, int time) {
        super(IPRecipeTypes.HYDROTREATER, id, time, energy);
        this.output = output;
        this.outputItem = outputItem;
        this.inputFluid = inputFluid;
        this.inputFluidSecondary = inputFluidSecondary;
        this.chance = Mth.m_14008_((double)chance, (double)0.0, (double)1.0);
        this.fluidOutputList = Collections.singletonList(output);
        ArrayList<FluidTagInput> inputs = new ArrayList<FluidTagInput>(2);
        inputs.add(inputFluid);
        if (inputFluidSecondary != null) {
            inputs.add(inputFluidSecondary);
        }
        this.fluidInputList = inputs;
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.hydrotreater_timeModifier.get(), () -> IPServerConfig.REFINING.hydrotreater_energyModifier.get());
    }

    public FluidStack getOutputFluid() {
        return this.output.copy();
    }

    public FluidTagInput getPrimaryInputFluid() {
        return this.inputFluid;
    }

    public boolean hasSecondaryItem() {
        return this.outputItem != null && !this.outputItem.m_41619_();
    }

    @Nullable
    public FluidTagInput getSecondaryInputFluid() {
        return this.inputFluidSecondary;
    }

    public ItemStack getOutputItem() {
        if (!this.hasSecondaryItem()) {
            return ItemStack.f_41583_;
        }
        return this.outputItem.m_41777_();
    }

    public double getOutputItemChance() {
        return this.chance;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.m_122779_();
        if (this.hasSecondaryItem() && (this.chance == 1.0 || (double)RANDOM.m_188501_() <= this.chance)) {
            list.add((Object)this.outputItem.m_41777_());
        }
        return list;
    }

    protected IERecipeSerializer<HighPressureRefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get();
    }
}

